% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SnnsR_createNets.R
\name{SnnsRObject$createNet}
\alias{SnnsRObject$createNet}
\alias{SnnsR__createNet}
\alias{createNet,SnnsR-method}
\title{Create a layered network}
\usage{
\S4method{createNet}{SnnsR}(unitsPerLayer, fullyConnectedFeedForward = TRUE, iNames = NULL, oNames = NULL)
}
\arguments{
\item{unitsPerLayer}{a vector of integers that represents the number of units in each layer, including input and output layer}

\item{fullyConnectedFeedForward}{if \code{TRUE}, the network is fully connected as a feed-forward network. If \code{FALSE},
no connections are created}

\item{iNames}{names of input units}

\item{oNames}{names of output units}
}
\description{
This function creates a layered network in the given SnnsR object.
This is an SnnsR low-level function. You may want to have a look
at \code{\link{SnnsR-class}} to find out how to properly use it.
}
\examples{
obj1 <- SnnsRObjectFactory()
obj1$createNet(c(2,2), FALSE)
obj1$getUnitDefinitions()

obj2 <- SnnsRObjectFactory()
obj2$createNet(c(8,5,5,2), TRUE)
obj2$getUnitDefinitions()
}
\seealso{
\code{\link{SnnsR-class}}
}

