% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\docType{methods}
\name{dbDataType,SQLiteDriver-method}
\alias{dbDataType,SQLiteDriver-method}
\alias{dbDataType,SQLiteConnection-method}
\title{Determine the SQL Data Type of an R object}
\usage{
\S4method{dbDataType}{SQLiteDriver}(dbObj, obj, ...)

\S4method{dbDataType}{SQLiteConnection}(dbObj, obj, ...)
}
\arguments{
\item{dbObj}{a \code{SQLiteConnection} or \code{SQLiteDriver} object}

\item{obj}{an R object whose SQL type we want to determine.}

\item{...}{Needed for compatibility with generic. Otherwise ignored.}
}
\description{
Given an object, return its SQL data type as a SQL database identifier.
}
\examples{
library(DBI)
dbDataType(RSQLite::SQLite(), 1)
dbDataType(RSQLite::SQLite(), 1L)
dbDataType(RSQLite::SQLite(), "1")
dbDataType(RSQLite::SQLite(), TRUE)
dbDataType(RSQLite::SQLite(), list(raw(1)))

sapply(datasets::quakes, dbDataType, dbObj = RSQLite::SQLite())
}
\seealso{
The corresponding generic function \code{\link[DBI:dbDataType]{DBI::dbDataType()}}.
}

