% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisticLossClassifier.R
\name{LogisticLossClassifier}
\alias{LogisticLossClassifier}
\title{Logistic Loss Classifier}
\usage{
LogisticLossClassifier(X, y, lambda = 0, intercept = TRUE, scale = FALSE,
  init = NA, x_center = FALSE, ...)
}
\arguments{
\item{X}{Design matrix, intercept term is added within the function}

\item{y}{Vector with class assignments}

\item{lambda}{Regularization parameter used for l2 regularization}

\item{intercept}{TRUE if an intercept should be added to the model}

\item{scale}{If TRUE, apply a z-transform to all observations in X and X_u before running the regression}

\item{init}{Starting parameter vector for gradient descent}

\item{x_center}{logical; Whether the feature vectors should be centered}

\item{...}{additional arguments}
}
\value{
S4 object with the following slots
\item{w}{the weight vector of the linear classifier}
\item{classnames}{vector with names of the classes}
}
\description{
Find the linear classifier which minimizing the logistic loss on the training set, optionally using L2 regularization.
}
\seealso{
Other RSSL classifiers: \code{\link{EMLinearDiscriminantClassifier}},
  \code{\link{GRFClassifier}},
  \code{\link{ICLeastSquaresClassifier}},
  \code{\link{ICLinearDiscriminantClassifier}},
  \code{\link{KernelLeastSquaresClassifier}},
  \code{\link{LaplacianKernelLeastSquaresClassifier}},
  \code{\link{LaplacianSVM}},
  \code{\link{LeastSquaresClassifier}},
  \code{\link{LinearDiscriminantClassifier}},
  \code{\link{LinearSVM}}, \code{\link{LinearTSVM}},
  \code{\link{LogisticRegression}},
  \code{\link{MCLinearDiscriminantClassifier}},
  \code{\link{MCNearestMeanClassifier}},
  \code{\link{MCPLDA}},
  \code{\link{MajorityClassClassifier}},
  \code{\link{NearestMeanClassifier}},
  \code{\link{QuadraticDiscriminantClassifier}},
  \code{\link{S4VM}}, \code{\link{SVM}},
  \code{\link{SelfLearning}}, \code{\link{TSVM}},
  \code{\link{USMLeastSquaresClassifier}},
  \code{\link{WellSVM}}, \code{\link{svmlin}}
}

