% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KernelICLeastSquaresClassifier.R
\name{KernelICLeastSquaresClassifier}
\alias{KernelICLeastSquaresClassifier}
\title{Kernelized Implicitly Constrained Least Squares Classification}
\usage{
KernelICLeastSquaresClassifier(X, y, X_u, lambda = 0,
  kernel = vanilladot(), x_center = TRUE, scale = TRUE,
  y_scale = TRUE, lambda_prior = 0, classprior = 0,
  method = "LBFGS", projection = "semisupervised")
}
\arguments{
\item{X}{matrix; Design matrix for labeled data}

\item{y}{factor or integer vector; Label vector}

\item{X_u}{matrix; Design matrix for unlabeled data}

\item{lambda}{numeric; L2 regularization parameter}

\item{kernel}{kernlab::kernel to use}

\item{x_center}{logical;  Should the features be centered?}

\item{scale}{logical; Should the features be normalized? (default: FALSE)}

\item{y_scale}{logical; whether the target vector should be centered}

\item{lambda_prior}{numeric; regularization parameter for the posterior deviation from the prior}

\item{classprior}{The classprior used to compare the estimated responsilibities to}

\item{method}{character; Estimation method. One of c("LBFGS")}

\item{projection}{character; The projection used. One of c("supervised","semisupervised")}
}
\description{
A kernel version of the implicitly constrained least squares classifier, see \code{\link{ICLeastSquaresClassifier}}.
}
