% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCAuth.R
\name{SCAuth}
\alias{SCAuth}
\title{Store Credentials for the Adobe Analytics API}
\usage{
SCAuth(key, secret, company = "", token.file = "", auth.method = "legacy",
  debug.mode = FALSE, endpoint = "", locale = "en_US")
}
\arguments{
\item{key}{Client id from your app in the Adobe Marketing cloud Dev Center OR if you are using auth.method='legacy', then this is the API username (username:company)}

\item{secret}{Secret from your app in the Adobe Marketing cloud Dev Center OR if you are using auth.method='legacy', then this is the API shared secret}

\item{company}{Your company (only required if using OAUTH2 AUTH method)}

\item{token.file}{If you would like to save your OAUTH token and other auth details for use in 
future sessions, specify a file here. The method checks for the existence of the file and uses that if available.}

\item{auth.method}{Defaults to legacy, can be set to 'OAUTH2' to use the newer OAUTH method.}

\item{debug.mode}{Set global debug mode}

\item{endpoint}{Set Adobe Analytics API endpoint rather than let RSiteCatalyst decide (not recommended)}

\item{locale}{Set encoding for reports (defaults to en_US)}
}
\value{
Global credentials list 'SC.Credentials' in AdobeAnalytics (hidden) environment
}
\description{
SCAuth
}
\details{
Authorise and store credentials for the Adobe Analytics API
}
\examples{
\dontrun{
#Legacy authentication
SCAuth("key", "secret")

}

}
\references{
The list of locale values can be obtained from the Adobe Analytics documentation:

https://marketing.adobe.com/developer/documentation/analytics-reporting-1-4/r-reportdescriptionlocale
}
