% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tva.R
\name{extract,stantvafit-method}
\alias{extract,stantvafit-method}
\title{Extract samples from a fitted RStanTVA model}
\usage{
\S4method{extract}{stantvafit}(object, pars, ...)
}
\arguments{
\item{object}{The RStanTVA fit.}

\item{pars}{(Optional) A character vector of variable names to extract.}

\item{...}{Additional arguments passed to \code{\link[rstan:extract]{rstan::extract()}}, e.g. \code{permuted} and \code{inc_warmup}.}
}
\value{
See \code{\link[rstan:extract]{rstan::extract()}} for details.
}
\description{
Returns posterior samples from a fitted RStanTVA model.
}
\examples{
\donttest{
f <- read_stantva_fit("fit.rds")
extract(f, "C_Intercept")
}
}
