GetBitmapImage <- function(type) {
  # Create small bitmap icon images
  # Bitmap editor: http://www.posoft.de/html/poBitmapMain.html

  bits <- list()

  bits[["left"]]      <- c('0x00', '0x00', '0x20', '0x00', '0x30', '0x00',
                           '0x38', '0x00', '0xfc', '0x01', '0xfe', '0x01',
                           '0xfc', '0x01', '0x38', '0x00', '0x30', '0x00',
                           '0x20', '0x00', '0x00', '0x00')
  bits[["right"]]     <- c('0x00', '0x00', '0x20', '0x00', '0x60', '0x00',
                           '0xe0', '0x00', '0xfc', '0x01', '0xfc', '0x03',
                           '0xfc', '0x01', '0xe0', '0x00', '0x60', '0x00',
                           '0x20', '0x00', '0x00', '0x00')
  bits[["up"]]        <- c('0x00', '0x00', '0x20', '0x00', '0x70', '0x00',
                           '0xf8', '0x00', '0xfc', '0x01', '0xfe', '0x03',
                           '0x70', '0x00', '0x70', '0x00', '0x70', '0x00',
                           '0x00', '0x00', '0x00', '0x00')
  bits[["down"]]      <- c('0x00', '0x00', '0x00', '0x00', '0x70', '0x00',
                           '0x70', '0x00', '0x70', '0x00', '0xfe', '0x03',
                           '0xfc', '0x01', '0xf8', '0x00', '0x70', '0x00',
                           '0x20', '0x00', '0x00', '0x00')
  bits[["top"]]       <- c('0x00', '0x00', '0xfe', '0x03', '0xfe', '0x03',
                           '0x20', '0x00', '0x70', '0x00', '0xf8', '0x00',
                           '0xfc', '0x01', '0xfe', '0x03', '0x70', '0x00',
                           '0x70', '0x00', '0x70', '0x00')
  bits[["bottom"]]    <- c('0x70', '0x00', '0x70', '0x00', '0x70', '0x00',
                           '0xfe', '0x03', '0xfc', '0x01', '0xf8', '0x00',
                           '0x70', '0x00', '0x20', '0x00', '0xfe', '0x03',
                           '0xfe', '0x03', '0x00', '0x00')
  bits[["upleft"]]    <- c('0x00', '0x00', '0x7e', '0x00', '0x3e', '0x00',
                           '0x3e', '0x00', '0x7e', '0x00', '0xfe', '0x00',
                           '0xf2', '0x01', '0xe0', '0x00', '0x40', '0x00',
                           '0x00', '0x00', '0x00', '0x00')
  bits[["upright"]]   <- c('0x00', '0x00', '0xf0', '0x03', '0xe0', '0x03',
                           '0xe0', '0x03', '0xf0', '0x03', '0xf8', '0x03',
                           '0x7c', '0x02', '0x38', '0x00', '0x10', '0x00',
                           '0x00', '0x00', '0x00', '0x00')
  bits[["downleft"]]  <- c('0x00', '0x00', '0x00', '0x00', '0x40', '0x00',
                           '0xe0', '0x00', '0xf2', '0x01', '0xfe', '0x00',
                           '0x7e', '0x00', '0x3e', '0x00', '0x3e', '0x00',
                           '0x7e', '0x00', '0x00', '0x00')
  bits[["downright"]] <- c('0x00', '0x00', '0x00', '0x00', '0x10', '0x00',
                           '0x38', '0x00', '0x7c', '0x02', '0xf8', '0x03',
                           '0xf0', '0x03', '0xe0', '0x03', '0xe0', '0x03',
                           '0xf0', '0x03', '0x00', '0x00')
  bits[["copy"]]      <- c('0x00', '0x00', '0x7e', '0x00', '0x42', '0x00',
                           '0xf2', '0x03', '0x12', '0x02', '0x12', '0x02',
                           '0x12', '0x02', '0x1e', '0x02', '0x10', '0x02',
                           '0xf0', '0x03', '0x00', '0x00')
  bits[["paste"]]     <- c('0x10', '0x00', '0xfe', '0x00', '0xba', '0x00',
                           '0x82', '0x00', '0xe2', '0x07', '0xe2', '0x07',
                           '0xe2', '0x07', '0xe2', '0x07', '0xfe', '0x07',
                           '0xe0', '0x07', '0xe0', '0x07')
  bits[["find"]]      <- c('0x3c', '0x00', '0x42', '0x00', '0x81', '0x00',
                           '0x81', '0x00', '0x81', '0x00', '0x81', '0x00',
                           '0x42', '0x00', '0xbc', '0x01', '0x80', '0x03',
                           '0x00', '0x07', '0x00', '0x06')
  bits[["delete"]]    <- c('0x00', '0x00', '0x06', '0x03', '0x8e', '0x03',
                           '0xdc', '0x01', '0xf8', '0x00', '0x70', '0x00',
                           '0xf8', '0x00', '0xdc', '0x01', '0x8e', '0x03',
                           '0x06', '0x03', '0x00', '0x00')

  if (!is.character(type) || !type %in% names(bits))
    stop("Requested bitmap image does not exist")

  n <- length(bits[[type]]) / 2L
  bits.str <- paste("#define v_width ", n, "\n#define v_height ", n, "\n",
                    "static unsigned char v_bits[] = { ",
                    paste(bits[[type]], collapse=", "), " }; ", sep="")

  tkimage.create("bitmap", data=as.tclObj(bits.str))
}
