% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EditText.R
\name{EditText}
\alias{EditText}
\title{GUI: Edit Text}
\usage{
EditText(txt, read.only = FALSE, win.title = "View Text",
  is.fixed.width.font = FALSE, parent = NULL)
}
\arguments{
\item{txt}{character.
Text used to populate the window.}

\item{read.only}{logical.
Specifies whether the text is read only.}

\item{win.title}{character.
Title of the dialog box.}

\item{is.fixed.width.font}{logical.
Specifies whether a fixed-width font be used.}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Returns an object of class character with edited text.
}
\description{
A graphical user interface (\acronym{GUI}) for viewing and editing text.
}
\examples{
\dontrun{
  txt <- c("\\"Hills cherish the ambition",
           "    to turn into partial",
           "   differential equations\\"",
           "",
           "        -Donald Hall")
  new.txt <- EditText(txt, is.fixed.width.font = TRUE)

  EditText(txt, read.only = TRUE)
}

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{misc}
