% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportText.R
\name{ImportText}
\alias{ImportText}
\title{GUI: Import Data from Text File}
\usage{
ImportText(parent = NULL)
}
\arguments{
\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Sets the following components in \code{\link{Data}}:
  \item{data.raw}{imported data table.}
  \item{cols}{a list with length equal to the current number of data variables.
    Each component in \code{cols} is linked to a specific variable,
    see \code{\link{ManageVariables}}.}
  \item{comment}{vector of comment strings}
  \item{import}{a list of saved \acronym{GUI} options}
  Components of the \code{import} list include:
  \item{source}{a vector of length 2 that includes the pathname of the text file and access date.}
  \item{fmts}{indicates whether the file contains the conversion specification format strings of the variables.}
  \item{cols}{indicates whether the file contains the names of the variables.}
  \item{skip}{Number of lines skipped before data is read.}
  \item{sep}{Field separator string}
  \item{dec}{Used in the file for decimal points.}
  \item{na}{String interpreted as \code{\link{NA}} values.}
  \item{quote}{Set of quoting characters}
  \item{comment}{Comment character}
  \item{encoding}{Encoding that was assumed for input strings, see \code{\link{Encoding}}.}
  \item{str.as.fact}{If true, character variables are converted to factors.}
}
\description{
A graphical user interface (\acronym{GUI}) for reading table formatted data from a text file.
}
\details{
This \acronym{GUI} is a wrapper for the \code{\link[utils]{read.table}} function.
  Data connections are defined as the path to the file to be opened,
  a complete \acronym{URL} (e.g. http://, https://, ftp:// or file://), or windows clipboard.
  Files are limited to text format (e.g., \file{.tsv} \file{.csv}, or \file{.txt});
  however, they can be compressed by \href{http://www.gzip.org/}{gzip}, \href{http://www.bzip.org/}{bzip2},
  or \href{http://tukaani.org/xz/format.html}{xz} with additional extension
  \file{.gz}, \file{.bz2}, or \file{.xz}, respectively.

  Conversion specification formats are the character representation of object types used to:
  identify column classes prior to reading in data, and format values for printing.
  Conversion specifications are based on C-style string formatting commands for
  \code{numeric}, \code{integer}, and \code{character} object classes, see \code{\link{sprintf}};
  for example, a format string of "%.5f" applied to the mathematical constant \emph{pi} results in "3.14159".
  Calendar date and time objects of class \code{POSIXct} are defined by the ISO C99 / POSIX standard, see \code{\link{strftime}};
  for example, "02/26/2010 02:05:39 PM" is represented using "%d/%m/%Y %I:%M:%S %p".

  Comments located above data records and header lines are preserved; all other comments are ignored.
  Requires the specification of a comment character.

  Performance issues associated with reading in large files can be alleviated by specifying formats in a header line,
  and giving the maximum number of rows to read in.
}
\note{
Requires the Tcl package \href{http://tktable.sourceforge.net/}{Tktable}.
}
\examples{
\dontrun{
  ImportText()
}

}
\seealso{
\code{\link[utils]{read.table}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{IO}
