% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetSortOrder.R
\name{SetSortOrder}
\alias{SetSortOrder}
\title{GUI: Sort Order}
\usage{
SetSortOrder(col.ids, sort.on = NULL, parent = NULL)
}
\arguments{
\item{col.ids}{character.
Vector of variable names}

\item{sort.on}{integer.
Index for the variable used to sort the data set.}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Returns an object of integer class that specifies the index of the variable used to sort the data set.
  Attributes for this object include:
  \code{decreasing}, a logical value indicating if the sort order is increasing or decreasing; and
  \code{na.last}, a logical value for controlling the treatment of \code{NA}s during sorting.
  If true, missing values in the data are put last; otherwise, they are put first;
  if \code{NA}, they are removed.
}
\description{
A graphical user interface (\acronym{GUI}) for specifying the variable used to sort the data set.
}
\examples{
\dontrun{
  col.ids <- c("Variable1", "Variable2", "Variable3")
  sort.on <- 2
  attr(sort.on, "decreasing") <- TRUE
  attr(sort.on, "na.last") <- FALSE
  SetSortOrder(col.ids, sort.on)
}

}
\seealso{
\code{\link{order}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{misc}
