% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetAxesLimits.R
\name{SetAxesLimits}
\alias{SetAxesLimits}
\title{GUI: Axes Limits}
\usage{
SetAxesLimits(lim = NULL, parent = NULL)
}
\arguments{
\item{lim}{list.
Contains the current plotting limits, see \sQuote{Value} section.}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Returns an object of class list containing the following components:
  \item{x1, x2}{minimum and maximum \code{x} value.}
  \item{y1, y2}{minimum and maximum \code{y} value.}
  \item{z1, z2}{minimum and maximum \code{z} value.}
  \item{x1.chk, x2.chk}{if true, a default value is used for the minimum and maximum \code{x} value.}
  \item{y1.chk, y2.chk}{if true, a default value is used for the minimum and maximum \code{y} value.}
  \item{z1.chk, z2.chk}{if true, a default value is used for the minimum and maximum \code{z} value.}
  \item{x}{vector of \code{x} limits \code{(x1,x2)}, default is \code{(NA,NA)}.}
  \item{y}{vector of \code{y} limits \code{(y1,y2)}, default is \code{(NA,NA)}.}
  \item{z}{vector of \code{z} limits \code{(z1,z2)}, default is \code{(NA,NA)}.}
}
\description{
A graphical user interface (\acronym{GUI}) for specifying axes limits.
}
\examples{
\dontrun{
  SetAxesLimits()
}

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{misc}
