% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R
\name{mun.template}
\alias{mun.template}
\title{Generating templates for municipality-level data of Switzerland}
\usage{
mun.template(year, add_geodata_path = ".", endofyear = FALSE,
  cantons = NULL, districts = NULL, municipalities = NULL)
}
\arguments{
\item{year}{numeric. Available with package: \code{2016}. For additional years, see: \code{map.load}.}

\item{add_geodata_path}{a character string with the path to the folder where additional geodata is saved.}

\item{endofyear}{if \code{TRUE}, municipalities as by December 31 of \code{year} are used for the template.}

\item{cantons}{input either numeric (canton identification numbers) or character (canton abbreviations)
vector to create canton-specific templates.}

\item{districts}{input either numeric (district identification numbers) or character (district names)
vector to create district-specific templates.}

\item{municipalities}{input either numeric (municipality identification numbers) or character
(municipality names) vector to create tailor-made templates.}
}
\description{
\code{mun.template} offers the possbility to generate Swiss municipality-level data templates in
    the form of data frames. The package comes with data for \code{2016}.  Additional data can be
    downloaded with \code{map.load}.  The templates contain the municipality identification numbers
    as used by the Swiss Federal Statistical Office and the municipality names.
}
\examples{
# Generating template:
mun.template(2016)

# Generating template for the municipalities of the canton of Aargau:
mun.template(2016, cantons = c("AG", "ZH"))
}
