% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_spreads.R
\name{chart_spreads}
\alias{chart_spreads}
\title{\code{chart_spreads}}
\usage{
chart_spreads(
  cpairs = cpairs,
  daysFromExpiry = 200,
  from = "2012-01-01",
  conversion = 1,
  feed = "CME_NymexFutures_EOD",
  iuser = "x@xyz.com",
  ipassword = "pass",
  title = "March/April ULSD Nymex Spreads",
  yaxis = "$ per bbl",
  output = "chart"
)
}
\arguments{
\item{cpairs}{Data frame of contract pairs - see example.}

\item{daysFromExpiry}{Number of days (numeric) from expiry to compute spreads.}

\item{from}{From date as character string}

\item{conversion}{Defaults to 1. 42 from $ per gallons to bbls.}

\item{feed}{Morningstar Feed Table.}

\item{iuser}{Morningstar user name as character - sourced locally in examples.}

\item{ipassword}{Morningstar user password as character - sourced locally in examples.}

\item{title}{Title for chart.}

\item{yaxis}{y-axis label.}

\item{output}{"chart" for plotly object or "data" for dataframe.}
}
\value{
A plotly object or a dataframe
}
\description{
Chart spreads in specific futures contracts for multiple years.
}
\examples{
\dontrun{
cpairs <- dplyr::tibble(year = c("2014","2019","2020"),
first = c("@HO4H","@HO9H","@HO0H"),
second = c("@HO4J","@HO9J","@HO0J"))
chart_spreads(cpairs = cpairs, daysFromExpiry = 200, from = "2012-01-01",
conversion = 42,feed = "CME_NymexFutures_EOD",
iuser = "x@xyz.com", ipassword = "pass",
title = "March/April ULSD Nymex Spreads",
yaxis = "$ per bbl",
output = "data")
 }
}
\author{
Philippe Cote
}
