% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swapInfo.R
\name{swapInfo}
\alias{swapInfo}
\title{Commodity Swap details to learn their pricing}
\usage{
swapInfo(
  date = "2020-05-06",
  feeds = dplyr::tibble(feed = c("Crb_Futures_Price_Volume_And_Open_Interest",
    "CME_NymexFutures_EOD_continuous"), ticker = c("CL", "CL_001_Month")),
  contract = "cmewti",
  exchange = "nymex",
  iuser = "x@xyz.com",
  ipassword = "pass",
  output = "all"
)
}
\arguments{
\item{date}{Character date as of which you want to extract daily settlement and forward values. \code{character}}

\item{feeds}{Feeds for Morningstar getCurve() and getPrice(). \code{character}}

\item{contract}{Contract code in data(expiry_table). sort(unique(expiry_table$cmdty)) for options. \code{character}}

\item{exchange}{Exchange code in data(holidaysOil). Defaults to "nymex". \code{character}}

\item{iuser}{Morningstar user name as character - sourced locally in examples. \code{character}}

\item{ipassword}{Morningstar user password as character - sourced locally in examples. \code{character}}

\item{output}{"chart" or "all". \code{character}}
}
\value{
Plot or a list of data frame and plot if output = "all". \code{htmlwidget} or \code{list}
}
\description{
Returns dataframe required to price a WTI averaging instrument based on first line settlements.
}
\examples{
\dontrun{
feeds <- dplyr::tibble(
  feed = c(
    "Crb_Futures_Price_Volume_And_Open_Interest",
    "CME_NymexFutures_EOD_continuous"
  ),
  ticker = c("CL", "CL_001_Month")
)
swapInfo(
  date = "2020-05-06", feeds = feeds, contract = "cmewti", exchange = "nymex",
  iuser = "x@xyz.com", ipassword = "pass", output = "all"
)
}

}
\author{
Philippe Cote
}
