% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{RTest.getRTM}
\alias{RTest.getRTM}
\title{Function to return a risk tracibility matrix from a folder with XML files}
\usage{
RTest.getRTM(testcase.directory = list.dirs(find.package("RTest"),
  recursive = T) \%>\% grep(pattern = "xml-templates", value = T),
  f.pattern = "*.xml", project.name = "RTest Execution",
  project.details = "Example test exectuion",
  project.tester = "Example tester", ...)
}
\arguments{
\item{testcase.directory}{(\code{character}) Location of the Test Case XML files}

\item{f.pattern}{(\code{character}) An additional pattern to just search
for specific files with certain names}

\item{project.name}{(\code{character}) Name of the project mentioned in all
cover pages}

\item{project.details}{(\code{character}) Description of the project}

\item{project.tester}{(\code{character}) Name of the Test executer}

\item{...}{Additional arguments handed over to the \link{exec,RTestCollection-method}
method}
}
\value{
No return value, but the command line output will show where to fund the
  report. Using the additional argument \code{open=TRUE} will open the report
  directly after execution
}
\description{
Function to return a risk tracibility matrix from a folder with XML files
}
\examples{
library(magrittr)
directory_with_tests <- list.dirs(find.package('RTest'),recursive=TRUE) \%>\%
        grep(pattern="xml-templates",value=TRUE)

RTest::RTest.getRTM(
 testcase.directory = directory_with_tests[1],
  open=FALSE,
  f.pattern = "RTest_TC-generic.xml"
)

}
\author{
Sebastian Wolf \email{sebastian@mail-wolf.de}
}
