\name{train_models}
\alias{train_models}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
makes a model object using the specified algorithms.
}
\description{
Creates a trained model using the specified algorithms.
}
\usage{
train_models(corpus, algorithms, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{corpus}{
Class of type matrix_container generated by the \code{\link{create_corpus}} function.
}
  \item{algorithms}{
List of algorithms as a character vector (e.g. \code{c("SVM","MAXENT")}).
}
  \item{\dots}{
Other parameters to be passed on to \code{\link{train_model}}.
}
}
\details{
Calls the \code{\link{train_model}} function for each algorithm you list.
}
\value{
Returns a list of trained models that can be subsequently used in \code{\link{classify_models}} to classify new data.
}
\author{
Wouter Van Atteveldt <wouter@vanatteveldt.com>
}
\examples{
library(RTextTools)
data <- read_data(system.file("data/NYTimes.csv.gz",package="RTextTools"),type="csv")
data <- data[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data$Title,data$Subject), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=weightTfIdf)
corpus <- create_corpus(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
models <- train_models(corpus, algorithms=c("MAXENT","SVM"))
}
\keyword{method}
