% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVCompare.R
\name{get_X_prima_AB_density}
\alias{get_X_prima_AB_density}
\title{Get X'_A and X'_B from the observed values of X_A and X_B.}
\usage{
get_X_prima_AB_density(X_A_observed, X_B_observed, EPSILON = 1e-20)
}
\arguments{
\item{X_A_observed}{array of the samples (real values) of X_A.}

\item{X_B_observed}{array of the samples (real values) of X_B.}

\item{EPSILON}{(optional, default value 1e-20) when will two values be different.}
}
\value{
a list with two fields X_prima_A and X_prima_B: each representing the density of the estimated distributions.
}
\description{
X'_A and X'_B are two random variables defined in the interval [0,1] that have
the same C_p and C_d as the kernel density estimates of the observed X_A and X_B,
if a sufficiently small uniform kernel is used.
}
\examples{
X_A_observed <- c(0,2,1)
X_B_observed <- c(1,6,1,3)
res <- get_X_prima_AB_density(X_A_observed, X_B_observed)
x = 0:1001/1001
matplot(x,cbind(res$X_prima_A(x),res$X_prima_B(x)),type="l",col=c("red","blue"),
                    ylab='Probability density')
legend(x = c(0.7, 1.0), y = c(2.0, 2.5),legend=c("X'_A", "X'_B"), col=c("red", "blue"),
                    lty=1:2, cex=0.8) # add legend
}
\keyword{internal}
