/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.io.Serializable;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;

public class HyperPipes
extends Classifier {
    protected int m_ClassIndex;
    protected Instances m_Instances;
    protected HyperPipe[] m_HyperPipes;

    public String globalInfo() {
        return "Class implementing a HyperPipe classifier. For each category a HyperPipe is constructed that contains all points of that category (essentially records the attribute bounds observed for each category). Test instances are classified according to the category that \"most contains the instance\". Does not handle numeric class, or missing values in test cases. Extremely simple algorithm, but has the advantage of being extremely fast, and works quite well when you have \"smegloads\" of attributes.";
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        if (instances.classIndex() == -1) {
            throw new Exception("No class attribute assigned");
        }
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException("HyperPipes: class attribute needs to be nominal!");
        }
        this.m_ClassIndex = instances.classIndex();
        this.m_Instances = new Instances(instances, 0);
        this.m_HyperPipes = new HyperPipe[instances.numClasses()];
        for (n = 0; n < this.m_HyperPipes.length; ++n) {
            this.m_HyperPipes[n] = new HyperPipe(new Instances(instances, 0));
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            this.updateClassifier(instances.instance(n));
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (instance.classIsMissing()) {
            return;
        }
        this.m_HyperPipes[(int)instance.classValue()].addInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[this.m_HyperPipes.length];
        for (int i = 0; i < this.m_HyperPipes.length; ++i) {
            dArray[i] = this.m_HyperPipes[i].partialContains(instance);
        }
        double d = Utils.sum(dArray);
        if (d <= 0.0) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = 1.0 / (double)dArray.length;
            }
            return dArray;
        }
        Utils.normalize(dArray, d);
        return dArray;
    }

    public String toString() {
        if (this.m_HyperPipes == null) {
            return "HyperPipes classifier";
        }
        StringBuffer stringBuffer = new StringBuffer("HyperPipes classifier\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new HyperPipes(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    class HyperPipe
    implements Serializable {
        protected double[][] m_NumericBounds;
        protected boolean[][] m_NominalBounds;

        public HyperPipe(Instances instances) throws Exception {
            int n;
            this.m_NumericBounds = new double[instances.numAttributes()][];
            this.m_NominalBounds = new boolean[instances.numAttributes()][];
            block4: for (n = 0; n < instances.numAttributes(); ++n) {
                switch (instances.attribute(n).type()) {
                    case 0: {
                        this.m_NumericBounds[n] = new double[2];
                        this.m_NumericBounds[n][0] = Double.POSITIVE_INFINITY;
                        this.m_NumericBounds[n][1] = Double.NEGATIVE_INFINITY;
                        continue block4;
                    }
                    case 1: {
                        this.m_NominalBounds[n] = new boolean[instances.attribute(n).numValues()];
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedAttributeTypeException("Cannot process string attributes!");
                    }
                }
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                this.addInstance(instances.instance(n));
            }
        }

        public void addInstance(Instance instance) throws Exception {
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (i == HyperPipes.this.m_ClassIndex || instance.isMissing(i)) continue;
                double d = instance.value(i);
                if (this.m_NumericBounds[i] != null) {
                    if (d < this.m_NumericBounds[i][0]) {
                        this.m_NumericBounds[i][0] = d;
                    }
                    if (!(d > this.m_NumericBounds[i][1])) continue;
                    this.m_NumericBounds[i][1] = d;
                    continue;
                }
                this.m_NominalBounds[i][(int)d] = true;
            }
        }

        public double partialContains(Instance instance) throws Exception {
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (i == HyperPipes.this.m_ClassIndex || instance.isMissing(i)) continue;
                double d = instance.value(i);
                if (this.m_NumericBounds[i] != null) {
                    if (!(d >= this.m_NumericBounds[i][0]) || !(d <= this.m_NumericBounds[i][1])) continue;
                    ++n;
                    continue;
                }
                if (!this.m_NominalBounds[i][(int)d]) continue;
                ++n;
            }
            return (double)n / (double)(instance.numAttributes() - 1);
        }
    }
}

