/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Utils;

public class DatabaseConnection
implements Serializable {
    static final long serialVersionUID = 1673169848863178695L;
    protected static String PROPERTY_FILE = "weka/experiment/DatabaseUtils.props";
    protected static Vector DRIVERS = new Vector();
    protected static Properties PROPERTIES;
    protected String m_DatabaseURL = PROPERTIES.getProperty("jdbcURL", "jdbc:idb=experiments.prp");
    protected PreparedStatement m_PreparedStatement;
    protected Connection m_Connection;
    protected boolean m_Debug = false;
    protected boolean m_checkForUpperCaseNames = false;
    protected boolean m_setAutoCommit = true;
    protected boolean m_createIndex = false;
    protected String m_userName = "";
    protected String m_password = "";
    public static final int STRING = 0;
    public static final int BOOL = 1;
    public static final int DOUBLE = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INTEGER = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DATE = 8;

    public DatabaseConnection() throws Exception {
        String string = PROPERTIES.getProperty("checkUpperCaseNames");
        this.m_checkForUpperCaseNames = string.equals("true");
        string = PROPERTIES.getProperty("setAutoCommit");
        this.m_setAutoCommit = string.equals("true");
        string = PROPERTIES.getProperty("createIndex");
        this.m_createIndex = string.equals("true");
    }

    public void setUsername(String string) {
        this.m_userName = string;
    }

    public String getUsername() {
        return this.m_userName;
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String databaseURLTipText() {
        return "Set the URL to the database.";
    }

    public String getDatabaseURL() {
        return this.m_DatabaseURL;
    }

    public void setDatabaseURL(String string) {
        this.m_DatabaseURL = string;
    }

    public boolean getUpperCase() {
        return this.m_checkForUpperCaseNames;
    }

    int translateDBColumnType(String string) {
        return Integer.parseInt(PROPERTIES.getProperty(string));
    }

    public static String arrayToString(Object[] objectArray) {
        String string = "";
        if (objectArray == null) {
            string = "<null>";
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                string = objectArray[i] == null ? string + " ?" : string + " " + objectArray[i];
            }
        }
        return string;
    }

    public static String typeName(int n) {
        switch (n) {
            case -5: {
                return "BIGINT ";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 1: {
                return "CHAR";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "Unknown";
    }

    public void connectToDatabase() throws Exception {
        if (this.m_Debug) {
            System.err.println("Connecting to " + this.m_DatabaseURL);
        }
        if (this.m_Connection == null) {
            this.m_Connection = this.m_userName.equals("") ? DriverManager.getConnection(this.m_DatabaseURL) : DriverManager.getConnection(this.m_DatabaseURL, this.m_userName, this.m_password);
        }
        if (this.m_setAutoCommit) {
            this.m_Connection.setAutoCommit(true);
        } else {
            this.m_Connection.setAutoCommit(false);
        }
    }

    public void disconnectFromDatabase() throws Exception {
        if (this.m_Debug) {
            System.err.println("Disconnecting from " + this.m_DatabaseURL);
        }
        if (this.m_Connection != null) {
            this.m_Connection.close();
            this.m_Connection = null;
        }
    }

    public DatabaseMetaData getMetaData() throws Exception {
        return this.m_Connection.getMetaData();
    }

    public boolean isConnected() {
        return this.m_Connection != null;
    }

    public boolean execute(String string) throws SQLException {
        this.m_PreparedStatement = this.m_Connection.prepareStatement(string, 1003, 1007);
        return this.m_PreparedStatement.execute();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.m_PreparedStatement.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.m_PreparedStatement.getUpdateCount();
    }

    public boolean tableExists(String string) throws Exception {
        if (this.m_Debug) {
            System.err.println("Checking if table " + string + " exists...");
        }
        DatabaseMetaData databaseMetaData = this.m_Connection.getMetaData();
        ResultSet resultSet = this.m_checkForUpperCaseNames ? databaseMetaData.getTables(null, null, string.toUpperCase(), null) : databaseMetaData.getTables(null, null, string, null);
        boolean bl = resultSet.next();
        if (resultSet.next()) {
            throw new Exception("This table seems to exist more than once!");
        }
        resultSet.close();
        if (this.m_Debug) {
            if (bl) {
                System.err.println("... " + string + " exists");
            } else {
                System.err.println("... " + string + " does not exist");
            }
        }
        return bl;
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            String string = PROPERTIES.getProperty("jdbcDriver", "jdbc.idbDriver");
            if (string == null) {
                throw new Exception("No jdbc drivers specified");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    DRIVERS.addElement(Class.forName(string2).newInstance());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            System.err.println("Problem reading properties. Fix before continuing.");
            System.err.println(exception);
        }
    }
}

