/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.regression;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.datagenerators.DataGenerator;
import weka.datagenerators.classifiers.regression.MexicanHat;
import weka.filters.unsupervised.attribute.AddExpression;

public class Expression
extends MexicanHat {
    static final long serialVersionUID = -4237047357682277211L;
    protected String m_Expression;
    protected AddExpression m_Filter;
    protected Instances m_RawData;

    public Expression() {
        this.setExpression(this.defaultExpression());
    }

    public String globalInfo() {
        return "A data generator for generating y according to a given expression out of randomly generated x.\nE.g., the mexican hat can be generated like this:\n   sin(abs(a1)) / abs(a1)\nIn addition to this function, the amplitude can be changed and gaussian noise can be added.";
    }

    public Enumeration listOptions() {
        Vector vector = this.enumToVector(super.listOptions());
        vector.addElement(new Option("\tThe expression to use for generating y out of x \n\t(default " + this.defaultExpression() + ").", "E", 1, "-E <expression>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setExpression(string);
        } else {
            this.setExpression(this.defaultExpression());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-E");
        vector.add("" + this.getExpression());
        return vector.toArray(new String[vector.size()]);
    }

    public String amplitudeTipText() {
        return "The amplitude to multiply the y value with.";
    }

    protected String defaultExpression() {
        return "sin(abs(a1)) / abs(a1)";
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public void setExpression(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("An expression has to be provided!");
        }
        this.m_Expression = string;
    }

    public String expressionTipText() {
        return "The expression for generating y out of x.";
    }

    public boolean getSingleModeFlag() throws Exception {
        return true;
    }

    public Instances defineDataFormat() throws Exception {
        FastVector fastVector = new FastVector();
        fastVector.addElement(new Attribute("x"));
        this.m_RawData = new Instances(this.getRelationNameToUse(), fastVector, 0);
        this.m_Filter = new AddExpression();
        this.m_Filter.setName("y");
        this.m_Filter.setExpression(this.getExpression());
        this.m_Filter.setInputFormat(this.m_RawData);
        return super.defineDataFormat();
    }

    public Instance generateExample() throws Exception {
        Instance instance = null;
        Random random = this.getRandom();
        if (this.m_DatasetFormat == null) {
            throw new Exception("Dataset format not defined.");
        }
        double d = random.nextDouble();
        d = d * (this.getMaxRange() - this.getMinRange()) + this.getMinRange();
        double[] dArray = new double[]{d};
        Instance instance2 = new Instance(1.0, dArray);
        this.m_Filter.input(instance2);
        this.m_Filter.batchFinished();
        instance2 = this.m_Filter.output();
        double d2 = instance2.value(1) + this.getAmplitude() * this.m_NoiseRandom.nextGaussian() * this.getNoiseRate() * this.getNoiseVariance();
        dArray = new double[this.m_DatasetFormat.numAttributes()];
        dArray[0] = d;
        dArray[1] = d2;
        instance = new Instance(1.0, dArray);
        instance.setDataset(this.m_DatasetFormat);
        return instance;
    }

    public Instances generateExamples() throws Exception {
        Instances instances = new Instances(this.m_DatasetFormat, 0);
        this.m_Random = new Random(this.getSeed());
        for (int i = 0; i < this.getNumExamplesAct(); ++i) {
            instances.add(this.generateExample());
        }
        return instances;
    }

    public String generateStart() {
        return "";
    }

    public String generateFinished() throws Exception {
        return "";
    }

    public static void main(String[] stringArray) {
        try {
            DataGenerator.makeData(new Expression(), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

