/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.experiment.Stats;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public class Cobweb
extends Clusterer
implements OptionHandler,
Drawable,
TechnicalInformationHandler {
    static final long serialVersionUID = 928406656495092318L;
    protected static final double m_normal = 1.0 / (2.0 * Math.sqrt(Math.PI));
    protected double m_acuity = 1.0;
    protected double m_cutoff = 0.01 * m_normal;
    protected CNode m_cobwebTree = null;
    protected int m_numberOfClusters = -1;
    protected int m_numberSplits;
    protected int m_numberMerges;
    protected boolean m_saveInstances = false;

    public String globalInfo() {
        return "Class implementing the Cobweb and Classit clustering algorithms.\n\nNote: the application of node operators (merging, splitting etc.) in terms of ordering and priority differs (and is somewhat ambiguous) between the original Cobweb and Classit papers. This algorithm always compares the best host, adding a new leaf, merging the two best hosts, and splitting the best host when considering where to place a new instance.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "D. Fisher");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1987");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Knowledge acquisition via incremental conceptual clustering");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "2");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "2");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "139-172");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.ARTICLE);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "J. H. Gennari and P. Langley and D. Fisher");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1990");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Models of incremental concept formation");
        technicalInformation2.setValue(TechnicalInformation.Field.JOURNAL, "Artificial Intelligence");
        technicalInformation2.setValue(TechnicalInformation.Field.VOLUME, "40");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "11-61");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        return capabilities;
    }

    public void buildClusterer(Instances instances) throws Exception {
        this.m_numberOfClusters = -1;
        this.m_cobwebTree = null;
        this.m_numberSplits = 0;
        this.m_numberMerges = 0;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.randomize(new Random(42L));
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.addInstance(instances.instance(i));
        }
        int[] nArray = new int[]{0};
        this.m_cobwebTree.assignClusterNums(nArray);
        this.m_numberOfClusters = nArray[0];
    }

    public int clusterInstance(Instance instance) throws Exception {
        CNode cNode = this.m_cobwebTree;
        CNode cNode2 = null;
        do {
            if (cNode.m_children == null) {
                cNode2 = null;
                break;
            }
            cNode.updateStats(instance, false);
            cNode2 = cNode.findHost(instance, true);
            cNode.updateStats(instance, true);
            if (cNode2 == null) continue;
            cNode = cNode2;
        } while (cNode2 != null);
        return cNode.m_clusterNum;
    }

    public int numberOfClusters() {
        return this.m_numberOfClusters;
    }

    public void addInstance(Instance instance) throws Exception {
        if (this.m_cobwebTree == null) {
            this.m_cobwebTree = new CNode(instance.numAttributes(), instance);
        } else {
            this.m_cobwebTree.addInstance(instance);
        }
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tAcuity.\n\t(default=1.0)", "A", 1, "-A <acuity>"));
        vector.addElement(new Option("\tCutoff.\n\t(default=0.002)", "C", 1, "-C <cutoff>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        Double d;
        String string = Utils.getOption('A', stringArray);
        if (string.length() != 0) {
            d = new Double(string);
            this.setAcuity(d);
        } else {
            this.m_acuity = 1.0;
        }
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            d = new Double(string);
            this.setCutoff(d);
        } else {
            this.m_cutoff = 0.01 * m_normal;
        }
    }

    public String acuityTipText() {
        return "set the minimum standard deviation for numeric attributes";
    }

    public void setAcuity(double d) {
        this.m_acuity = d;
    }

    public double getAcuity() {
        return this.m_acuity;
    }

    public String cutoffTipText() {
        return "set the category utility threshold by which to prune nodes";
    }

    public void setCutoff(double d) {
        this.m_cutoff = d;
    }

    public double getCutoff() {
        return this.m_cutoff;
    }

    public String saveInstanceDataTipText() {
        return "save instance information for visualization purposes";
    }

    public boolean getSaveInstanceData() {
        return this.m_saveInstances;
    }

    public void setSaveInstanceData(boolean bl) {
        this.m_saveInstances = bl;
    }

    public String[] getOptions() {
        String[] stringArray = new String[4];
        int n = 0;
        stringArray[n++] = "-A";
        stringArray[n++] = "" + this.m_acuity;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.m_cutoff;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_cobwebTree == null) {
            return "Cobweb hasn't been built yet!";
        }
        this.m_cobwebTree.dumpTree(0, stringBuffer);
        return "Number of merges: " + this.m_numberMerges + "\nNumber of splits: " + this.m_numberSplits + "\nNumber of clusters: " + this.m_numberOfClusters + "\n" + stringBuffer.toString() + "\n\n";
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph CobwebTree {\n");
        this.m_cobwebTree.graphTree(stringBuffer);
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(ClusterEvaluation.evaluateClusterer(new Cobweb(), stringArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private class CNode
    implements Serializable {
        static final long serialVersionUID = 3452097436933325631L;
        private AttributeStats[] m_attStats;
        private int m_numAttributes;
        protected Instances m_clusterInstances = null;
        private FastVector m_children = null;
        private double m_totalInstances = 0.0;
        private int m_clusterNum = -1;

        public CNode(int n) {
            this.m_numAttributes = n;
        }

        public CNode(int n, Instance instance) {
            this(n);
            if (this.m_clusterInstances == null) {
                this.m_clusterInstances = new Instances(instance.dataset(), 1);
            }
            this.m_clusterInstances.add(instance);
            this.updateStats(instance, false);
        }

        protected void addInstance(Instance instance) throws Exception {
            if (this.m_clusterInstances == null) {
                this.m_clusterInstances = new Instances(instance.dataset(), 1);
                this.m_clusterInstances.add(instance);
                this.updateStats(instance, false);
                return;
            }
            if (this.m_children == null) {
                this.m_children = new FastVector();
                CNode cNode = new CNode(this.m_numAttributes, this.m_clusterInstances.instance(0));
                for (int i = 1; i < this.m_clusterInstances.numInstances(); ++i) {
                    cNode.m_clusterInstances.add(this.m_clusterInstances.instance(i));
                    cNode.updateStats(this.m_clusterInstances.instance(i), false);
                }
                this.m_children = new FastVector();
                this.m_children.addElement(cNode);
                this.m_children.addElement(new CNode(this.m_numAttributes, instance));
                this.m_clusterInstances.add(instance);
                this.updateStats(instance, false);
                if (this.categoryUtility() < Cobweb.this.m_cutoff) {
                    this.m_children = null;
                }
                return;
            }
            CNode cNode = this.findHost(instance, false);
            if (cNode != null) {
                cNode.addInstance(instance);
            }
        }

        private double[] cuScoresForChildren(Instance instance) throws Exception {
            double[] dArray = new double[this.m_children.size()];
            for (int i = 0; i < this.m_children.size(); ++i) {
                CNode cNode = (CNode)this.m_children.elementAt(i);
                cNode.updateStats(instance, false);
                dArray[i] = this.categoryUtility();
                cNode.updateStats(instance, true);
            }
            return dArray;
        }

        private double cuScoreForBestTwoMerged(CNode cNode, CNode cNode2, CNode cNode3, Instance instance) throws Exception {
            double d = -1.7976931348623157E308;
            cNode.m_clusterInstances = new Instances(this.m_clusterInstances, 1);
            cNode.addChildNode(cNode2);
            cNode.addChildNode(cNode3);
            cNode.updateStats(instance, false);
            this.m_children.removeElementAt(this.m_children.indexOf(cNode2));
            this.m_children.removeElementAt(this.m_children.indexOf(cNode3));
            this.m_children.addElement(cNode);
            d = this.categoryUtility();
            cNode.updateStats(instance, true);
            this.m_children.removeElementAt(this.m_children.indexOf(cNode));
            this.m_children.addElement(cNode2);
            this.m_children.addElement(cNode3);
            return d;
        }

        private CNode findHost(Instance instance, boolean bl) throws Exception {
            if (!bl) {
                this.updateStats(instance, false);
            }
            double[] dArray = this.cuScoresForChildren(instance);
            CNode cNode = new CNode(this.m_numAttributes, instance);
            this.m_children.addElement(cNode);
            double d = this.categoryUtility();
            CNode cNode2 = cNode;
            this.m_children.removeElementAt(this.m_children.size() - 1);
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] > dArray[n2])) continue;
                if (dArray[i] > dArray[n]) {
                    n2 = n;
                    n = i;
                    continue;
                }
                n2 = i;
            }
            CNode cNode3 = (CNode)this.m_children.elementAt(n);
            CNode cNode4 = (CNode)this.m_children.elementAt(n2);
            if (dArray[n] > d) {
                d = dArray[n];
                cNode2 = cNode3;
            }
            if (bl) {
                if (cNode2 == cNode) {
                    return null;
                }
                return cNode2;
            }
            double d2 = -1.7976931348623157E308;
            CNode cNode5 = new CNode(this.m_numAttributes);
            if (cNode3 != cNode4 && (d2 = this.cuScoreForBestTwoMerged(cNode5, cNode3, cNode4, instance)) > d) {
                d = d2;
                cNode2 = cNode5;
            }
            double d3 = -1.7976931348623157E308;
            double d4 = -1.7976931348623157E308;
            double d5 = -1.7976931348623157E308;
            double d6 = -1.7976931348623157E308;
            if (cNode3.m_children != null) {
                CNode cNode6;
                int n3;
                FastVector fastVector = new FastVector();
                for (n3 = 0; n3 < this.m_children.size(); ++n3) {
                    cNode6 = (CNode)this.m_children.elementAt(n3);
                    if (cNode6 == cNode3) continue;
                    fastVector.addElement(cNode6);
                }
                for (n3 = 0; n3 < cNode3.m_children.size(); ++n3) {
                    cNode6 = (CNode)cNode3.m_children.elementAt(n3);
                    fastVector.addElement(cNode6);
                }
                fastVector.addElement(cNode);
                FastVector fastVector2 = this.m_children;
                this.m_children = fastVector;
                d5 = this.categoryUtility();
                fastVector.removeElementAt(fastVector.size() - 1);
                dArray = this.cuScoresForChildren(instance);
                n = 0;
                n2 = 0;
                for (int i = 0; i < dArray.length; ++i) {
                    if (!(dArray[i] > dArray[n2])) continue;
                    if (dArray[i] > dArray[n]) {
                        n2 = n;
                        n = i;
                        continue;
                    }
                    n2 = i;
                }
                CNode cNode7 = (CNode)this.m_children.elementAt(n);
                CNode cNode8 = (CNode)this.m_children.elementAt(n2);
                d4 = dArray[n];
                CNode cNode9 = new CNode(this.m_numAttributes);
                if (cNode7 != cNode8) {
                    d6 = this.cuScoreForBestTwoMerged(cNode9, cNode7, cNode8, instance);
                }
                d3 = d4 > d5 ? d4 : d5;
                double d7 = d3 = d3 > d6 ? d3 : d6;
                if (d3 > d) {
                    d = d3;
                    cNode2 = this;
                } else {
                    this.m_children = fastVector2;
                }
            }
            if (cNode2 != this) {
                this.m_clusterInstances.add(instance);
            } else {
                ++Cobweb.this.m_numberSplits;
            }
            if (cNode2 == cNode5) {
                ++Cobweb.this.m_numberMerges;
                this.m_children.removeElementAt(this.m_children.indexOf(cNode3));
                this.m_children.removeElementAt(this.m_children.indexOf(cNode4));
                this.m_children.addElement(cNode5);
            }
            if (cNode2 == cNode) {
                cNode2 = new CNode(this.m_numAttributes);
                this.m_children.addElement(cNode2);
            }
            if (d < Cobweb.this.m_cutoff) {
                if (cNode2 == this) {
                    this.m_clusterInstances.add(instance);
                }
                this.m_children = null;
                cNode2 = null;
            }
            if (cNode2 == this) {
                this.updateStats(instance, true);
            }
            return cNode2;
        }

        protected void addChildNode(CNode cNode) {
            for (int i = 0; i < cNode.m_clusterInstances.numInstances(); ++i) {
                Instance instance = cNode.m_clusterInstances.instance(i);
                this.m_clusterInstances.add(instance);
                this.updateStats(instance, false);
            }
            if (this.m_children == null) {
                this.m_children = new FastVector();
            }
            this.m_children.addElement(cNode);
        }

        protected double categoryUtility() throws Exception {
            if (this.m_children == null) {
                throw new Exception("categoryUtility: No children!");
            }
            double d = 0.0;
            for (int i = 0; i < this.m_children.size(); ++i) {
                CNode cNode = (CNode)this.m_children.elementAt(i);
                d += this.categoryUtilityChild(cNode);
            }
            return d /= (double)this.m_children.size();
        }

        protected double categoryUtilityChild(CNode cNode) throws Exception {
            double d = 0.0;
            for (int i = 0; i < this.m_numAttributes; ++i) {
                if (this.m_clusterInstances.attribute(i).isNominal()) {
                    for (int j = 0; j < this.m_clusterInstances.attribute(i).numValues(); ++j) {
                        double d2 = cNode.getProbability(i, j);
                        double d3 = this.getProbability(i, j);
                        d += d2 * d2 - d3 * d3;
                    }
                    continue;
                }
                d += m_normal / cNode.getStandardDev(i) - m_normal / this.getStandardDev(i);
            }
            return cNode.m_totalInstances / this.m_totalInstances * d;
        }

        protected double getProbability(int n, int n2) throws Exception {
            if (!this.m_clusterInstances.attribute(n).isNominal()) {
                throw new Exception("getProbability: attribute is not nominal");
            }
            if (this.m_attStats[n].totalCount <= 0) {
                return 0.0;
            }
            return (double)this.m_attStats[n].nominalCounts[n2] / (double)this.m_attStats[n].totalCount;
        }

        protected double getStandardDev(int n) throws Exception {
            if (!this.m_clusterInstances.attribute(n).isNumeric()) {
                throw new Exception("getStandardDev: attribute is not numeric");
            }
            this.m_attStats[n].numericStats.calculateDerived();
            double d = this.m_attStats[n].numericStats.stdDev;
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                return Cobweb.this.m_acuity;
            }
            return Math.max(Cobweb.this.m_acuity, d);
        }

        protected void updateStats(Instance instance, boolean bl) {
            int n;
            if (this.m_attStats == null) {
                this.m_attStats = new AttributeStats[this.m_numAttributes];
                for (n = 0; n < this.m_numAttributes; ++n) {
                    this.m_attStats[n] = new AttributeStats();
                    if (this.m_clusterInstances.attribute(n).isNominal()) {
                        this.m_attStats[n].nominalCounts = new int[this.m_clusterInstances.attribute(n).numValues()];
                        continue;
                    }
                    this.m_attStats[n].numericStats = new Stats();
                }
            }
            for (n = 0; n < this.m_numAttributes; ++n) {
                if (instance.isMissing(n)) continue;
                double d = instance.value(n);
                if (this.m_clusterInstances.attribute(n).isNominal()) {
                    int n2 = (int)d;
                    this.m_attStats[n].nominalCounts[n2] = (int)((double)this.m_attStats[n].nominalCounts[n2] + (bl ? -1.0 * instance.weight() : instance.weight()));
                    this.m_attStats[n].totalCount = (int)((double)this.m_attStats[n].totalCount + (bl ? -1.0 * instance.weight() : instance.weight()));
                    continue;
                }
                if (bl) {
                    this.m_attStats[n].numericStats.subtract(d, instance.weight());
                    continue;
                }
                this.m_attStats[n].numericStats.add(d, instance.weight());
            }
            this.m_totalInstances += bl ? -1.0 * instance.weight() : instance.weight();
        }

        private void assignClusterNums(int[] nArray) throws Exception {
            if (this.m_children != null && this.m_children.size() < 2) {
                throw new Exception("assignClusterNums: tree not built correctly!");
            }
            this.m_clusterNum = nArray[0];
            nArray[0] = nArray[0] + 1;
            if (this.m_children != null) {
                for (int i = 0; i < this.m_children.size(); ++i) {
                    CNode cNode = (CNode)this.m_children.elementAt(i);
                    cNode.assignClusterNums(nArray);
                }
            }
        }

        protected void dumpTree(int n, StringBuffer stringBuffer) {
            if (this.m_children == null) {
                stringBuffer.append("\n");
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("|   ");
                }
                stringBuffer.append("leaf " + this.m_clusterNum + " [" + this.m_clusterInstances.numInstances() + "]");
            } else {
                for (int i = 0; i < this.m_children.size(); ++i) {
                    stringBuffer.append("\n");
                    for (int j = 0; j < n; ++j) {
                        stringBuffer.append("|   ");
                    }
                    stringBuffer.append("node " + this.m_clusterNum + " [" + this.m_clusterInstances.numInstances() + "]");
                    ((CNode)this.m_children.elementAt(i)).dumpTree(n + 1, stringBuffer);
                }
            }
        }

        protected String dumpData() throws Exception {
            int n;
            if (this.m_children == null) {
                return this.m_clusterInstances.toString();
            }
            CNode cNode = new CNode(this.m_numAttributes);
            cNode.m_clusterInstances = new Instances(this.m_clusterInstances, 1);
            for (int i = 0; i < this.m_children.size(); ++i) {
                cNode.addChildNode((CNode)this.m_children.elementAt(i));
            }
            Instances instances = cNode.m_clusterInstances;
            cNode = null;
            Add add = new Add();
            add.setAttributeName("Cluster");
            String string = "";
            for (n = 0; n < this.m_children.size(); ++n) {
                CNode cNode2 = (CNode)this.m_children.elementAt(n);
                string = string + "C" + cNode2.m_clusterNum;
                if (n >= this.m_children.size() - 1) continue;
                string = string + ",";
            }
            add.setNominalLabels(string);
            add.setInputFormat(instances);
            instances = Filter.useFilter(instances, add);
            instances.setRelationName("Cluster " + this.m_clusterNum);
            n = 0;
            for (int i = 0; i < this.m_children.size(); ++i) {
                CNode cNode3 = (CNode)this.m_children.elementAt(i);
                for (int j = 0; j < cNode3.m_clusterInstances.numInstances(); ++j) {
                    instances.instance(n).setValue(this.m_numAttributes, (double)i);
                    ++n;
                }
            }
            return instances.toString();
        }

        protected void graphTree(StringBuffer stringBuffer) throws Exception {
            stringBuffer.append("N" + this.m_clusterNum + " [label=\"" + (this.m_children == null ? "leaf " : "node ") + this.m_clusterNum + " " + " (" + this.m_clusterInstances.numInstances() + ")\" " + (this.m_children == null ? "shape=box style=filled " : "") + (Cobweb.this.m_saveInstances ? "data =\n" + this.dumpData() + "\n,\n" : "") + "]\n");
            if (this.m_children != null) {
                CNode cNode;
                int n;
                for (n = 0; n < this.m_children.size(); ++n) {
                    cNode = (CNode)this.m_children.elementAt(n);
                    stringBuffer.append("N" + this.m_clusterNum + "->" + "N" + cNode.m_clusterNum + "\n");
                }
                for (n = 0; n < this.m_children.size(); ++n) {
                    cNode = (CNode)this.m_children.elementAt(n);
                    cNode.graphTree(stringBuffer);
                }
            }
        }
    }
}

