/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.trees.lmt.LogisticBase;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class SimpleLogistic
extends Classifier
implements OptionHandler,
AdditionalMeasureProducer,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 7397710626304705059L;
    protected LogisticBase m_boostedModel;
    protected NominalToBinary m_NominalToBinary = null;
    protected ReplaceMissingValues m_ReplaceMissingValues = null;
    protected int m_numBoostingIterations;
    protected int m_maxBoostingIterations = 500;
    protected int m_heuristicStop = 50;
    protected boolean m_useCrossValidation;
    protected boolean m_errorOnProbabilities;
    protected double m_weightTrimBeta = 0.0;
    private boolean m_useAIC = false;

    public SimpleLogistic() {
        this.m_numBoostingIterations = 0;
        this.m_useCrossValidation = true;
        this.m_errorOnProbabilities = false;
        this.m_weightTrimBeta = 0.0;
        this.m_useAIC = false;
    }

    public SimpleLogistic(int n, boolean bl, boolean bl2) {
        this.m_numBoostingIterations = n;
        this.m_useCrossValidation = bl;
        this.m_errorOnProbabilities = bl2;
        this.m_weightTrimBeta = 0.0;
        this.m_useAIC = false;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_ReplaceMissingValues = new ReplaceMissingValues();
        this.m_ReplaceMissingValues.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_ReplaceMissingValues);
        this.m_NominalToBinary = new NominalToBinary();
        this.m_NominalToBinary.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_NominalToBinary);
        this.m_boostedModel = new LogisticBase(this.m_numBoostingIterations, this.m_useCrossValidation, this.m_errorOnProbabilities);
        this.m_boostedModel.setMaxIterations(this.m_maxBoostingIterations);
        this.m_boostedModel.setHeuristicStop(this.m_heuristicStop);
        this.m_boostedModel.setWeightTrimBeta(this.m_weightTrimBeta);
        this.m_boostedModel.setUseAIC(this.m_useAIC);
        this.m_boostedModel.buildClassifier(instances);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_ReplaceMissingValues.input(instance);
        instance = this.m_ReplaceMissingValues.output();
        this.m_NominalToBinary.input(instance);
        instance = this.m_NominalToBinary.output();
        return this.m_boostedModel.distributionForInstance(instance);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSet fixed number of iterations for LogitBoost", "I", 1, "-I <iterations>"));
        vector.addElement(new Option("\tUse stopping criterion on training set (instead of\n\tcross-validation)", "S", 0, "-S"));
        vector.addElement(new Option("\tUse error on probabilities (rmse) instead of\n\tmisclassification error for stopping criterion", "P", 0, "-P"));
        vector.addElement(new Option("\tSet maximum number of boosting iterations", "M", 1, "-M <iterations>"));
        vector.addElement(new Option("\tSet parameter for heuristic for early stopping of\n\tLogitBoost.\n\tIf enabled, the minimum is selected greedily, stopping\n\tif the current minimum has not changed for iter iterations.\n\tBy default, heuristic is enabled with value 50. Set to\n\tzero to disable heuristic.", "H", 1, "-H <iterations>"));
        vector.addElement(new Option("\tSet beta for weight trimming for LogitBoost. Set to 0 for no weight trimming.\n", "W", 1, "-W <beta>"));
        vector.addElement(new Option("\tThe AIC is used to choose the best iteration (instead of CV or training error).\n", "A", 0, "-A"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('I', stringArray);
        if (string.length() != 0) {
            this.setNumBoostingIterations(new Integer(string));
        }
        this.setUseCrossValidation(!Utils.getFlag('S', stringArray));
        this.setErrorOnProbabilities(Utils.getFlag('P', stringArray));
        string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMaxBoostingIterations(new Integer(string));
        }
        if ((string = Utils.getOption('H', stringArray)).length() != 0) {
            this.setHeuristicStop(new Integer(string));
        }
        if ((string = Utils.getOption('W', stringArray)).length() != 0) {
            this.setWeightTrimBeta(new Double(string));
        }
        this.setUseAIC(Utils.getFlag('A', stringArray));
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[11];
        int n = 0;
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getNumBoostingIterations();
        if (!this.getUseCrossValidation()) {
            stringArray[n++] = "-S";
        }
        if (this.getErrorOnProbabilities()) {
            stringArray[n++] = "-P";
        }
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMaxBoostingIterations();
        stringArray[n++] = "-H";
        stringArray[n++] = "" + this.getHeuristicStop();
        stringArray[n++] = "-W";
        stringArray[n++] = "" + this.getWeightTrimBeta();
        if (this.getUseAIC()) {
            stringArray[n++] = "-A";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public int getNumBoostingIterations() {
        return this.m_numBoostingIterations;
    }

    public boolean getUseCrossValidation() {
        return this.m_useCrossValidation;
    }

    public boolean getErrorOnProbabilities() {
        return this.m_errorOnProbabilities;
    }

    public int getMaxBoostingIterations() {
        return this.m_maxBoostingIterations;
    }

    public int getHeuristicStop() {
        return this.m_heuristicStop;
    }

    public double getWeightTrimBeta() {
        return this.m_weightTrimBeta;
    }

    public boolean getUseAIC() {
        return this.m_useAIC;
    }

    public void setNumBoostingIterations(int n) {
        this.m_numBoostingIterations = n;
    }

    public void setUseCrossValidation(boolean bl) {
        this.m_useCrossValidation = bl;
    }

    public void setErrorOnProbabilities(boolean bl) {
        this.m_errorOnProbabilities = bl;
    }

    public void setMaxBoostingIterations(int n) {
        this.m_maxBoostingIterations = n;
    }

    public void setHeuristicStop(int n) {
        this.m_heuristicStop = n == 0 ? this.m_maxBoostingIterations : n;
    }

    public void setWeightTrimBeta(double d) {
        this.m_weightTrimBeta = d;
    }

    public void setUseAIC(boolean bl) {
        this.m_useAIC = bl;
    }

    public int getNumRegressions() {
        return this.m_boostedModel.getNumRegressions();
    }

    public String toString() {
        if (this.m_boostedModel == null) {
            return "No model built";
        }
        return "SimpleLogistic:\n" + this.m_boostedModel.toString();
    }

    public double measureAttributesUsed() {
        return this.m_boostedModel.percentAttributesUsed();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(3);
        vector.addElement("measureAttributesUsed");
        vector.addElement("measureNumIterations");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureAttributesUsed") == 0) {
            return this.measureAttributesUsed();
        }
        if (string.compareToIgnoreCase("measureNumIterations") == 0) {
            return this.getNumRegressions();
        }
        throw new IllegalArgumentException(string + " not supported (SimpleLogistic)");
    }

    public String globalInfo() {
        return "Classifier for building linear logistic regression models. LogitBoost with simple regression functions as base learners is used for fitting the logistic models. The optimal number of LogitBoost iterations to perform is cross-validated, which leads to automatic attribute selection. For more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Niels Landwehr and Mark Hall and Eibe Frank");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Logistic Model Trees");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2005");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "95");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "161-205");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "1-2");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Marc Sumner and Eibe Frank and Mark Hall");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Speeding up Logistic Model Tree Induction");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "9th European Conference on Principles and Practice of Knowledge Discovery in Databases");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2005");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "675-683");
        technicalInformation2.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return technicalInformation;
    }

    public String numBoostingIterationsTipText() {
        return "Set fixed number of iterations for LogitBoost. If >= 0, this sets the number of LogitBoost iterations to perform. If < 0, the number is cross-validated or a stopping criterion on the training set is used (depending on the value of useCrossValidation).";
    }

    public String useCrossValidationTipText() {
        return "Sets whether the number of LogitBoost iterations is to be cross-validated or the stopping criterion on the training set should be used. If not set (and no fixed number of iterations was given), the number of LogitBoost iterations is used that minimizes the error on the training set (misclassification error or error on probabilities depending on errorOnProbabilities).";
    }

    public String errorOnProbabilitiesTipText() {
        return "Use error on the probabilties as error measure when determining the best number of LogitBoost iterations. If set, the number of LogitBoost iterations is chosen that minimizes the root mean squared error (either on the training set or in the cross-validation, depending on useCrossValidation).";
    }

    public String maxBoostingIterationsTipText() {
        return "Sets the maximum number of iterations for LogitBoost. Default value is 500, for very small/large datasets a lower/higher value might be preferable.";
    }

    public String heuristicStopTipText() {
        return "If heuristicStop > 0, the heuristic for greedy stopping while cross-validating the number of LogitBoost iterations is enabled. This means LogitBoost is stopped if no new error minimum has been reached in the last heuristicStop iterations. It is recommended to use this heuristic, it gives a large speed-up especially on small datasets. The default value is 50.";
    }

    public String weightTrimBetaTipText() {
        return "Set the beta value used for weight trimming in LogitBoost. Only instances carrying (1 - beta)% of the weight from previous iteration are used in the next iteration. Set to 0 for no weight trimming. The default value is 0.";
    }

    public String useAICTipText() {
        return "The AIC is used to determine when to stop LogitBoost iterations (instead of cross-validation or training error).";
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new SimpleLogistic(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

