/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.ParentSet;

public class MarginCalculator
implements Serializable {
    private static final long serialVersionUID = 650278019241175534L;
    boolean m_debug = false;
    public JunctionTreeNode m_root = null;
    JunctionTreeNode[] jtNodes;
    double[][] m_Margins;

    public int getNode(String string) {
        for (int i = 0; i < this.m_root.m_bayesNet.m_Instances.numAttributes(); ++i) {
            if (!this.m_root.m_bayesNet.m_Instances.attribute(i).name().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String toXMLBIF03() {
        return this.m_root.m_bayesNet.toXMLBIF03();
    }

    public void calcMargins(BayesNet bayesNet) throws Exception {
        boolean[][] blArray = this.moralize(bayesNet);
        this.process(blArray, bayesNet);
    }

    public void calcFullMargins(BayesNet bayesNet) throws Exception {
        int n = bayesNet.getNrOfNodes();
        boolean[][] blArray = new boolean[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                blArray[i][j] = true;
            }
        }
        this.process(blArray, bayesNet);
    }

    public void process(boolean[][] blArray, BayesNet bayesNet) throws Exception {
        int n;
        int n2;
        int[] nArray = this.getMaxCardOrder(blArray);
        blArray = this.fillIn(nArray, blArray);
        nArray = this.getMaxCardOrder(blArray);
        Set[] setArray = this.getCliques(nArray, blArray);
        Set[] setArray2 = this.getSeparators(nArray, setArray);
        int[] nArray2 = this.getCliqueTree(nArray, setArray, setArray2);
        int n3 = blArray.length;
        if (this.m_debug) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                n = nArray[n2];
                if (setArray[n] == null) continue;
                System.out.print("Clique " + n + " (");
                Iterator iterator = setArray[n].iterator();
                while (iterator.hasNext()) {
                    n4 = (Integer)iterator.next();
                    System.out.print(n4 + " " + bayesNet.getNodeName(n4));
                    if (!iterator.hasNext()) continue;
                    System.out.print(",");
                }
                System.out.print(") S(");
                iterator = setArray2[n].iterator();
                while (iterator.hasNext()) {
                    n4 = (Integer)iterator.next();
                    System.out.print(n4 + " " + bayesNet.getNodeName(n4));
                    if (!iterator.hasNext()) continue;
                    System.out.print(",");
                }
                System.out.println(") parent clique " + nArray2[n]);
            }
        }
        this.jtNodes = this.getJunctionTree(setArray, setArray2, nArray2, nArray, bayesNet);
        this.m_root = null;
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray2[n2] >= 0 || this.jtNodes[n2] == null) continue;
            this.m_root = this.jtNodes[n2];
            break;
        }
        this.m_Margins = new double[n3][];
        this.initialize(this.jtNodes, nArray, setArray, setArray2, nArray2);
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n2];
            if (setArray[n] == null || nArray2[n] != -1 || setArray2[n].size() <= 0) continue;
            throw new Exception("Something wrong in clique tree");
        }
        if (this.m_debug) {
            // empty if block
        }
    }

    void initialize(JunctionTreeNode[] junctionTreeNodeArray, int[] nArray, Set[] setArray, Set[] setArray2, int[] nArray2) {
        int n;
        int n2;
        int n3 = nArray.length;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            n = nArray[n2];
            if (junctionTreeNodeArray[n] == null) continue;
            junctionTreeNodeArray[n].initializeUp();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n2];
            if (junctionTreeNodeArray[n] == null) continue;
            junctionTreeNodeArray[n].initializeDown(false);
        }
    }

    JunctionTreeNode[] getJunctionTree(Set[] setArray, Set[] setArray2, int[] nArray, int[] nArray2, BayesNet bayesNet) {
        int n;
        int n2;
        int n3 = nArray2.length;
        JunctionTreeNode junctionTreeNode = null;
        JunctionTreeNode[] junctionTreeNodeArray = new JunctionTreeNode[n3];
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray2[n2];
            if (setArray[n] == null) continue;
            junctionTreeNodeArray[n] = new JunctionTreeNode(setArray[n], bayesNet, blArray);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray2[n2];
            if (setArray[n] == null) continue;
            JunctionTreeNode junctionTreeNode2 = null;
            if (nArray[n] > 0) {
                junctionTreeNode2 = junctionTreeNodeArray[nArray[n]];
                JunctionTreeSeparator junctionTreeSeparator = new JunctionTreeSeparator(setArray2[n], bayesNet, junctionTreeNodeArray[n], junctionTreeNode2);
                junctionTreeNodeArray[n].setParentSeparator(junctionTreeSeparator);
                junctionTreeNodeArray[nArray[n]].addChildClique(junctionTreeNodeArray[n]);
                continue;
            }
            junctionTreeNode = junctionTreeNodeArray[n];
        }
        return junctionTreeNodeArray;
    }

    int getCPT(int[] nArray, int n, int[] nArray2, int[] nArray3, BayesNet bayesNet) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            n2 *= bayesNet.getCardinality(n3);
            n2 += nArray2[nArray3[n3]];
        }
        return n2;
    }

    int[] getCliqueTree(int[] nArray, Set[] setArray, Set[] setArray2) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            nArray2[n2] = -1;
            if (setArray[n2] == null || setArray2[n2].size() <= 0) continue;
            for (int j = 0; j < n; ++j) {
                int n3 = nArray[j];
                if (n2 == n3 || setArray[n3] == null || !setArray[n3].containsAll(setArray2[n2])) continue;
                nArray2[n2] = n3;
                j = i;
                j = 0;
                j = n;
            }
        }
        return nArray2;
    }

    Set[] getSeparators(int[] nArray, Set[] setArray) {
        int n = nArray.length;
        Set[] setArray2 = new HashSet[n];
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (setArray[n2] == null) continue;
            HashSet hashSet2 = new HashSet();
            hashSet2.addAll(setArray[n2]);
            hashSet2.retainAll(hashSet);
            setArray2[n2] = hashSet2;
            hashSet.addAll(setArray[n2]);
        }
        return setArray2;
    }

    Set[] getCliques(int[] nArray, boolean[][] blArray) throws Exception {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5 = blArray.length;
        Set[] setArray = new HashSet[n5];
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            n3 = nArray[n4];
            if (n3 == 22) {
                int n6 = 3;
                ++n6;
            }
            object = new HashSet<Integer>();
            object.add(n3);
            for (n2 = 0; n2 < n4; ++n2) {
                n = nArray[n2];
                if (!blArray[n3][n]) continue;
                object.add(n);
            }
            setArray[n3] = object;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                if (n4 == n3 || setArray[n4] == null || setArray[n3] == null || !setArray[n4].containsAll(setArray[n3])) continue;
                setArray[n3] = null;
            }
        }
        if (this.m_debug) {
            int[] nArray2 = new int[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                if (setArray[n3] == null) continue;
                object = setArray[n3].iterator();
                n2 = 0;
                while (object.hasNext()) {
                    nArray2[n2++] = (Integer)object.next();
                }
                for (n = 0; n < setArray[n3].size(); ++n) {
                    for (int i = 0; i < setArray[n3].size(); ++i) {
                        if (n == i || blArray[nArray2[n]][nArray2[i]]) continue;
                        throw new Exception("Non clique" + n + " " + i);
                    }
                }
            }
        }
        return setArray;
    }

    public boolean[][] moralize(BayesNet bayesNet) {
        int n = bayesNet.getNrOfNodes();
        boolean[][] blArray = new boolean[n][n];
        for (int i = 0; i < n; ++i) {
            ParentSet parentSet = bayesNet.getParentSets()[i];
            this.moralizeNode(parentSet, i, blArray);
        }
        return blArray;
    }

    private void moralizeNode(ParentSet parentSet, int n, boolean[][] blArray) {
        for (int i = 0; i < parentSet.getNrOfParents(); ++i) {
            int n2 = parentSet.getParent(i);
            if (this.m_debug && !blArray[n][n2]) {
                System.out.println("Insert " + n + "--" + n2);
            }
            blArray[n][n2] = true;
            blArray[n2][n] = true;
            for (int j = i + 1; j < parentSet.getNrOfParents(); ++j) {
                int n3 = parentSet.getParent(j);
                if (this.m_debug && !blArray[n3][n2]) {
                    System.out.println("Mary " + n2 + "--" + n3);
                }
                blArray[n3][n2] = true;
                blArray[n2][n3] = true;
            }
        }
    }

    public boolean[][] fillIn(int[] nArray, boolean[][] blArray) {
        int n;
        int n2 = blArray.length;
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray2[nArray[n]] = n;
        }
        for (n = n2 - 1; n >= 0; --n) {
            int n3 = nArray[n];
            for (int i = 0; i < n; ++i) {
                int n4 = nArray[i];
                if (!blArray[n3][n4]) continue;
                for (int j = i + 1; j < n; ++j) {
                    int n5 = nArray[j];
                    if (!blArray[n3][n5]) continue;
                    if (!(!this.m_debug || blArray[n4][n5] && blArray[n5][n4])) {
                        System.out.println("Fill in " + n4 + "--" + n5);
                    }
                    blArray[n4][n5] = true;
                    blArray[n5][n4] = true;
                }
            }
        }
        return blArray;
    }

    int[] getMaxCardOrder(boolean[][] blArray) {
        int n = blArray.length;
        int[] nArray = new int[n];
        if (n == 0) {
            return nArray;
        }
        boolean[] blArray2 = new boolean[n];
        nArray[0] = 0;
        blArray2[0] = true;
        for (int i = 1; i < n; ++i) {
            int n2 = -1;
            int n3 = -1;
            for (int j = 0; j < n; ++j) {
                if (blArray2[j]) continue;
                int n4 = 0;
                for (int k = 0; k < n; ++k) {
                    if (!blArray[j][k] || !blArray2[k]) continue;
                    ++n4;
                }
                if (n4 <= n2) continue;
                n2 = n4;
                n3 = j;
            }
            nArray[i] = n3;
            blArray2[n3] = true;
        }
        return nArray;
    }

    public void setEvidence(int n, int n2) throws Exception {
        int n3;
        if (this.m_root == null) {
            throw new Exception("Junction tree not initialize yet");
        }
        for (n3 = 0; !(n3 >= this.jtNodes.length || this.jtNodes[n3] != null && this.jtNodes[n3].contains(n)); ++n3) {
        }
        if (this.jtNodes.length == n3) {
            throw new Exception("Could not find node " + n + " in junction tree");
        }
        this.jtNodes[n3].setEvidence(n, n2);
    }

    public String toString() {
        return this.m_root.toString();
    }

    public double[] getMargin(int n) {
        return this.m_Margins[n];
    }

    public static void main(String[] stringArray) {
        try {
            BIFReader bIFReader = new BIFReader();
            bIFReader.processFile(stringArray[0]);
            MarginCalculator marginCalculator = new MarginCalculator();
            marginCalculator.calcMargins(bIFReader);
            int n = 2;
            int n2 = 0;
            int n3 = 4;
            int n4 = 0;
            marginCalculator.setEvidence(n, n2);
            marginCalculator.setEvidence(n3, n4);
            System.out.print(marginCalculator.toString());
            marginCalculator.calcFullMargins(bIFReader);
            marginCalculator.setEvidence(n, n2);
            marginCalculator.setEvidence(n3, n4);
            System.out.println("==============");
            System.out.print(marginCalculator.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class JunctionTreeNode
    implements Serializable {
        private static final long serialVersionUID = 650278019241175536L;
        BayesNet m_bayesNet;
        public int[] m_nNodes;
        int m_nCardinality;
        double[] m_fi;
        double[] m_P;
        double[][] m_MarginalP;
        JunctionTreeSeparator m_parentSeparator;
        public Vector m_children;

        public void setParentSeparator(JunctionTreeSeparator junctionTreeSeparator) {
            this.m_parentSeparator = junctionTreeSeparator;
        }

        public void addChildClique(JunctionTreeNode junctionTreeNode) {
            this.m_children.add(junctionTreeNode);
        }

        public void initializeUp() {
            int n;
            this.m_P = new double[this.m_nCardinality];
            for (int i = 0; i < this.m_nCardinality; ++i) {
                this.m_P[i] = this.m_fi[i];
            }
            int[] nArray = new int[this.m_nNodes.length];
            int[] nArray2 = new int[this.m_bayesNet.getNrOfNodes()];
            for (int i = 0; i < this.m_nNodes.length; ++i) {
                nArray2[this.m_nNodes[i]] = i;
            }
            for (JunctionTreeNode junctionTreeNode : this.m_children) {
                JunctionTreeSeparator junctionTreeSeparator = junctionTreeNode.m_parentSeparator;
                for (int i = 0; i < this.m_nCardinality; ++i) {
                    int n2;
                    int n3;
                    int n4 = MarginCalculator.this.getCPT(junctionTreeSeparator.m_nNodes, junctionTreeSeparator.m_nNodes.length, nArray, nArray2, this.m_bayesNet);
                    int n5 = n3 = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, nArray, nArray2, this.m_bayesNet);
                    this.m_P[n5] = this.m_P[n5] * junctionTreeSeparator.m_fiChild[n4];
                    int n6 = n2 = 0;
                    nArray[n6] = nArray[n6] + 1;
                    while (n2 < this.m_nNodes.length && nArray[n2] == this.m_bayesNet.getCardinality(this.m_nNodes[n2])) {
                        nArray[n2] = 0;
                        if (++n2 >= this.m_nNodes.length) continue;
                        int n7 = n2;
                        nArray[n7] = nArray[n7] + 1;
                    }
                }
            }
            double d = 0.0;
            for (n = 0; n < this.m_nCardinality; ++n) {
                d += this.m_P[n];
            }
            n = 0;
            while (n < this.m_nCardinality) {
                int n8 = n++;
                this.m_P[n8] = this.m_P[n8] / d;
            }
            if (this.m_parentSeparator != null) {
                this.m_parentSeparator.updateFromChild();
            }
        }

        public void initializeDown(boolean bl) {
            Object object;
            Object object2;
            if (this.m_parentSeparator == null) {
                this.calcMarginalProbabilities();
            } else {
                int n;
                int n2;
                this.m_parentSeparator.updateFromParent();
                object2 = new int[this.m_nNodes.length];
                object = new int[this.m_bayesNet.getNrOfNodes()];
                for (n2 = 0; n2 < this.m_nNodes.length; ++n2) {
                    object[this.m_nNodes[n2]] = n2;
                }
                for (n2 = 0; n2 < this.m_nCardinality; ++n2) {
                    int n3 = MarginCalculator.this.getCPT(this.m_parentSeparator.m_nNodes, this.m_parentSeparator.m_nNodes.length, (int[])object2, (int[])object, this.m_bayesNet);
                    n = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, (int[])object2, (int[])object, this.m_bayesNet);
                    if (this.m_parentSeparator.m_fiChild[n3] > 0.0) {
                        int n4 = n;
                        this.m_P[n4] = this.m_P[n4] * (this.m_parentSeparator.m_fiParent[n3] / this.m_parentSeparator.m_fiChild[n3]);
                    } else {
                        this.m_P[n] = 0.0;
                    }
                    int n5 = 0;
                    Object object3 = object2;
                    int n6 = n5;
                    object3[n6] = object3[n6] + true;
                    while (n5 < this.m_nNodes.length && object2[n5] == this.m_bayesNet.getCardinality(this.m_nNodes[n5])) {
                        object2[n5] = false;
                        if (++n5 >= this.m_nNodes.length) continue;
                        Object object4 = object2;
                        int n7 = n5;
                        object4[n7] = object4[n7] + true;
                    }
                }
                double d = 0.0;
                for (n = 0; n < this.m_nCardinality; ++n) {
                    d += this.m_P[n];
                }
                n = 0;
                while (n < this.m_nCardinality) {
                    int n8 = n++;
                    this.m_P[n8] = this.m_P[n8] / d;
                }
                this.m_parentSeparator.updateFromChild();
                this.calcMarginalProbabilities();
            }
            if (bl) {
                object2 = this.m_children.iterator();
                while (object2.hasNext()) {
                    object = (JunctionTreeNode)object2.next();
                    ((JunctionTreeNode)object).initializeDown(true);
                }
            }
        }

        void calcMarginalProbabilities() {
            int n;
            int[] nArray = new int[this.m_nNodes.length];
            int[] nArray2 = new int[this.m_bayesNet.getNrOfNodes()];
            this.m_MarginalP = new double[this.m_nNodes.length][];
            for (n = 0; n < this.m_nNodes.length; ++n) {
                nArray2[this.m_nNodes[n]] = n;
                this.m_MarginalP[n] = new double[this.m_bayesNet.getCardinality(this.m_nNodes[n])];
            }
            for (n = 0; n < this.m_nCardinality; ++n) {
                int n2;
                int n3 = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, nArray, nArray2, this.m_bayesNet);
                for (n2 = 0; n2 < this.m_nNodes.length; ++n2) {
                    double[] dArray = this.m_MarginalP[n2];
                    int n4 = nArray[n2];
                    dArray[n4] = dArray[n4] + this.m_P[n3];
                }
                int n5 = n2 = 0;
                nArray[n5] = nArray[n5] + 1;
                while (n2 < this.m_nNodes.length && nArray[n2] == this.m_bayesNet.getCardinality(this.m_nNodes[n2])) {
                    nArray[n2] = 0;
                    if (++n2 >= this.m_nNodes.length) continue;
                    int n6 = n2;
                    nArray[n6] = nArray[n6] + 1;
                }
            }
            for (n = 0; n < this.m_nNodes.length; ++n) {
                MarginCalculator.this.m_Margins[this.m_nNodes[n]] = this.m_MarginalP[n];
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_nNodes.length; ++i) {
                stringBuffer.append(this.m_bayesNet.getNodeName(this.m_nNodes[i]) + ": ");
                for (int j = 0; j < this.m_MarginalP[i].length; ++j) {
                    stringBuffer.append(this.m_MarginalP[i][j] + " ");
                }
                stringBuffer.append('\n');
            }
            for (JunctionTreeNode junctionTreeNode : this.m_children) {
                stringBuffer.append("----------------\n");
                stringBuffer.append(junctionTreeNode.toString());
            }
            return stringBuffer.toString();
        }

        void calculatePotentials(BayesNet bayesNet, Set set, boolean[] blArray) {
            int n;
            int n2;
            int n3;
            int n4;
            this.m_fi = new double[this.m_nCardinality];
            int[] nArray = new int[this.m_nNodes.length];
            int[] nArray2 = new int[bayesNet.getNrOfNodes()];
            for (int i = 0; i < this.m_nNodes.length; ++i) {
                nArray2[this.m_nNodes[i]] = i;
            }
            boolean[] blArray2 = new boolean[this.m_nNodes.length];
            for (n4 = 0; n4 < this.m_nNodes.length; ++n4) {
                n3 = this.m_nNodes[n4];
                blArray2[n4] = !blArray[n3];
                for (n2 = 0; n2 < bayesNet.getNrOfParents(n3); ++n2) {
                    n = bayesNet.getParent(n3, n2);
                    if (set.contains(n)) continue;
                    blArray2[n4] = false;
                }
                if (!blArray2[n4]) continue;
                blArray[n3] = true;
                if (!MarginCalculator.this.m_debug) continue;
                System.out.println("adding node " + n3);
            }
            for (n4 = 0; n4 < this.m_nCardinality; ++n4) {
                n3 = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, nArray, nArray2, bayesNet);
                this.m_fi[n3] = 1.0;
                for (n2 = 0; n2 < this.m_nNodes.length; ++n2) {
                    if (!blArray2[n2]) continue;
                    n = this.m_nNodes[n2];
                    int[] nArray3 = bayesNet.getParentSet(n).getParents();
                    int n5 = MarginCalculator.this.getCPT(nArray3, bayesNet.getNrOfParents(n), nArray, nArray2, bayesNet);
                    double d = bayesNet.getDistributions()[n][n5].getProbability(nArray[n2]);
                    int n6 = n3;
                    this.m_fi[n6] = this.m_fi[n6] * d;
                }
                int n7 = n2 = 0;
                nArray[n7] = nArray[n7] + 1;
                while (n2 < this.m_nNodes.length && nArray[n2] == bayesNet.getCardinality(this.m_nNodes[n2])) {
                    nArray[n2] = 0;
                    if (++n2 >= this.m_nNodes.length) continue;
                    int n8 = n2;
                    nArray[n8] = nArray[n8] + 1;
                }
            }
        }

        JunctionTreeNode(Set set, BayesNet bayesNet, boolean[] blArray) {
            this.m_bayesNet = bayesNet;
            this.m_children = new Vector();
            this.m_nNodes = new int[set.size()];
            int n = 0;
            this.m_nCardinality = 1;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                this.m_nNodes[n++] = n2;
                this.m_nCardinality *= bayesNet.getCardinality(n2);
            }
            this.calculatePotentials(bayesNet, set, blArray);
        }

        boolean contains(int n) {
            for (int i = 0; i < this.m_nNodes.length; ++i) {
                if (this.m_nNodes[i] != n) continue;
                return true;
            }
            return false;
        }

        public void setEvidence(int n, int n2) throws Exception {
            int n3;
            int n4;
            int[] nArray = new int[this.m_nNodes.length];
            int[] nArray2 = new int[this.m_bayesNet.getNrOfNodes()];
            int n5 = -1;
            for (n4 = 0; n4 < this.m_nNodes.length; ++n4) {
                nArray2[this.m_nNodes[n4]] = n4;
                if (this.m_nNodes[n4] != n) continue;
                n5 = n4;
            }
            if (n5 < 0) {
                throw new Exception("setEvidence: Node " + n + " not found in this clique");
            }
            for (n4 = 0; n4 < this.m_nCardinality; ++n4) {
                int n6;
                if (nArray[n5] != n2) {
                    n6 = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, nArray, nArray2, this.m_bayesNet);
                    this.m_P[n6] = 0.0;
                }
                int n7 = n6 = 0;
                nArray[n7] = nArray[n7] + 1;
                while (n6 < this.m_nNodes.length && nArray[n6] == this.m_bayesNet.getCardinality(this.m_nNodes[n6])) {
                    nArray[n6] = 0;
                    if (++n6 >= this.m_nNodes.length) continue;
                    int n8 = n6;
                    nArray[n8] = nArray[n8] + 1;
                }
            }
            double d = 0.0;
            for (n3 = 0; n3 < this.m_nCardinality; ++n3) {
                d += this.m_P[n3];
            }
            n3 = 0;
            while (n3 < this.m_nCardinality) {
                int n9 = n3++;
                this.m_P[n9] = this.m_P[n9] / d;
            }
            this.calcMarginalProbabilities();
            this.updateEvidence(this);
        }

        void updateEvidence(JunctionTreeNode junctionTreeNode) {
            Object object;
            Object object2;
            if (junctionTreeNode != this) {
                int n;
                object2 = new int[this.m_nNodes.length];
                object = new int[this.m_bayesNet.getNrOfNodes()];
                for (int i = 0; i < this.m_nNodes.length; ++i) {
                    object[this.m_nNodes[i]] = i;
                }
                int[] nArray = junctionTreeNode.m_parentSeparator.m_nNodes;
                int n2 = nArray.length;
                for (int i = 0; i < this.m_nCardinality; ++i) {
                    int n3 = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, (int[])object2, (int[])object, this.m_bayesNet);
                    n = MarginCalculator.this.getCPT(nArray, n2, (int[])object2, (int[])object, this.m_bayesNet);
                    if (junctionTreeNode.m_parentSeparator.m_fiParent[n] != 0.0) {
                        int n4 = n3;
                        this.m_P[n4] = this.m_P[n4] * (junctionTreeNode.m_parentSeparator.m_fiChild[n] / junctionTreeNode.m_parentSeparator.m_fiParent[n]);
                    } else {
                        this.m_P[n3] = 0.0;
                    }
                    int n5 = 0;
                    Object object3 = object2;
                    int n6 = n5;
                    object3[n6] = object3[n6] + true;
                    while (n5 < this.m_nNodes.length && object2[n5] == this.m_bayesNet.getCardinality(this.m_nNodes[n5])) {
                        object2[n5] = false;
                        if (++n5 >= this.m_nNodes.length) continue;
                        Object object4 = object2;
                        int n7 = n5;
                        object4[n7] = object4[n7] + true;
                    }
                }
                double d = 0.0;
                for (n = 0; n < this.m_nCardinality; ++n) {
                    d += this.m_P[n];
                }
                n = 0;
                while (n < this.m_nCardinality) {
                    int n8 = n++;
                    this.m_P[n8] = this.m_P[n8] / d;
                }
                this.calcMarginalProbabilities();
            }
            object2 = this.m_children.iterator();
            while (object2.hasNext()) {
                object = (JunctionTreeNode)object2.next();
                if (object == junctionTreeNode) continue;
                ((JunctionTreeNode)object).initializeDown(true);
            }
            if (this.m_parentSeparator != null) {
                this.m_parentSeparator.updateFromChild();
                this.m_parentSeparator.m_parentNode.updateEvidence(this);
                this.m_parentSeparator.updateFromParent();
            }
        }
    }

    public class JunctionTreeSeparator
    implements Serializable {
        private static final long serialVersionUID = 6502780192411755343L;
        int[] m_nNodes;
        int m_nCardinality;
        double[] m_fiParent;
        double[] m_fiChild;
        JunctionTreeNode m_parentNode;
        JunctionTreeNode m_childNode;
        BayesNet m_bayesNet;

        JunctionTreeSeparator(Set set, BayesNet bayesNet, JunctionTreeNode junctionTreeNode, JunctionTreeNode junctionTreeNode2) {
            this.m_nNodes = new int[set.size()];
            int n = 0;
            this.m_nCardinality = 1;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                this.m_nNodes[n++] = n2;
                this.m_nCardinality *= bayesNet.getCardinality(n2);
            }
            this.m_parentNode = junctionTreeNode2;
            this.m_childNode = junctionTreeNode;
            this.m_bayesNet = bayesNet;
        }

        public void updateFromParent() {
            double[] dArray = this.update(this.m_parentNode);
            if (dArray == null) {
                this.m_fiParent = null;
            } else {
                int n;
                this.m_fiParent = dArray;
                double d = 0.0;
                for (n = 0; n < this.m_nCardinality; ++n) {
                    d += this.m_fiParent[n];
                }
                n = 0;
                while (n < this.m_nCardinality) {
                    int n2 = n++;
                    this.m_fiParent[n2] = this.m_fiParent[n2] / d;
                }
            }
        }

        public void updateFromChild() {
            double[] dArray = this.update(this.m_childNode);
            if (dArray == null) {
                this.m_fiChild = null;
            } else {
                int n;
                this.m_fiChild = dArray;
                double d = 0.0;
                for (n = 0; n < this.m_nCardinality; ++n) {
                    d += this.m_fiChild[n];
                }
                n = 0;
                while (n < this.m_nCardinality) {
                    int n2 = n++;
                    this.m_fiChild[n2] = this.m_fiChild[n2] / d;
                }
            }
        }

        public double[] update(JunctionTreeNode junctionTreeNode) {
            int n;
            if (junctionTreeNode.m_P == null) {
                return null;
            }
            double[] dArray = new double[this.m_nCardinality];
            int[] nArray = new int[junctionTreeNode.m_nNodes.length];
            int[] nArray2 = new int[this.m_bayesNet.getNrOfNodes()];
            for (n = 0; n < junctionTreeNode.m_nNodes.length; ++n) {
                nArray2[junctionTreeNode.m_nNodes[n]] = n;
            }
            for (n = 0; n < junctionTreeNode.m_nCardinality; ++n) {
                int n2;
                int n3;
                int n4 = MarginCalculator.this.getCPT(junctionTreeNode.m_nNodes, junctionTreeNode.m_nNodes.length, nArray, nArray2, this.m_bayesNet);
                int n5 = n3 = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, nArray, nArray2, this.m_bayesNet);
                dArray[n5] = dArray[n5] + junctionTreeNode.m_P[n4];
                int n6 = n2 = 0;
                nArray[n6] = nArray[n6] + 1;
                while (n2 < junctionTreeNode.m_nNodes.length && nArray[n2] == this.m_bayesNet.getCardinality(junctionTreeNode.m_nNodes[n2])) {
                    nArray[n2] = 0;
                    if (++n2 >= junctionTreeNode.m_nNodes.length) continue;
                    int n7 = n2;
                    nArray[n7] = nArray[n7] + 1;
                }
            }
            return dArray;
        }
    }
}

