/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class GraftSplit
extends ClassifierSplitModel
implements Comparable {
    private Distribution m_graftdistro;
    private int m_attIndex;
    private double m_splitPoint;
    private int m_maxClass;
    private int m_otherLeafMaxClass;
    private double m_laplace;
    private Distribution m_leafdistro;
    private int m_testType;

    public GraftSplit(int n, double d, int n2, double d2, double d3) {
        this.m_attIndex = n;
        this.m_splitPoint = d;
        this.m_testType = n2;
        this.m_maxClass = (int)d2;
        this.m_laplace = d3;
    }

    public GraftSplit(int n, double d, int n2, double d2, double[][] dArray) throws Exception {
        this.m_attIndex = n;
        this.m_splitPoint = d;
        this.m_testType = n2;
        this.m_otherLeafMaxClass = (int)d2;
        this.m_numSubsets = 2;
        int n3 = this.subsetOfInterest();
        this.m_distribution = new Distribution(dArray);
        double[][] dArray2 = new double[1][this.m_distribution.numClasses()];
        for (int i = 0; i < dArray2[0].length; ++i) {
            dArray2[0][i] = dArray[n3][i];
        }
        this.m_leafdistro = new Distribution(dArray2);
        this.m_maxClass = this.m_distribution.maxClass(n3);
        this.m_laplace = (this.m_distribution.perClassPerBag(n3, this.m_maxClass) + 1.0) / (this.m_distribution.perBag(n3) + 2.0);
    }

    public void deleteGraftedCases(Instances instances) {
        int n = this.subsetOfInterest();
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (this.whichSubset(instances.instance(i)) != n) continue;
            instances.delete(i--);
        }
    }

    public void buildClassifier(Instances instances) throws Exception {
        double d;
        int n;
        this.m_graftdistro = new Distribution(2, instances.numClasses());
        int n2 = this.subsetOfInterest();
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = true;
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            if (instance.isMissing(this.m_attIndex)) {
                bl = false;
                continue;
            }
            d3 += instance.weight();
            n = this.whichSubset(instance);
            if (n == -1) continue;
            this.m_graftdistro.add(n, instance);
            if (n != n2) continue;
            d2 += instance.weight();
        }
        double d4 = d = d3 == 0.0 ? 0.5 : d2 / d3;
        if (!bl) {
            for (n = 0; n < instances.numInstances(); ++n) {
                Instance instance;
                int n3;
                if (!instances.instance(n).isMissing(this.m_attIndex) || (n3 = this.whichSubset(instance = instances.instance(n))) == -1) continue;
                instance.setWeight(instance.weight() * d);
                this.m_graftdistro.add(n3, instance);
            }
        }
        if (this.m_graftdistro.perBag(n2) == 0.0) {
            double[] dArray = new double[instances.numClasses()];
            dArray[this.m_maxClass] = 0.01;
            this.m_graftdistro.add(n2, dArray);
        }
        if (this.m_graftdistro.perBag(n2 == 0 ? 1 : 0) == 0.0) {
            double[] dArray = new double[instances.numClasses()];
            dArray[this.m_otherLeafMaxClass] = 0.01;
            this.m_graftdistro.add(n2 == 0 ? 1 : 0, dArray);
        }
    }

    public NoSplit getLeaf() {
        return new NoSplit(this.m_leafdistro);
    }

    public NoSplit getOtherLeaf() {
        int n = this.subsetOfInterest() == 0 ? 1 : 0;
        double[][] dArray = new double[1][this.m_graftdistro.numClasses()];
        double d = 0.0;
        for (int i = 0; i < dArray[0].length; ++i) {
            dArray[0][i] = this.m_graftdistro.perClassPerBag(n, i);
            d += dArray[0][i];
        }
        if (d == 0.0) {
            double[] dArray2 = dArray[0];
            int n2 = this.m_otherLeafMaxClass;
            dArray2[n2] = dArray2[n2] + 0.01;
        }
        return new NoSplit(new Distribution(dArray));
    }

    public final String dumpLabelG(int n, Instances instances) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(instances.classAttribute().value(n == this.subsetOfInterest() ? this.m_maxClass : this.m_otherLeafMaxClass));
        stringBuffer.append(" (" + Utils.roundDouble(this.m_graftdistro.perBag(n), 1));
        if (Utils.gr(this.m_graftdistro.numIncorrect(n), 0.0)) {
            stringBuffer.append("/" + Utils.roundDouble(this.m_graftdistro.numIncorrect(n), 2));
        }
        if (n == this.subsetOfInterest()) {
            stringBuffer.append("|" + Utils.roundDouble(this.m_distribution.perBag(n), 2));
            if (Utils.gr(this.m_distribution.numIncorrect(n), 0.0)) {
                stringBuffer.append("/" + Utils.roundDouble(this.m_distribution.numIncorrect(n), 2));
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int subsetOfInterest() {
        if (this.m_testType == 2) {
            return 0;
        }
        if (this.m_testType == 3) {
            return 1;
        }
        return this.m_testType;
    }

    public double positivesForSubsetOfInterest() {
        return this.m_distribution.perClassPerBag(this.subsetOfInterest(), this.m_maxClass);
    }

    public double positives(int n) {
        return this.m_distribution.perClassPerBag(n, this.m_distribution.maxClass(n));
    }

    public double totalForSubsetOfInterest() {
        return this.m_distribution.perBag(this.subsetOfInterest());
    }

    public double totalForSubset(int n) {
        return this.m_distribution.perBag(n);
    }

    public String leftSide(Instances instances) {
        return instances.attribute(this.m_attIndex).name();
    }

    public int attribute() {
        return this.m_attIndex;
    }

    public final String rightSide(int n, Instances instances) {
        StringBuffer stringBuffer = new StringBuffer();
        if (instances.attribute(this.m_attIndex).isNominal()) {
            if (n == 0) {
                stringBuffer.append(" = " + instances.attribute(this.m_attIndex).value((int)this.m_splitPoint));
            } else {
                stringBuffer.append(" != " + instances.attribute(this.m_attIndex).value((int)this.m_splitPoint));
            }
        } else if (n == 0) {
            stringBuffer.append(" <= " + Utils.doubleToString(this.m_splitPoint, 6));
        } else {
            stringBuffer.append(" > " + Utils.doubleToString(this.m_splitPoint, 6));
        }
        return stringBuffer.toString();
    }

    public final String sourceExpression(int n, Instances instances) {
        StringBuffer stringBuffer = null;
        if (n < 0) {
            return "i[" + this.m_attIndex + "] == null";
        }
        if (instances.attribute(this.m_attIndex).isNominal()) {
            stringBuffer = n == 0 ? new StringBuffer("i[") : new StringBuffer("!i[");
            stringBuffer.append(this.m_attIndex).append("]");
            stringBuffer.append(".equals(\"").append(instances.attribute(this.m_attIndex).value((int)this.m_splitPoint)).append("\")");
        } else {
            stringBuffer = new StringBuffer("((Double) i[");
            stringBuffer.append(this.m_attIndex).append("])");
            if (n == 0) {
                stringBuffer.append(".doubleValue() <= ").append(this.m_splitPoint);
            } else {
                stringBuffer.append(".doubleValue() > ").append(this.m_splitPoint);
            }
        }
        return stringBuffer.toString();
    }

    public double[] weights(Instance instance) {
        if (instance.isMissing(this.m_attIndex)) {
            double[] dArray = new double[this.m_numSubsets];
            for (int i = 0; i < this.m_numSubsets; ++i) {
                dArray[i] = this.m_graftdistro.perBag(i) / this.m_graftdistro.total();
            }
            return dArray;
        }
        return null;
    }

    public int whichSubset(Instance instance) {
        if (instance.isMissing(this.m_attIndex)) {
            return -1;
        }
        if (instance.attribute(this.m_attIndex).isNominal()) {
            if (instance.value(this.m_attIndex) == this.m_splitPoint) {
                return 0;
            }
            return 1;
        }
        if (Utils.smOrEq(instance.value(this.m_attIndex), this.m_splitPoint)) {
            return 0;
        }
        return 1;
    }

    public double splitPoint() {
        return this.m_splitPoint;
    }

    public int maxClassForSubsetOfInterest() {
        return this.m_maxClass;
    }

    public double laplaceForSubsetOfInterest() {
        return this.m_laplace;
    }

    public int testType() {
        return this.m_testType;
    }

    public int compareTo(Object object) {
        if (this.m_laplace > ((GraftSplit)object).laplaceForSubsetOfInterest()) {
            return 1;
        }
        if (this.m_laplace < ((GraftSplit)object).laplaceForSubsetOfInterest()) {
            return -1;
        }
        return 0;
    }

    public final double classProb(int n, Instance instance, int n2) throws Exception {
        if (n2 <= -1) {
            double[] dArray = this.weights(instance);
            if (dArray == null) {
                return this.m_distribution.prob(n);
            }
            double d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i] * this.m_distribution.prob(n, i);
            }
            return d;
        }
        if (Utils.gr(this.m_distribution.perBag(n2), 0.0)) {
            return this.m_distribution.prob(n, n2);
        }
        return this.m_distribution.prob(n);
    }

    public String toString(Instances instances) {
        String string = this.m_testType == 0 ? " <= " : (this.m_testType == 1 ? " > " : (this.m_testType == 2 ? " = " : " != "));
        string = instances.attribute(this.m_attIndex).isNominal() ? string + instances.attribute(this.m_attIndex).value((int)this.m_splitPoint) : string + Double.toString(this.m_splitPoint);
        return instances.attribute(this.m_attIndex).name() + string + " (" + Double.toString(this.m_laplace) + ") --> " + instances.attribute(instances.classIndex()).value(this.m_maxClass);
    }
}

