/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.ArffSaver;
import weka.core.converters.C45Loader;
import weka.core.converters.C45Saver;
import weka.core.converters.CSVLoader;
import weka.core.converters.CSVSaver;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.LibSVMLoader;
import weka.core.converters.LibSVMSaver;
import weka.core.converters.Loader;
import weka.core.converters.Saver;
import weka.core.converters.SerializedInstancesLoader;
import weka.core.converters.SerializedInstancesSaver;
import weka.core.converters.TextDirectoryLoader;
import weka.core.converters.URLSourcedLoader;
import weka.core.converters.XRFFLoader;
import weka.core.converters.XRFFSaver;
import weka.gui.GenericObjectEditor;
import weka.gui.GenericPropertiesCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterUtils
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -2460855349276148760L;
    public static final String CORE_FILE_LOADERS;
    public static final String CORE_FILE_SAVERS;
    protected static Hashtable<String, String> m_FileLoaders;
    protected static Hashtable<String, String> m_URLFileLoaders;
    protected static Hashtable<String, String> m_FileSavers;

    protected static Hashtable<String, String> getFileConverters(String string, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray2 = string.split(",");
        for (int i = 0; i < stringArray2.length; ++i) {
            vector.add(stringArray2[i]);
        }
        return ConverterUtils.getFileConverters(vector, stringArray);
    }

    protected static Hashtable<String, String> getFileConverters(Vector vector, String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray2;
            FileSourcedConverter fileSourcedConverter;
            Class<?> clazz;
            int n;
            String string = (String)vector.get(i);
            for (n = 0; n < stringArray.length; ++n) {
                if (ClassDiscovery.hasInterface(stringArray[n], string)) continue;
            }
            try {
                clazz = Class.forName(string);
                fileSourcedConverter = (FileSourcedConverter)clazz.newInstance();
                stringArray2 = fileSourcedConverter.getFileExtensions();
            }
            catch (Exception exception) {
                clazz = null;
                fileSourcedConverter = null;
                stringArray2 = new String[]{};
            }
            if (fileSourcedConverter == null) continue;
            for (n = 0; n < stringArray2.length; ++n) {
                hashtable.put(stringArray2[n], string);
            }
        }
        return hashtable;
    }

    public static void getFirstToken(StreamTokenizer streamTokenizer) throws IOException {
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == 39 || streamTokenizer.ttype == 34) {
            streamTokenizer.ttype = -3;
        } else if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equals("?")) {
            streamTokenizer.ttype = 63;
        }
    }

    public static void getToken(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 10) {
            return;
        }
        if (streamTokenizer.ttype == 39 || streamTokenizer.ttype == 34) {
            streamTokenizer.ttype = -3;
        } else if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equals("?")) {
            streamTokenizer.ttype = 63;
        }
    }

    public static void errms(StreamTokenizer streamTokenizer, String string) throws IOException {
        throw new IOException(string + ", read " + streamTokenizer.toString());
    }

    protected static Vector<String> getConverters(Hashtable<String, String> hashtable) {
        Vector<String> vector = new Vector<String>();
        Enumeration<String> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (vector.contains(string)) continue;
            vector.add(string);
        }
        Collections.sort(vector);
        return vector;
    }

    protected static Object getConverterForFile(String string, Hashtable<String, String> hashtable) {
        Object object = null;
        int n = string.lastIndexOf(46);
        if (n > -1) {
            String string2 = string.substring(n).toLowerCase();
            object = ConverterUtils.getConverterForExtension(string2, hashtable);
            if (string2.equals(".gz") && object == null) {
                n = string.lastIndexOf(46, n - 1);
                string2 = string.substring(n).toLowerCase();
                object = ConverterUtils.getConverterForExtension(string2, hashtable);
            }
        }
        return object;
    }

    protected static Object getConverterForExtension(String string, Hashtable<String, String> hashtable) {
        Object var2_2 = null;
        String string2 = hashtable.get(string);
        if (string2 != null) {
            try {
                var2_2 = Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                var2_2 = null;
                exception.printStackTrace();
            }
        }
        return var2_2;
    }

    public static boolean isCoreFileLoader(String string) {
        Object[] objectArray = CORE_FILE_LOADERS.split(",");
        boolean bl = Arrays.binarySearch(objectArray, string) >= 0;
        return bl;
    }

    public static Vector<String> getFileLoaders() {
        return ConverterUtils.getConverters(m_FileLoaders);
    }

    public static AbstractFileLoader getLoaderForFile(String string) {
        return (AbstractFileLoader)ConverterUtils.getConverterForFile(string, m_FileLoaders);
    }

    public static AbstractFileLoader getLoaderForFile(File file) {
        return ConverterUtils.getLoaderForFile(file.getAbsolutePath());
    }

    public static AbstractFileLoader getLoaderForExtension(String string) {
        return (AbstractFileLoader)ConverterUtils.getConverterForExtension(string, m_FileLoaders);
    }

    public static Vector<String> getURLFileLoaders() {
        return ConverterUtils.getConverters(m_URLFileLoaders);
    }

    public static AbstractFileLoader getURLLoaderForFile(String string) {
        return (AbstractFileLoader)ConverterUtils.getConverterForFile(string, m_URLFileLoaders);
    }

    public static AbstractFileLoader getURLLoaderForFile(File file) {
        return ConverterUtils.getURLLoaderForFile(file.getAbsolutePath());
    }

    public static AbstractFileLoader getURLLoaderForExtension(String string) {
        return (AbstractFileLoader)ConverterUtils.getConverterForExtension(string, m_URLFileLoaders);
    }

    public static boolean isCoreFileSaver(String string) {
        Object[] objectArray = CORE_FILE_SAVERS.split(",");
        boolean bl = Arrays.binarySearch(objectArray, string) >= 0;
        return bl;
    }

    public static Vector<String> getFileSavers() {
        return ConverterUtils.getConverters(m_FileSavers);
    }

    public static AbstractFileSaver getSaverForFile(String string) {
        return (AbstractFileSaver)ConverterUtils.getConverterForFile(string, m_FileSavers);
    }

    public static AbstractFileSaver getSaverForFile(File file) {
        return ConverterUtils.getSaverForFile(file.getAbsolutePath());
    }

    public static AbstractFileSaver getSaverForExtension(String string) {
        return (AbstractFileSaver)ConverterUtils.getConverterForExtension(string, m_FileSavers);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4924 $");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Vector<String> vector;
        block13: {
            CORE_FILE_LOADERS = ArffLoader.class.getName() + "," + C45Loader.class.getName() + "," + CSVLoader.class.getName() + "," + DatabaseConverter.class.getName() + "," + LibSVMLoader.class.getName() + "," + SerializedInstancesLoader.class.getName() + "," + TextDirectoryLoader.class.getName() + "," + XRFFLoader.class.getName();
            CORE_FILE_SAVERS = ArffSaver.class.getName() + "," + C45Saver.class.getName() + "," + CSVSaver.class.getName() + "," + DatabaseConverter.class.getName() + "," + LibSVMSaver.class.getName() + "," + SerializedInstancesSaver.class.getName() + "," + XRFFSaver.class.getName();
            try {
                try {
                    GenericPropertiesCreator genericPropertiesCreator = new GenericPropertiesCreator();
                    genericPropertiesCreator.execute(false);
                    Properties properties = genericPropertiesCreator.getOutputProperties();
                    m_FileLoaders = new Hashtable();
                    m_URLFileLoaders = new Hashtable();
                    m_FileSavers = new Hashtable();
                    m_FileLoaders = ConverterUtils.getFileConverters(properties.getProperty(Loader.class.getName(), CORE_FILE_LOADERS), new String[]{FileSourcedConverter.class.getName()});
                    m_URLFileLoaders = ConverterUtils.getFileConverters(properties.getProperty(Loader.class.getName(), CORE_FILE_LOADERS), new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
                    m_FileSavers = ConverterUtils.getFileConverters(properties.getProperty(Saver.class.getName(), CORE_FILE_SAVERS), new String[]{FileSourcedConverter.class.getName()});
                }
                catch (Exception exception) {
                    Vector<String> vector2;
                    Object var4_4 = null;
                    if (m_FileLoaders.size() == 0) {
                        vector2 = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
                        m_FileLoaders = vector2.size() > 0 ? ConverterUtils.getFileConverters(vector2, new String[]{FileSourcedConverter.class.getName()}) : ConverterUtils.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName()});
                    }
                    if (m_URLFileLoaders.size() == 0) {
                        vector2 = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
                        m_URLFileLoaders = vector2.size() > 0 ? ConverterUtils.getFileConverters(vector2, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()}) : ConverterUtils.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
                    }
                    if (m_FileSavers.size() != 0) return;
                    vector2 = GenericObjectEditor.getClassnames(AbstractFileSaver.class.getName());
                    if (vector2.size() > 0) {
                        m_FileSavers = ConverterUtils.getFileConverters(vector2, new String[]{FileSourcedConverter.class.getName()});
                        return;
                    }
                    m_FileSavers = ConverterUtils.getFileConverters(CORE_FILE_SAVERS, new String[]{FileSourcedConverter.class.getName()});
                    return;
                }
                Object var4_3 = null;
                if (m_FileLoaders.size() != 0) break block13;
            }
            catch (Throwable throwable) {
                Vector<String> vector3;
                Object var4_5 = null;
                if (m_FileLoaders.size() == 0) {
                    vector3 = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
                    m_FileLoaders = vector3.size() > 0 ? ConverterUtils.getFileConverters(vector3, new String[]{FileSourcedConverter.class.getName()}) : ConverterUtils.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName()});
                }
                if (m_URLFileLoaders.size() == 0) {
                    vector3 = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
                    m_URLFileLoaders = vector3.size() > 0 ? ConverterUtils.getFileConverters(vector3, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()}) : ConverterUtils.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
                }
                if (m_FileSavers.size() != 0) throw throwable;
                vector3 = GenericObjectEditor.getClassnames(AbstractFileSaver.class.getName());
                if (vector3.size() > 0) {
                    m_FileSavers = ConverterUtils.getFileConverters(vector3, new String[]{FileSourcedConverter.class.getName()});
                    throw throwable;
                }
                m_FileSavers = ConverterUtils.getFileConverters(CORE_FILE_SAVERS, new String[]{FileSourcedConverter.class.getName()});
                throw throwable;
            }
            vector = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
            m_FileLoaders = vector.size() > 0 ? ConverterUtils.getFileConverters(vector, new String[]{FileSourcedConverter.class.getName()}) : ConverterUtils.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName()});
        }
        if (m_URLFileLoaders.size() == 0) {
            vector = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
            m_URLFileLoaders = vector.size() > 0 ? ConverterUtils.getFileConverters(vector, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()}) : ConverterUtils.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
        }
        if (m_FileSavers.size() != 0) return;
        vector = GenericObjectEditor.getClassnames(AbstractFileSaver.class.getName());
        if (vector.size() > 0) {
            m_FileSavers = ConverterUtils.getFileConverters(vector, new String[]{FileSourcedConverter.class.getName()});
            return;
        }
        m_FileSavers = ConverterUtils.getFileConverters(CORE_FILE_SAVERS, new String[]{FileSourcedConverter.class.getName()});
    }

    public static class DataSink
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -1504966891136411204L;
        protected Saver m_Saver = null;
        protected OutputStream m_Stream = null;

        public DataSink(String string) throws Exception {
            this.m_Stream = null;
            this.m_Saver = DataSource.isArff(string) ? new ArffSaver() : ConverterUtils.getSaverForFile(string);
            ((AbstractFileSaver)this.m_Saver).setFile(new File(string));
        }

        public DataSink(Saver saver) {
            this.m_Saver = saver;
            this.m_Stream = null;
        }

        public DataSink(OutputStream outputStream) {
            this.m_Saver = null;
            this.m_Stream = outputStream;
        }

        public void write(Instances instances) throws Exception {
            if (this.m_Saver != null) {
                this.m_Saver.setInstances(instances);
                this.m_Saver.writeBatch();
            } else {
                this.m_Stream.write(instances.toString().getBytes());
                this.m_Stream.flush();
            }
        }

        public static void write(String string, Instances instances) throws Exception {
            DataSink dataSink = new DataSink(string);
            dataSink.write(instances);
        }

        public static void write(Saver saver, Instances instances) throws Exception {
            DataSink dataSink = new DataSink(saver);
            dataSink.write(instances);
        }

        public static void write(OutputStream outputStream, Instances instances) throws Exception {
            DataSink dataSink = new DataSink(outputStream);
            dataSink.write(instances);
        }

        public static void main(String[] stringArray) throws Exception {
            if (stringArray.length != 2) {
                System.out.println("\nUsage: " + DataSource.class.getName() + " <input-file> <output-file>\n");
                System.exit(1);
            }
            Instances instances = DataSource.read(stringArray[0]);
            DataSink.write(stringArray[1], instances);
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 4924 $");
        }
    }

    public static class DataSource
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -613122395928757332L;
        protected File m_File;
        protected URL m_URL;
        protected Loader m_Loader;
        protected boolean m_Incremental;
        protected int m_BatchCounter;
        protected Instance m_IncrementalBuffer;
        protected Instances m_BatchBuffer;

        public DataSource(String string) throws Exception {
            if (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://") || string.startsWith("file://")) {
                this.m_URL = new URL(string);
            } else {
                this.m_File = new File(string);
            }
            if (DataSource.isArff(string)) {
                this.m_Loader = new ArffLoader();
            } else {
                this.m_Loader = this.m_File != null ? ConverterUtils.getLoaderForFile(string) : ConverterUtils.getURLLoaderForFile(string);
                if (this.m_Loader == null) {
                    throw new IllegalArgumentException("No suitable converter found for '" + string + "'!");
                }
            }
            this.m_Incremental = this.m_Loader instanceof IncrementalConverter;
            this.reset();
        }

        public DataSource(Instances instances) {
            this.m_BatchBuffer = instances;
            this.m_Loader = null;
            this.m_File = null;
            this.m_URL = null;
            this.m_Incremental = false;
        }

        public DataSource(Loader loader) {
            this.m_BatchBuffer = null;
            this.m_Loader = loader;
            this.m_File = null;
            this.m_URL = null;
            this.m_Incremental = this.m_Loader instanceof IncrementalConverter;
            this.initBatchBuffer();
        }

        public DataSource(InputStream inputStream) {
            this.m_BatchBuffer = null;
            this.m_Loader = new ArffLoader();
            try {
                this.m_Loader.setSource(inputStream);
            }
            catch (Exception exception) {
                this.m_Loader = null;
            }
            this.m_File = null;
            this.m_URL = null;
            this.m_Incremental = this.m_Loader instanceof IncrementalConverter;
            this.initBatchBuffer();
        }

        protected void initBatchBuffer() {
            try {
                this.m_BatchBuffer = !this.isIncremental() ? this.m_Loader.getDataSet() : null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public static boolean isArff(String string) {
            return string.toLowerCase().endsWith(ArffLoader.FILE_EXTENSION.toLowerCase()) || string.toLowerCase().endsWith(ArffLoader.FILE_EXTENSION_COMPRESSED.toLowerCase());
        }

        public boolean isIncremental() {
            return this.m_Incremental;
        }

        public Loader getLoader() {
            return this.m_Loader;
        }

        public Instances getDataSet() throws Exception {
            Instances instances = null;
            this.reset();
            try {
                instances = this.m_BatchBuffer == null ? this.m_Loader.getDataSet() : this.m_BatchBuffer;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                instances = null;
            }
            return instances;
        }

        public Instances getDataSet(int n) throws Exception {
            Instances instances = this.getDataSet();
            if (instances != null) {
                instances.setClassIndex(n);
            }
            return instances;
        }

        public void reset() throws Exception {
            if (this.m_File != null) {
                ((AbstractFileLoader)this.m_Loader).setFile(this.m_File);
            } else if (this.m_URL != null) {
                ((URLSourcedLoader)((Object)this.m_Loader)).setURL(this.m_URL.toString());
            } else if (this.m_Loader != null) {
                this.m_Loader.reset();
            }
            this.m_BatchCounter = 0;
            this.m_IncrementalBuffer = null;
            if (this.m_Loader != null) {
                this.m_BatchBuffer = !this.isIncremental() ? this.m_Loader.getDataSet() : null;
            }
        }

        public Instances getStructure() throws Exception {
            if (this.m_BatchBuffer == null) {
                return this.m_Loader.getStructure();
            }
            return new Instances(this.m_BatchBuffer, 0);
        }

        public Instances getStructure(int n) throws Exception {
            Instances instances = this.getStructure();
            if (instances != null) {
                instances.setClassIndex(n);
            }
            return instances;
        }

        public boolean hasMoreElements(Instances instances) {
            boolean bl = false;
            if (this.isIncremental()) {
                if (this.m_IncrementalBuffer != null) {
                    bl = true;
                } else {
                    try {
                        this.m_IncrementalBuffer = this.m_Loader.getNextInstance(instances);
                        bl = this.m_IncrementalBuffer != null;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        bl = false;
                    }
                }
            } else {
                bl = this.m_BatchCounter < this.m_BatchBuffer.numInstances();
            }
            return bl;
        }

        public Instance nextElement(Instances instances) {
            Instance instance = null;
            if (this.isIncremental()) {
                if (this.m_IncrementalBuffer != null) {
                    instance = this.m_IncrementalBuffer;
                    this.m_IncrementalBuffer = null;
                } else {
                    try {
                        instance = this.m_Loader.getNextInstance(instances);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        instance = null;
                    }
                }
            } else if (this.m_BatchCounter < this.m_BatchBuffer.numInstances()) {
                instance = this.m_BatchBuffer.instance(this.m_BatchCounter);
                ++this.m_BatchCounter;
            }
            instance.setDataset(instances);
            return instance;
        }

        public static Instances read(String string) throws Exception {
            DataSource dataSource = new DataSource(string);
            Instances instances = dataSource.getDataSet();
            return instances;
        }

        public static Instances read(InputStream inputStream) throws Exception {
            DataSource dataSource = new DataSource(inputStream);
            Instances instances = dataSource.getDataSet();
            return instances;
        }

        public static Instances read(Loader loader) throws Exception {
            DataSource dataSource = new DataSource(loader);
            Instances instances = dataSource.getDataSet();
            return instances;
        }

        public static void main(String[] stringArray) throws Exception {
            if (stringArray.length != 1) {
                System.out.println("\nUsage: " + DataSource.class.getName() + " <file>\n");
                System.exit(1);
            }
            DataSource dataSource = new DataSource(stringArray[0]);
            System.out.println("Incremental? " + dataSource.isIncremental());
            System.out.println("Loader: " + dataSource.getLoader().getClass().getName());
            System.out.println("Data:\n");
            Instances instances = dataSource.getStructure();
            System.out.println(instances);
            while (dataSource.hasMoreElements(instances)) {
                System.out.println(dataSource.nextElement(instances));
            }
            Instances instances2 = dataSource.getDataSet();
            dataSource = new DataSource(instances2);
            System.out.println("\n\nProxy-Data:\n");
            System.out.println(dataSource.getStructure());
            while (dataSource.hasMoreElements(instances)) {
                System.out.println(dataSource.nextElement(instances2));
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 4924 $");
        }
    }
}

