/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeModel;
import weka.classifiers.Classifier;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.trees.J48;
import weka.gui.GenericObjectEditor;
import weka.gui.ensembleLibraryEditor.ListModelsPanel;
import weka.gui.ensembleLibraryEditor.ModelList;
import weka.gui.ensembleLibraryEditor.tree.GenericObjectNode;
import weka.gui.ensembleLibraryEditor.tree.ModelTreeNodeEditor;
import weka.gui.ensembleLibraryEditor.tree.ModelTreeNodeRenderer;

public class AddModelsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 4874639416371962573L;
    private ListModelsPanel m_ListModelsPanel;
    private JTree m_Tree;
    private DefaultTreeModel m_TreeModel;
    private JButton m_GenerateButton;
    private JLabel m_GenerateLabel;
    private JButton m_RemoveSelectedButton;
    private JButton m_RemoveInvalidButton;
    private JButton m_AddSelectedButton;
    private JButton m_AddAllButton;
    private ModelList m_ModelList;
    JScrollPane m_TreeView;

    public AddModelsPanel(ListModelsPanel listModelsPanel) {
        this.m_ListModelsPanel = listModelsPanel;
        this.createAddModelsPanel();
    }

    private void createAddModelsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.m_TreeView = new JScrollPane();
        this.m_TreeView.setPreferredSize(new Dimension(150, 50));
        this.buildClassifierTree(new J48());
        ToolTipManager.sharedInstance().registerComponent(this.m_Tree);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.m_TreeView, gridBagConstraints);
        this.m_GenerateButton = new JButton("Generate Models");
        this.m_GenerateButton.setToolTipText("Generate a set of models from options specified in options tree");
        this.m_GenerateButton.addActionListener(this);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.m_GenerateButton, gridBagConstraints);
        this.m_GenerateLabel = new JLabel("");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.m_GenerateLabel, gridBagConstraints);
        this.m_RemoveInvalidButton = new JButton("Remove Invalid");
        this.m_RemoveInvalidButton.setToolTipText("Remove all invalid (red) models from the above list");
        this.m_RemoveInvalidButton.addActionListener(this);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.m_ModelList = new ModelList();
        this.m_ModelList.getInputMap().put(KeyStroke.getKeyStroke("released DELETE"), "deleteSelected");
        this.m_ModelList.getActionMap().put("deleteSelected", new AbstractAction("deleteSelected"){
            private static final long serialVersionUID = -3351194234735560372L;

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = AddModelsPanel.this.m_ModelList.getSelectedValues();
                ModelList.SortedListModel sortedListModel = (ModelList.SortedListModel)AddModelsPanel.this.m_ModelList.getModel();
                for (int i = 0; i < objectArray.length; ++i) {
                    sortedListModel.removeElement((EnsembleLibraryModel)objectArray[i]);
                }
                int[] nArray = new int[]{AddModelsPanel.this.m_ModelList.getSelectedIndices()[0]};
                AddModelsPanel.this.m_ModelList.setSelectedIndices(nArray);
            }
        });
        this.m_ModelList.setSelectionMode(2);
        this.m_ModelList.setLayoutOrientation(0);
        this.m_ModelList.setVisibleRowCount(-1);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Working Set of Newly Generated Models"));
        JScrollPane jScrollPane = new JScrollPane(this.m_ModelList);
        jScrollPane.setPreferredSize(new Dimension(150, 50));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)jPanel, gridBagConstraints);
        this.m_RemoveSelectedButton = new JButton("Remove Selected");
        this.m_RemoveSelectedButton.setToolTipText("Remove all currently selected models from the above list");
        this.m_RemoveSelectedButton.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.m_RemoveSelectedButton, gridBagConstraints);
        this.m_AddSelectedButton = new JButton("Add Selected");
        this.m_AddSelectedButton.setToolTipText("Add selected models in the above list to the model library");
        this.m_AddSelectedButton.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.m_AddSelectedButton, gridBagConstraints);
        this.m_AddAllButton = new JButton("Add All");
        this.m_AddAllButton.setToolTipText("Add all models in the above list to the model library");
        this.m_AddAllButton.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.m_AddAllButton, gridBagConstraints);
    }

    public void buildClassifierTree(Classifier classifier) {
        GenericObjectEditor genericObjectEditor = new GenericObjectEditor();
        genericObjectEditor.setClassType(Classifier.class);
        genericObjectEditor.setValue(classifier);
        GenericObjectNode genericObjectNode = new GenericObjectNode(this, classifier, genericObjectEditor, "Current Classifier");
        this.m_TreeModel = new DefaultTreeModel(genericObjectNode);
        this.m_Tree = new JTree(this.m_TreeModel);
        genericObjectNode.setTree(this.m_Tree);
        genericObjectNode.updateTree();
        this.m_Tree.setRootVisible(true);
        ModelTreeNodeRenderer modelTreeNodeRenderer = new ModelTreeNodeRenderer();
        this.m_Tree.setCellRenderer(modelTreeNodeRenderer);
        this.m_Tree.setCellEditor(new ModelTreeNodeEditor(this.m_Tree));
        this.m_Tree.setEditable(true);
        this.m_Tree.setVisibleRowCount(8);
        this.m_Tree.setRowHeight(0);
        this.m_TreeView.setViewportView(this.m_Tree);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block11: {
            ModelList.SortedListModel sortedListModel;
            block12: {
                block10: {
                    sortedListModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
                    if (actionEvent.getSource() != this.m_GenerateButton) break block10;
                    Vector vector = ((GenericObjectNode)this.m_TreeModel.getRoot()).getValues();
                    int n = vector.size();
                    int n2 = 0;
                    for (int i = 0; i < vector.size(); ++i) {
                        Classifier classifier = (Classifier)vector.get(i);
                        EnsembleLibraryModel ensembleLibraryModel = this.m_ListModelsPanel.getLibrary().createModel(classifier);
                        ensembleLibraryModel.testOptions();
                        if (!ensembleLibraryModel.getOptionsWereValid()) {
                            ++n2;
                        }
                        sortedListModel.add(ensembleLibraryModel);
                    }
                    String string = new String("  " + n + " models generated");
                    string = string + ", " + n2 + " had errors";
                    this.m_GenerateLabel.setText(string);
                    break block11;
                }
                if (actionEvent.getSource() != this.m_RemoveSelectedButton) break block12;
                Object[] objectArray = this.m_ModelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    sortedListModel.removeElement(objectArray[i]);
                }
                if (this.m_ModelList.getSelectedIndices().length <= 0) break block11;
                int[] nArray = new int[]{this.m_ModelList.getSelectedIndices()[0]};
                this.m_ModelList.setSelectedIndices(nArray);
                break block11;
            }
            if (actionEvent.getSource() == this.m_RemoveInvalidButton) {
                int n;
                Vector<EnsembleLibraryModel> vector = new Vector<EnsembleLibraryModel>();
                for (n = 0; n < sortedListModel.getSize(); ++n) {
                    EnsembleLibraryModel ensembleLibraryModel = (EnsembleLibraryModel)sortedListModel.getElementAt(n);
                    if (ensembleLibraryModel.getOptionsWereValid()) continue;
                    vector.add(ensembleLibraryModel);
                }
                for (n = 0; n < vector.size(); ++n) {
                    sortedListModel.removeElement(vector.get(n));
                }
            } else if (actionEvent.getSource() == this.m_AddAllButton) {
                Iterator iterator = sortedListModel.iterator();
                while (iterator.hasNext()) {
                    EnsembleLibraryModel ensembleLibraryModel = (EnsembleLibraryModel)iterator.next();
                    if (!ensembleLibraryModel.getOptionsWereValid()) continue;
                    this.m_ListModelsPanel.addModel(ensembleLibraryModel);
                }
                int n = sortedListModel.getSize();
                for (int i = 0; i < n; ++i) {
                    sortedListModel.removeElement(sortedListModel.getElementAt(0));
                }
            }
        }
    }
}

