/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.kdtrees;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.neighboursearch.kdtrees.KDTreeNode;

public abstract class KDTreeNodeSplitter
implements Serializable,
OptionHandler {
    protected Instances m_Instances;
    protected EuclideanDistance m_EuclideanDistance;
    protected int[] m_InstList;
    protected boolean m_NormalizeNodeWidth;
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int WIDTH = 2;

    public KDTreeNodeSplitter() {
    }

    public KDTreeNodeSplitter(int[] nArray, Instances instances, EuclideanDistance euclideanDistance) {
        this.m_InstList = nArray;
        this.m_Instances = instances;
        this.m_EuclideanDistance = euclideanDistance;
    }

    public Enumeration listOptions() {
        return new Vector().elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
    }

    public String[] getOptions() {
        return new String[0];
    }

    protected void correctlyInitialized() throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied.");
        }
        if (this.m_InstList == null) {
            throw new Exception("No instance list supplied.");
        }
        if (this.m_EuclideanDistance == null) {
            throw new Exception("No Euclidean distance function supplied.");
        }
        if (this.m_Instances.numInstances() != this.m_InstList.length) {
            throw new Exception("The supplied instance list doesn't seem to match the supplied instances");
        }
    }

    public abstract void splitNode(KDTreeNode var1, int var2, double[][] var3, double[][] var4) throws Exception;

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    public void setInstanceList(int[] nArray) {
        this.m_InstList = nArray;
    }

    public void setEuclideanDistanceFunction(EuclideanDistance euclideanDistance) {
        this.m_EuclideanDistance = euclideanDistance;
    }

    public void setNodeWidthNormalization(boolean bl) {
        this.m_NormalizeNodeWidth = bl;
    }

    protected int widestDim(double[][] dArray, double[][] dArray2) {
        int n = this.m_Instances.classIndex();
        double d = 0.0;
        int n2 = -1;
        if (this.m_NormalizeNodeWidth) {
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = dArray[i][2] / dArray2[i][2];
                if (!(d2 > d) || i == n) continue;
                d = d2;
                n2 = i;
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i][2] > d) || i == n) continue;
                d = dArray[i][2];
                n2 = i;
            }
        }
        return n2;
    }
}

