/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;

public class CheckSource
implements OptionHandler,
RevisionHandler {
    protected Classifier m_Classifier = null;
    protected Classifier m_SourceCode = null;
    protected File m_Dataset = null;
    protected int m_ClassIndex = -1;

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe classifier (incl. options) that was used to generate\n\tthe source code.", "W", 1, "-W <classname and options>"));
        result.addElement(new Option("\tThe classname of the generated source code.", "S", 1, "-S <classname>"));
        result.addElement(new Option("\tThe training set with which the source code was generated.", "t", 1, "-t <file>"));
        result.addElement(new Option("\tThe class index of the training set. 'first' and 'last' are\n\tvalid indices.\n\t(default: last)", "c", 1, "-c <index>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String[] spec;
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() > 0) {
            spec = Utils.splitOptions(tmpStr);
            if (spec.length == 0) {
                throw new IllegalArgumentException("Invalid classifier specification string");
            }
        } else {
            throw new Exception("No classifier (classname + options) provided!");
        }
        String classname = spec[0];
        spec[0] = "";
        this.setClassifier((Classifier)Utils.forName(Classifier.class, classname, spec));
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() > 0) {
            spec = Utils.splitOptions(tmpStr);
            if (spec.length != 1) {
                throw new IllegalArgumentException("Invalid source code specification string");
            }
        } else {
            throw new Exception("No source code (classname) provided!");
        }
        classname = spec[0];
        spec[0] = "";
        this.setSourceCode((Classifier)Utils.forName(Classifier.class, classname, spec));
        tmpStr = Utils.getOption('t', options);
        if (tmpStr.length() == 0) {
            throw new Exception("No dataset provided!");
        }
        this.setDataset(new File(tmpStr));
        tmpStr = Utils.getOption('c', options);
        if (tmpStr.length() != 0) {
            if (tmpStr.equals("first")) {
                this.setClassIndex(0);
            } else if (tmpStr.equals("last")) {
                this.setClassIndex(-1);
            } else {
                this.setClassIndex(Integer.parseInt(tmpStr) - 1);
            }
        } else {
            this.setClassIndex(-1);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getClassifier() != null) {
            result.add("-W");
            result.add(this.getClassifier().getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.getClassifier())).getOptions()));
        }
        if (this.getSourceCode() != null) {
            result.add("-S");
            result.add(this.getSourceCode().getClass().getName());
        }
        if (this.getDataset() != null) {
            result.add("-t");
            result.add(this.m_Dataset.getAbsolutePath());
        }
        result.add("-c");
        if (this.getClassIndex() == -1) {
            result.add("last");
        } else if (this.getClassIndex() == 0) {
            result.add("first");
        } else {
            result.add("" + (this.getClassIndex() + 1));
        }
        return result.toArray(new String[result.size()]);
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public void setSourceCode(Classifier value) {
        this.m_SourceCode = value;
    }

    public Classifier getSourceCode() {
        return this.m_SourceCode;
    }

    public void setDataset(File value) {
        if (!value.exists()) {
            throw new IllegalArgumentException("Dataset '" + value.getAbsolutePath() + "' does not exist!");
        }
        this.m_Dataset = value;
    }

    public File getDataset() {
        return this.m_Dataset;
    }

    public void setClassIndex(int value) {
        this.m_ClassIndex = value;
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    public boolean execute() throws Exception {
        boolean result = true;
        if (this.getClassifier() == null) {
            throw new Exception("No classifier set!");
        }
        if (this.getSourceCode() == null) {
            throw new Exception("No source code set!");
        }
        if (this.getDataset() == null) {
            throw new Exception("No dataset set!");
        }
        if (!this.getDataset().exists()) {
            throw new Exception("Dataset '" + this.getDataset().getAbsolutePath() + "' does not exist!");
        }
        ConverterUtils.DataSource source = new ConverterUtils.DataSource(this.getDataset().getAbsolutePath());
        Instances data = source.getDataSet();
        if (this.getClassIndex() == -1) {
            data.setClassIndex(data.numAttributes() - 1);
        } else {
            data.setClassIndex(this.getClassIndex());
        }
        boolean numeric = data.classAttribute().isNumeric();
        Classifier cls = AbstractClassifier.makeCopy(this.getClassifier());
        cls.buildClassifier(data);
        Classifier code = this.getSourceCode();
        for (int i = 0; i < data.numInstances(); ++i) {
            boolean different;
            double predClassifier = cls.classifyInstance(data.instance(i));
            double predSource = code.classifyInstance(data.instance(i));
            if (Double.isNaN(predClassifier) && Double.isNaN(predSource)) {
                different = false;
            } else if (numeric) {
                different = !Utils.eq(predClassifier, predSource);
            } else {
                boolean bl = different = (int)predClassifier != (int)predSource;
            }
            if (!different) continue;
            result = false;
            if (numeric) {
                System.out.println(i + 1 + ". instance (Classifier/Source code): " + predClassifier + " != " + predSource);
                continue;
            }
            System.out.println(i + 1 + ". instance (Classifier/Source code): " + data.classAttribute().value((int)predClassifier) + " != " + data.classAttribute().value((int)predSource));
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) throws Exception {
        CheckSource check = new CheckSource();
        if (Utils.getFlag('h', args)) {
            StringBuffer text = new StringBuffer();
            text.append("\nHelp requested:\n\n");
            Enumeration enm = check.listOptions();
            while (enm.hasMoreElements()) {
                Option option = (Option)enm.nextElement();
                text.append(option.synopsis() + "\n");
                text.append(option.description() + "\n");
            }
            System.out.println("\n" + text + "\n");
        } else {
            check.setOptions(args);
            if (check.execute()) {
                System.out.println("Tests OK!");
            } else {
                System.out.println("Tests failed!");
            }
        }
    }
}

