/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Enumeration;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.UnassignedClassException;
import weka.core.UnassignedDatasetException;
import weka.core.Utils;

public abstract class AbstractInstance
implements Instance,
Serializable,
RevisionHandler {
    static final long serialVersionUID = 1482635194499365155L;
    protected Instances m_Dataset;
    protected double[] m_AttValues;
    protected double m_Weight;
    public static int s_numericAfterDecimalPoint = 6;

    public Attribute attribute(int index) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(index);
    }

    public Attribute attributeSparse(int indexOfIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(this.index(indexOfIndex));
    }

    public Attribute classAttribute() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classAttribute();
    }

    public int classIndex() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classIndex();
    }

    public boolean classIsMissing() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.isMissing(this.classIndex());
    }

    public double classValue() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.value(this.classIndex());
    }

    public Instances dataset() {
        return this.m_Dataset;
    }

    public void deleteAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("DenseInstance has access to a dataset!");
        }
        this.forceDeleteAttributeAt(position);
    }

    public Enumeration enumerateAttributes() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        return this.m_Dataset.enumerateAttributes();
    }

    public boolean equalHeaders(Instance inst) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        return this.m_Dataset.equalHeaders(inst.dataset());
    }

    public String equalHeadersMsg(Instance inst) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        return this.m_Dataset.equalHeadersMsg(inst.dataset());
    }

    public boolean hasMissingValue() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        for (int i = 0; i < this.numValues(); ++i) {
            if (this.index(i) == this.classIndex() || !this.isMissingSparse(i)) continue;
            return true;
        }
        return false;
    }

    public void insertAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("DenseInstance has accesss to a dataset!");
        }
        if (position < 0 || position > this.numAttributes()) {
            throw new IllegalArgumentException("Can't insert attribute: index out of range");
        }
        this.forceInsertAttributeAt(position);
    }

    public boolean isMissing(int attIndex) {
        return Utils.isMissingValue(this.value(attIndex));
    }

    public boolean isMissingSparse(int indexOfIndex) {
        return Utils.isMissingValue(this.valueSparse(indexOfIndex));
    }

    public boolean isMissing(Attribute att) {
        return this.isMissing(att.index());
    }

    public int numClasses() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        return this.m_Dataset.numClasses();
    }

    public void setClassMissing() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setMissing(this.classIndex());
    }

    public void setClassValue(double value) {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(this.classIndex(), value);
    }

    public final void setClassValue(String value) {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(this.classIndex(), value);
    }

    public final void setDataset(Instances instances) {
        this.m_Dataset = instances;
    }

    public final void setMissing(int attIndex) {
        this.setValue(attIndex, Utils.missingValue());
    }

    public final void setMissing(Attribute att) {
        this.setMissing(att.index());
    }

    public final void setValue(int attIndex, String value) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        if (!this.attribute(attIndex).isNominal() && !this.attribute(attIndex).isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int valIndex = this.attribute(attIndex).indexOfValue(value);
        if (valIndex == -1) {
            if (this.attribute(attIndex).isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            this.attribute(attIndex).forceAddValue(value);
            valIndex = this.attribute(attIndex).indexOfValue(value);
        }
        this.setValue(attIndex, (double)valIndex);
    }

    public final void setValue(Attribute att, double value) {
        this.setValue(att.index(), value);
    }

    public final void setValue(Attribute att, String value) {
        if (!att.isNominal() && !att.isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int valIndex = att.indexOfValue(value);
        if (valIndex == -1) {
            if (att.isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            att.forceAddValue(value);
            valIndex = att.indexOfValue(value);
        }
        this.setValue(att.index(), (double)valIndex);
    }

    public final void setWeight(double weight) {
        this.m_Weight = weight;
    }

    public final Instances relationalValue(int attIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        return this.relationalValue(this.m_Dataset.attribute(attIndex));
    }

    public final Instances relationalValue(Attribute att) {
        int attIndex = att.index();
        if (att.isRelationValued()) {
            if (this.isMissing(attIndex)) {
                return null;
            }
            return att.relation((int)this.value(attIndex));
        }
        throw new IllegalArgumentException("Attribute isn't relation-valued!");
    }

    public final String stringValue(int attIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("DenseInstance doesn't have access to a dataset!");
        }
        return this.stringValue(this.m_Dataset.attribute(attIndex));
    }

    public final String stringValue(Attribute att) {
        int attIndex = att.index();
        if (this.isMissing(attIndex)) {
            return "?";
        }
        switch (att.type()) {
            case 1: 
            case 2: {
                return att.value((int)this.value(attIndex));
            }
            case 3: {
                return att.formatDate(this.value(attIndex));
            }
            case 4: {
                return att.relation((int)this.value(attIndex)).stringWithoutHeader();
            }
        }
        throw new IllegalArgumentException("Attribute isn't nominal, string or date!");
    }

    public final String toStringMaxDecimalDigits(int afterDecimalPoint) {
        StringBuffer text = new StringBuffer(this.toStringNoWeight(afterDecimalPoint));
        if (this.m_Weight != 1.0) {
            text.append(",{" + Utils.doubleToString(this.m_Weight, afterDecimalPoint) + "}");
        }
        return text.toString();
    }

    public String toString() {
        return this.toStringMaxDecimalDigits(s_numericAfterDecimalPoint);
    }

    public final String toString(int attIndex) {
        return this.toString(attIndex, s_numericAfterDecimalPoint);
    }

    public final String toString(int attIndex, int afterDecimalPoint) {
        StringBuffer text = new StringBuffer();
        if (this.isMissing(attIndex)) {
            text.append("?");
        } else if (this.m_Dataset == null) {
            text.append(Utils.doubleToString(this.value(attIndex), afterDecimalPoint));
        } else {
            switch (this.m_Dataset.attribute(attIndex).type()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    text.append(Utils.quote(this.stringValue(attIndex)));
                    break;
                }
                case 0: {
                    text.append(Utils.doubleToString(this.value(attIndex), afterDecimalPoint));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown attribute type");
                }
            }
        }
        return text.toString();
    }

    public final String toString(Attribute att) {
        return this.toString(att.index());
    }

    public final String toString(Attribute att, int afterDecimalPoint) {
        return this.toString(att.index(), afterDecimalPoint);
    }

    public double value(Attribute att) {
        return this.value(att.index());
    }

    public double valueSparse(int indexOfIndex) {
        return this.m_AttValues[indexOfIndex];
    }

    public final double weight() {
        return this.m_Weight;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9134 $");
    }

    protected abstract void forceDeleteAttributeAt(int var1);

    protected abstract void forceInsertAttributeAt(int var1);
}

