/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.converters.CSVLoader;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.core.neighboursearch.TreePerformanceStats;
import weka.core.neighboursearch.covertrees.Stack;

public class CoverTree
extends NearestNeighbourSearch
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 7617412821497807586L;
    protected EuclideanDistance m_EuclideanDistance;
    protected CoverTreeNode m_Root;
    protected double[] m_DistanceList;
    protected int m_NumNodes;
    protected int m_NumLeaves;
    protected int m_MaxDepth;
    protected TreePerformanceStats m_TreeStats;
    protected double m_Base;
    protected double il2;

    public CoverTree() {
        if (this.m_DistanceFunction instanceof EuclideanDistance) {
            this.m_EuclideanDistance = (EuclideanDistance)this.m_DistanceFunction;
        } else {
            this.m_EuclideanDistance = new EuclideanDistance();
            this.m_DistanceFunction = this.m_EuclideanDistance;
        }
        this.m_TreeStats = null;
        this.m_Base = 1.3;
        this.il2 = 1.0 / Math.log(this.m_Base);
        if (this.getMeasurePerformance()) {
            this.m_TreeStats = new TreePerformanceStats();
            this.m_Stats = this.m_TreeStats;
        }
    }

    @Override
    public String globalInfo() {
        return "Class implementing the CoverTree datastructure.\nThe class is very much a translation of the c source code made available by the authors.\n\nFor more information and original source code see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Alina Beygelzimer and Sham Kakade and John Langford");
        result.setValue(TechnicalInformation.Field.TITLE, "Cover trees for nearest neighbor");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "ICML'06: Proceedings of the 23rd international conference on Machine learning");
        result.setValue(TechnicalInformation.Field.PAGES, "97-104");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        result.setValue(TechnicalInformation.Field.ADDRESS, "New York, NY, USA");
        result.setValue(TechnicalInformation.Field.LOCATION, "Pittsburgh, Pennsylvania");
        result.setValue(TechnicalInformation.Field.HTTP, "http://hunch.net/~jl/projects/cover_tree/cover_tree.html");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSet base of the expansion constant\n\t(default = 1.3).", "B", 1, "-B <value>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String optionString = Utils.getOption('B', options);
        if (optionString.length() != 0) {
            this.setBase(Double.parseDouble(optionString));
        } else {
            this.setBase(1.3);
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-B");
        result.add("" + this.getBase());
        return result.toArray(new String[result.size()]);
    }

    protected double dist_of_scale(int s) {
        return Math.pow(this.m_Base, s);
    }

    protected int get_scale(double d) {
        return (int)Math.ceil(this.il2 * Math.log(d));
    }

    protected CoverTreeNode new_node(Integer idx) {
        CoverTreeNode new_node = new CoverTreeNode();
        new_node.idx = idx;
        return new_node;
    }

    protected CoverTreeNode new_leaf(Integer idx) {
        CoverTreeNode new_leaf = new CoverTreeNode(idx, 0.0, 0.0, null, 0, 100);
        return new_leaf;
    }

    protected double max_set(Stack<DistanceNode> v) {
        double max = 0.0;
        for (int i = 0; i < v.length; ++i) {
            DistanceNode n = v.element(i);
            if (!(max < (double)n.dist.element(n.dist.length - 1).floatValue())) continue;
            max = n.dist.element(n.dist.length - 1).floatValue();
        }
        return max;
    }

    protected void split(Stack<DistanceNode> point_set, Stack<DistanceNode> far_set, int max_scale) {
        int new_index = 0;
        double fmax = this.dist_of_scale(max_scale);
        for (int i = 0; i < point_set.length; ++i) {
            DistanceNode n = point_set.element(i);
            if (n.dist.element(n.dist.length - 1) <= fmax) {
                point_set.set(new_index++, point_set.element(i));
                continue;
            }
            far_set.push(point_set.element(i));
        }
        LinkedList<DistanceNode> l = new LinkedList<DistanceNode>();
        for (int i = 0; i < new_index; ++i) {
            l.add(point_set.element(i));
        }
        point_set.clear();
        point_set.addAll(l);
    }

    protected void dist_split(Stack<DistanceNode> point_set, Stack<DistanceNode> new_point_set, DistanceNode new_point, int max_scale) {
        int new_index = 0;
        double fmax = this.dist_of_scale(max_scale);
        for (int i = 0; i < point_set.length; ++i) {
            double new_d = Math.sqrt(this.m_DistanceFunction.distance(new_point.q(), point_set.element(i).q(), fmax * fmax));
            if (new_d <= fmax) {
                point_set.element((int)i).dist.push(new_d);
                new_point_set.push(point_set.element(i));
                continue;
            }
            point_set.set(new_index++, point_set.element(i));
        }
        LinkedList<DistanceNode> l = new LinkedList<DistanceNode>();
        for (int i = 0; i < new_index; ++i) {
            l.add(point_set.element(i));
        }
        point_set.clear();
        point_set.addAll(l);
    }

    protected CoverTreeNode batch_insert(Integer p, int max_scale, int top_scale, Stack<DistanceNode> point_set, Stack<DistanceNode> consumed_set) {
        if (point_set.length == 0) {
            CoverTreeNode leaf = this.new_leaf(p);
            leaf.nodeid = this.m_NumNodes;
            ++this.m_NumNodes;
            ++this.m_NumLeaves;
            return leaf;
        }
        double max_dist = this.max_set(point_set);
        int next_scale = Math.min(max_scale - 1, this.get_scale(max_dist));
        if (next_scale == Integer.MIN_VALUE) {
            Stack<CoverTreeNode> children = new Stack<CoverTreeNode>();
            CoverTreeNode leaf = this.new_leaf(p);
            leaf.nodeid = this.m_NumNodes;
            children.push(leaf);
            ++this.m_NumLeaves;
            ++this.m_NumNodes;
            while (point_set.length > 0) {
                DistanceNode tmpnode = point_set.pop();
                leaf = this.new_leaf(tmpnode.idx);
                leaf.nodeid = this.m_NumNodes;
                children.push(leaf);
                ++this.m_NumLeaves;
                ++this.m_NumNodes;
                consumed_set.push(tmpnode);
            }
            CoverTreeNode n = this.new_node(p);
            n.nodeid = this.m_NumNodes;
            ++this.m_NumNodes;
            n.scale = 100;
            n.max_dist = 0.0;
            n.num_children = children.length;
            n.children = children;
            return n;
        }
        Stack<DistanceNode> far = new Stack<DistanceNode>();
        this.split(point_set, far, max_scale);
        CoverTreeNode child = this.batch_insert(p, next_scale, top_scale, point_set, consumed_set);
        if (point_set.length == 0) {
            point_set.replaceAllBy(far);
            return child;
        }
        CoverTreeNode n = this.new_node(p);
        n.nodeid = this.m_NumNodes;
        ++this.m_NumNodes;
        Stack<CoverTreeNode> children = new Stack<CoverTreeNode>();
        children.push(child);
        while (point_set.length != 0) {
            int i;
            Stack<DistanceNode> new_point_set = new Stack<DistanceNode>();
            Stack<DistanceNode> new_consumed_set = new Stack<DistanceNode>();
            DistanceNode tmpnode = point_set.pop();
            double new_dist = tmpnode.dist.last();
            consumed_set.push(tmpnode);
            this.dist_split(point_set, new_point_set, tmpnode, max_scale);
            this.dist_split(far, new_point_set, tmpnode, max_scale);
            CoverTreeNode new_child = this.batch_insert(tmpnode.idx, next_scale, top_scale, new_point_set, new_consumed_set);
            new_child.parent_dist = new_dist;
            children.push(new_child);
            double fmax = this.dist_of_scale(max_scale);
            tmpnode = null;
            for (i = 0; i < new_point_set.length; ++i) {
                tmpnode = new_point_set.element(i);
                tmpnode.dist.pop();
                if (tmpnode.dist.last() <= fmax) {
                    point_set.push(tmpnode);
                    continue;
                }
                far.push(tmpnode);
            }
            tmpnode = null;
            for (i = 0; i < new_consumed_set.length; ++i) {
                tmpnode = new_consumed_set.element(i);
                tmpnode.dist.pop();
                consumed_set.push(tmpnode);
            }
        }
        point_set.replaceAllBy(far);
        n.scale = top_scale - max_scale;
        n.max_dist = this.max_set(consumed_set);
        n.num_children = children.length;
        n.children = children;
        return n;
    }

    protected void buildCoverTree(Instances insts) throws Exception {
        if (insts.numInstances() == 0) {
            throw new Exception("CoverTree: Empty set of instances. Cannot build tree.");
        }
        this.checkMissing(insts);
        if (this.m_EuclideanDistance == null) {
            this.m_EuclideanDistance = new EuclideanDistance(insts);
            this.m_DistanceFunction = this.m_EuclideanDistance;
        } else {
            this.m_EuclideanDistance.setInstances(insts);
        }
        Stack<DistanceNode> point_set = new Stack<DistanceNode>();
        Stack<DistanceNode> consumed_set = new Stack<DistanceNode>();
        Instance point_p = insts.instance(0);
        int p_idx = 0;
        double max_dist = -1.0;
        double dist = 0.0;
        Instance max_q = point_p;
        for (int i = 1; i < insts.numInstances(); ++i) {
            DistanceNode temp = new DistanceNode();
            temp.dist = new Stack();
            dist = Math.sqrt(this.m_DistanceFunction.distance(point_p, insts.instance(i), Double.POSITIVE_INFINITY));
            if (dist > max_dist) {
                max_dist = dist;
                max_q = insts.instance(i);
            }
            temp.dist.push(dist);
            temp.idx = i;
            point_set.push(temp);
        }
        max_dist = this.max_set(point_set);
        this.m_Root = this.batch_insert(p_idx, this.get_scale(max_dist), this.get_scale(max_dist), point_set, consumed_set);
    }

    protected void setter(MyHeap heap, double upper_bound, int k) throws Exception {
        if (heap.size() > 0) {
            heap.m_heap[0].index = 0;
        }
        while (heap.size() < k) {
            heap.put(upper_bound);
        }
    }

    protected void update(MyHeap upper_bound, double new_bound) throws Exception {
        upper_bound.putBySubstitute(new_bound);
    }

    protected Stack<d_node> getCoverSet(int idx, Stack<Stack<d_node>> cover_sets) {
        if (cover_sets.length <= idx) {
            for (int i = cover_sets.length - 1; i < idx; ++i) {
                Stack new_cover_set = new Stack();
                cover_sets.push(new_cover_set);
            }
        }
        return cover_sets.element(idx);
    }

    protected void copy_zero_set(CoverTreeNode query_chi, MyHeap new_upper_k, Stack<d_node> zero_set, Stack<d_node> new_zero_set) throws Exception {
        new_zero_set.clear();
        for (int i = 0; i < zero_set.length; ++i) {
            d_node ele = zero_set.element(i);
            double upper_dist = new_upper_k.peek().distance + query_chi.max_dist;
            if (!this.shell(ele.dist, query_chi.parent_dist, upper_dist)) continue;
            double d = Math.sqrt(this.m_DistanceFunction.distance(query_chi.p(), ele.n.p(), upper_dist * upper_dist));
            if (this.m_TreeStats != null) {
                this.m_TreeStats.incrPointCount();
            }
            if (!(d <= upper_dist)) continue;
            if (d < new_upper_k.peek().distance) {
                this.update(new_upper_k, d);
            }
            d_node temp = new d_node(d, ele.n);
            new_zero_set.push(temp);
            if (this.m_TreeStats == null) continue;
            this.m_TreeStats.incrLeafCount();
        }
    }

    protected void copy_cover_sets(CoverTreeNode query_chi, MyHeap new_upper_k, Stack<Stack<d_node>> cover_sets, Stack<Stack<d_node>> new_cover_sets, int current_scale, int max_scale) throws Exception {
        new_cover_sets.clear();
        while (current_scale <= max_scale) {
            Stack<d_node> cover_set_currentscale = this.getCoverSet(current_scale, cover_sets);
            for (int i = 0; i < cover_set_currentscale.length; ++i) {
                d_node ele = cover_set_currentscale.element(i);
                double upper_dist = new_upper_k.peek().distance + query_chi.max_dist + ele.n.max_dist;
                if (!this.shell(ele.dist, query_chi.parent_dist, upper_dist)) continue;
                double d = Math.sqrt(this.m_DistanceFunction.distance(query_chi.p(), ele.n.p(), upper_dist * upper_dist));
                if (this.m_TreeStats != null) {
                    this.m_TreeStats.incrPointCount();
                }
                if (!(d <= upper_dist)) continue;
                if (d < new_upper_k.peek().distance) {
                    this.update(new_upper_k, d);
                }
                d_node temp = new d_node(d, ele.n);
                new_cover_sets.element(current_scale).push(temp);
                if (this.m_TreeStats == null) continue;
                this.m_TreeStats.incrIntNodeCount();
            }
            ++current_scale;
        }
    }

    void print_cover_sets(Stack<Stack<d_node>> cover_sets, Stack<d_node> zero_set, int current_scale, int max_scale) {
        CoverTreeNode n;
        d_node ele;
        int i;
        CoverTree.println("cover set = ");
        while (current_scale <= max_scale) {
            CoverTree.println("" + current_scale);
            for (i = 0; i < cover_sets.element((int)current_scale).length; ++i) {
                ele = cover_sets.element(current_scale).element(i);
                n = ele.n;
                CoverTree.println(n.p());
            }
            ++current_scale;
        }
        CoverTree.println("infinity");
        for (i = 0; i < zero_set.length; ++i) {
            ele = zero_set.element(i);
            n = ele.n;
            CoverTree.println(n.p());
        }
    }

    protected void SWAP(int a, int b, Stack<d_node> cover_set) {
        d_node tmp = cover_set.element(a);
        cover_set.set(a, cover_set.element(b));
        cover_set.set(b, tmp);
    }

    protected double compare(int p1, int p2, Stack<d_node> cover_set) {
        return cover_set.element((int)p1).dist - cover_set.element((int)p2).dist;
    }

    protected void halfsort(Stack<d_node> cover_set) {
        int hi;
        if (cover_set.length <= 1) {
            return;
        }
        int start = 0;
        int right = hi = cover_set.length - 1;
        while (right > start) {
            int mid = start + (hi - start >> 1);
            boolean jumpover = false;
            if (this.compare(mid, start, cover_set) < 0.0) {
                this.SWAP(mid, start, cover_set);
            }
            if (this.compare(hi, mid, cover_set) < 0.0) {
                this.SWAP(mid, hi, cover_set);
            } else {
                jumpover = true;
            }
            if (!jumpover && this.compare(mid, start, cover_set) < 0.0) {
                this.SWAP(mid, start, cover_set);
            }
            int left = start + 1;
            right = hi - 1;
            while (true) {
                if (this.compare(left, mid, cover_set) < 0.0) {
                    ++left;
                    continue;
                }
                while (this.compare(mid, right, cover_set) < 0.0) {
                    --right;
                }
                if (left < right) {
                    this.SWAP(left, right, cover_set);
                    if (mid == left) {
                        mid = right;
                    } else if (mid == right) {
                        mid = left;
                    }
                    ++left;
                    --right;
                } else if (left == right) {
                    ++left;
                    break;
                }
                if (left > right) break;
            }
            hi = --right;
        }
    }

    protected boolean shell(double parent_query_dist, double child_parent_dist, double upper_bound) {
        return parent_query_dist - child_parent_dist <= upper_bound;
    }

    protected int descend(CoverTreeNode query, MyHeap upper_k, int current_scale, int max_scale, Stack<Stack<d_node>> cover_sets, Stack<d_node> zero_set) throws Exception {
        Stack<d_node> cover_set_currentscale = this.getCoverSet(current_scale, cover_sets);
        for (int i = 0; i < cover_set_currentscale.length; ++i) {
            d_node parent = cover_set_currentscale.element(i);
            CoverTreeNode par = parent.n;
            double upper_dist = upper_k.peek().distance + query.max_dist + query.max_dist;
            if (!(parent.dist <= upper_dist + par.max_dist)) continue;
            CoverTreeNode chi = par == this.m_Root && par.num_children == 0 ? par : (CoverTreeNode)par.children.element(0);
            if (parent.dist <= upper_dist + chi.max_dist) {
                if (chi.num_children > 0) {
                    if (max_scale < chi.scale) {
                        max_scale = chi.scale;
                    }
                    d_node temp = new d_node(parent.dist, chi);
                    this.getCoverSet(chi.scale, cover_sets).push(temp);
                    if (this.m_TreeStats != null) {
                        this.m_TreeStats.incrIntNodeCount();
                    }
                } else if (parent.dist <= upper_dist) {
                    d_node temp = new d_node(parent.dist, chi);
                    zero_set.push(temp);
                    if (this.m_TreeStats != null) {
                        this.m_TreeStats.incrLeafCount();
                    }
                }
            }
            for (int c = 1; c < par.num_children; ++c) {
                d_node temp;
                chi = (CoverTreeNode)par.children.element(c);
                double upper_chi = upper_k.peek().distance + chi.max_dist + query.max_dist + query.max_dist;
                if (!this.shell(parent.dist, chi.parent_dist, upper_chi)) continue;
                double d = Math.sqrt(this.m_DistanceFunction.distance(query.p(), chi.p(), upper_chi * upper_chi, this.m_TreeStats));
                if (this.m_TreeStats != null) {
                    this.m_TreeStats.incrPointCount();
                }
                if (!(d <= upper_chi)) continue;
                if (d < upper_k.peek().distance) {
                    this.update(upper_k, d);
                }
                if (chi.num_children > 0) {
                    if (max_scale < chi.scale) {
                        max_scale = chi.scale;
                    }
                    temp = new d_node(d, chi);
                    this.getCoverSet(chi.scale, cover_sets).push(temp);
                    if (this.m_TreeStats == null) continue;
                    this.m_TreeStats.incrIntNodeCount();
                    continue;
                }
                if (!(d <= upper_chi - chi.max_dist)) continue;
                temp = new d_node(d, chi);
                zero_set.push(temp);
                if (this.m_TreeStats == null) continue;
                this.m_TreeStats.incrLeafCount();
            }
        }
        return max_scale;
    }

    protected void brute_nearest(int k, CoverTreeNode query, Stack<d_node> zero_set, MyHeap upper_k, Stack<NearestNeighbourSearch.NeighborList> results) throws Exception {
        if (query.num_children > 0) {
            Stack<d_node> new_zero_set = new Stack<d_node>();
            CoverTreeNode query_chi = (CoverTreeNode)query.children.element(0);
            this.brute_nearest(k, query_chi, zero_set, upper_k, results);
            MyHeap new_upper_k = new MyHeap(k);
            for (int i = 1; i < ((CoverTreeNode)query).children.length; ++i) {
                query_chi = (CoverTreeNode)query.children.element(i);
                this.setter(new_upper_k, upper_k.peek().distance + query_chi.parent_dist, k);
                this.copy_zero_set(query_chi, new_upper_k, zero_set, new_zero_set);
                this.brute_nearest(k, query_chi, new_zero_set, new_upper_k, results);
            }
        } else {
            NearestNeighbourSearch.NeighborList temp = new NearestNeighbourSearch.NeighborList(this, k);
            for (int i = 0; i < zero_set.length; ++i) {
                d_node ele = zero_set.element(i);
                if (!(ele.dist <= upper_k.peek().distance)) continue;
                temp.insertSorted(ele.dist, ele.n.p());
            }
            results.push(temp);
        }
    }

    protected void internal_batch_nearest_neighbor(int k, CoverTreeNode query_node, Stack<Stack<d_node>> cover_sets, Stack<d_node> zero_set, int current_scale, int max_scale, MyHeap upper_k, Stack<NearestNeighbourSearch.NeighborList> results) throws Exception {
        if (current_scale > max_scale) {
            this.brute_nearest(k, query_node, zero_set, upper_k, results);
        } else if (query_node.scale <= current_scale && query_node.scale != 100) {
            Stack<d_node> new_zero_set = new Stack<d_node>();
            Stack<Stack<d_node>> new_cover_sets = new Stack<Stack<d_node>>();
            MyHeap new_upper_k = new MyHeap(k);
            for (int i = 1; i < query_node.num_children; ++i) {
                CoverTreeNode query_chi = (CoverTreeNode)query_node.children.element(i);
                this.setter(new_upper_k, upper_k.peek().distance + query_chi.parent_dist, k);
                this.copy_zero_set(query_chi, new_upper_k, zero_set, new_zero_set);
                this.copy_cover_sets(query_chi, new_upper_k, cover_sets, new_cover_sets, current_scale, max_scale);
                this.internal_batch_nearest_neighbor(k, query_chi, new_cover_sets, new_zero_set, current_scale, max_scale, new_upper_k, results);
            }
            new_cover_sets = null;
            new_zero_set = null;
            new_upper_k = null;
            this.internal_batch_nearest_neighbor(k, (CoverTreeNode)query_node.children.element(0), cover_sets, zero_set, current_scale, max_scale, upper_k, results);
        } else {
            Stack<d_node> cover_set_i = this.getCoverSet(current_scale, cover_sets);
            this.halfsort(cover_set_i);
            max_scale = this.descend(query_node, upper_k, current_scale, max_scale, cover_sets, zero_set);
            cover_set_i.clear();
            this.internal_batch_nearest_neighbor(k, query_node, cover_sets, zero_set, ++current_scale, max_scale, upper_k, results);
        }
    }

    protected void batch_nearest_neighbor(int k, CoverTreeNode tree_root, CoverTreeNode query_root, Stack<NearestNeighbourSearch.NeighborList> results) throws Exception {
        Stack<Stack<d_node>> cover_sets = new Stack<Stack<d_node>>(100);
        Stack<d_node> zero_set = new Stack<d_node>();
        MyHeap upper_k = new MyHeap(k);
        this.setter(upper_k, Double.POSITIVE_INFINITY, k);
        double treeroot_to_query_dist = Math.sqrt(this.m_DistanceFunction.distance(query_root.p(), tree_root.p(), Double.POSITIVE_INFINITY));
        this.update(upper_k, treeroot_to_query_dist);
        d_node temp = new d_node(treeroot_to_query_dist, tree_root);
        this.getCoverSet(0, cover_sets).push(temp);
        if (this.m_TreeStats != null) {
            this.m_TreeStats.incrPointCount();
            if (tree_root.num_children > 0) {
                this.m_TreeStats.incrIntNodeCount();
            } else {
                this.m_TreeStats.incrLeafCount();
            }
        }
        this.internal_batch_nearest_neighbor(k, query_root, cover_sets, zero_set, 0, 0, upper_k, results);
    }

    protected NearestNeighbourSearch.NeighborList findKNearest(Instance target, int k) throws Exception {
        double upper_bound;
        Stack<d_node> cover_set_current = new Stack<d_node>();
        Stack<d_node> zero_set = new Stack<d_node>();
        MyHeap upper_k = new MyHeap(k);
        double d = Math.sqrt(this.m_DistanceFunction.distance(this.m_Root.p(), target, Double.POSITIVE_INFINITY, this.m_TreeStats));
        cover_set_current.push(new d_node(d, this.m_Root));
        this.setter(upper_k, Double.POSITIVE_INFINITY, k);
        this.update(upper_k, d);
        if (this.m_TreeStats != null) {
            if (this.m_Root.num_children > 0) {
                this.m_TreeStats.incrIntNodeCount();
            } else {
                this.m_TreeStats.incrLeafCount();
            }
            this.m_TreeStats.incrPointCount();
        }
        if (this.m_Root.num_children == 0) {
            NearestNeighbourSearch.NeighborList list = new NearestNeighbourSearch.NeighborList(this, k);
            list.insertSorted(d, this.m_Root.p());
            return list;
        }
        while (cover_set_current.length > 0) {
            Stack<d_node> cover_set_next = new Stack<d_node>();
            for (int i = 0; i < cover_set_current.length; ++i) {
                d_node par = (d_node)cover_set_current.element(i);
                CoverTreeNode parent = par.n;
                for (int c = 0; c < parent.num_children; ++c) {
                    CoverTreeNode child = (CoverTreeNode)parent.children.element(c);
                    upper_bound = upper_k.peek().distance;
                    if (c == 0) {
                        d = par.dist;
                    } else {
                        d = upper_bound + child.max_dist;
                        d = Math.sqrt(this.m_DistanceFunction.distance(child.p(), target, d * d, this.m_TreeStats));
                        if (this.m_TreeStats != null) {
                            this.m_TreeStats.incrPointCount();
                        }
                    }
                    if (!(d <= upper_bound + child.max_dist)) continue;
                    if (c > 0 && d < upper_bound) {
                        this.update(upper_k, d);
                    }
                    if (child.num_children > 0) {
                        cover_set_next.push(new d_node(d, child));
                        if (this.m_TreeStats == null) continue;
                        this.m_TreeStats.incrIntNodeCount();
                        continue;
                    }
                    if (!(d <= upper_bound)) continue;
                    zero_set.push(new d_node(d, child));
                    if (this.m_TreeStats == null) continue;
                    this.m_TreeStats.incrLeafCount();
                }
            }
            cover_set_current = cover_set_next;
        }
        NearestNeighbourSearch.NeighborList list = new NearestNeighbourSearch.NeighborList(this, k);
        upper_bound = upper_k.peek().distance;
        for (int i = 0; i < zero_set.length; ++i) {
            d_node tmpnode = (d_node)zero_set.element(i);
            if (!(tmpnode.dist <= upper_bound)) continue;
            list.insertSorted(tmpnode.dist, tmpnode.n.p());
        }
        if (list.currentLength() <= 0) {
            throw new Exception("Error: No neighbour found. This cannot happen");
        }
        return list;
    }

    @Override
    public Instances kNearestNeighbours(Instance target, int k) throws Exception {
        if (this.m_Stats != null) {
            this.m_Stats.searchStart();
        }
        CoverTree querytree = new CoverTree();
        Instances insts = new Instances(this.m_Instances, 0);
        insts.add(target);
        querytree.setInstances(insts);
        Stack<NearestNeighbourSearch.NeighborList> result = new Stack<NearestNeighbourSearch.NeighborList>();
        this.batch_nearest_neighbor(k, this.m_Root, querytree.m_Root, result);
        if (this.m_Stats != null) {
            this.m_Stats.searchFinish();
        }
        insts = new Instances(this.m_Instances, 0);
        NearestNeighbourSearch.NeighborNode node = result.element(0).getFirst();
        this.m_DistanceList = new double[result.element(0).currentLength()];
        int i = 0;
        while (node != null) {
            insts.add(node.m_Instance);
            this.m_DistanceList[i] = node.m_Distance;
            ++i;
            node = node.m_Next;
        }
        return insts;
    }

    @Override
    public Instance nearestNeighbour(Instance target) throws Exception {
        return this.kNearestNeighbours(target, 1).instance(0);
    }

    @Override
    public double[] getDistances() throws Exception {
        if (this.m_Instances == null || this.m_DistanceList == null) {
            throw new Exception("The tree has not been supplied with a set of instances or getDistances() has been called before calling kNearestNeighbours().");
        }
        return this.m_DistanceList;
    }

    protected void checkMissing(Instances instances) throws Exception {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance ins = instances.instance(i);
            for (int j = 0; j < ins.numValues(); ++j) {
                if (ins.index(j) == ins.classIndex() || !ins.isMissingSparse(j)) continue;
                throw new Exception("ERROR: KDTree can not deal with missing values. Please run ReplaceMissingValues filter on the dataset before passing it on to the KDTree.");
            }
        }
    }

    @Override
    public void setInstances(Instances instances) throws Exception {
        super.setInstances(instances);
        this.buildCoverTree(instances);
    }

    @Override
    public void update(Instance ins) throws Exception {
        throw new Exception("BottomUpConstruction method does not allow addition of new Instances.");
    }

    @Override
    public void addInstanceInfo(Instance ins) {
        if (this.m_Instances != null) {
            try {
                this.m_DistanceFunction.update(ins);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (this.m_Instances == null) {
            throw new IllegalStateException("No instances supplied yet. Cannot update withoutsupplying a set of instances first.");
        }
    }

    @Override
    public void setDistanceFunction(DistanceFunction df) throws Exception {
        if (!(df instanceof EuclideanDistance)) {
            throw new Exception("CoverTree currently only works with EuclideanDistanceFunction.");
        }
        this.m_EuclideanDistance = (EuclideanDistance)df;
        this.m_DistanceFunction = this.m_EuclideanDistance;
    }

    public String baseTipText() {
        return "The base for the expansion constant.";
    }

    public double getBase() {
        return this.m_Base;
    }

    public void setBase(double b) {
        this.m_Base = b;
    }

    public double measureTreeSize() {
        return this.m_NumNodes;
    }

    public double measureNumLeaves() {
        return this.m_NumLeaves;
    }

    public double measureMaxDepth() {
        return this.m_MaxDepth;
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        newVector.addElement("measureTreeSize");
        newVector.addElement("measureNumLeaves");
        newVector.addElement("measureMaxDepth");
        if (this.m_Stats != null) {
            Enumeration e = this.m_Stats.enumerateMeasures();
            while (e.hasMoreElements()) {
                newVector.addElement((String)e.nextElement());
            }
        }
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureMaxDepth") == 0) {
            return this.measureMaxDepth();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        if (this.m_Stats != null) {
            return this.m_Stats.getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (KDTree)");
    }

    protected static void print(String s) {
        System.out.print(s);
    }

    protected static void println(String s) {
        System.out.println(s);
    }

    protected static void print(Object o) {
        System.out.print(o);
    }

    protected static void println(Object o) {
        System.out.println(o);
    }

    protected static void print_space(int s) {
        for (int i = 0; i < s; ++i) {
            System.out.print(" ");
        }
    }

    protected static void print(int depth, CoverTreeNode top_node) {
        CoverTree.print_space(depth);
        CoverTree.println(top_node.p());
        if (top_node.num_children > 0) {
            CoverTree.print_space(depth);
            CoverTree.print("scale = " + top_node.scale + "\n");
            CoverTree.print_space(depth);
            CoverTree.print("num children = " + top_node.num_children + "\n");
            System.out.flush();
            for (int i = 0; i < top_node.num_children; ++i) {
                CoverTree.print(depth + 1, (CoverTreeNode)top_node.children.element(i));
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: CoverTree <ARFF file>");
            System.exit(-1);
        }
        try {
            Instances insts = null;
            if (args[0].endsWith(".csv")) {
                CSVLoader csv = new CSVLoader();
                csv.setFile(new File(args[0]));
                insts = csv.getDataSet();
            } else {
                insts = new Instances(new BufferedReader(new FileReader(args[0])));
            }
            CoverTree tree = new CoverTree();
            tree.setInstances(insts);
            CoverTree.print("Created data tree:\n");
            CoverTree.print(0, tree.m_Root);
            CoverTree.println("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class d_node
    implements RevisionHandler {
        double dist;
        CoverTreeNode n;

        public d_node(double d, CoverTreeNode node) {
            this.dist = d;
            this.n = node;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5953 $");
        }
    }

    protected class MyHeapElement
    implements RevisionHandler {
        public double distance;
        int index = 0;

        public MyHeapElement(double d) {
            this.distance = d;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5953 $");
        }
    }

    protected class MyHeap
    implements RevisionHandler {
        MyHeapElement[] m_heap = null;
        MyHeapElement[] m_KthNearest = null;
        int m_KthNearestSize = 0;
        int initSize = 10;

        public MyHeap(int maxSize) {
            if (maxSize % 2 == 0) {
                ++maxSize;
            }
            this.m_heap = new MyHeapElement[maxSize + 1];
            this.m_heap[0] = new MyHeapElement(-1.0);
        }

        public int size() {
            return this.m_heap[0].index;
        }

        public MyHeapElement peek() {
            return this.m_heap[1];
        }

        public MyHeapElement get() throws Exception {
            if (this.m_heap[0].index == 0) {
                throw new Exception("No elements present in the heap");
            }
            MyHeapElement r = this.m_heap[1];
            this.m_heap[1] = this.m_heap[this.m_heap[0].index];
            --this.m_heap[0].index;
            this.downheap();
            return r;
        }

        public void put(double d) throws Exception {
            if (this.m_heap[0].index + 1 > this.m_heap.length - 1) {
                throw new Exception("the number of elements cannot exceed the initially set maximum limit");
            }
            ++this.m_heap[0].index;
            this.m_heap[this.m_heap[0].index] = new MyHeapElement(d);
            this.upheap();
        }

        public void putBySubstitute(double d) throws Exception {
            MyHeapElement head = this.get();
            this.put(d);
            if (head.distance == this.m_heap[1].distance) {
                this.putKthNearest(head.distance);
            } else if (head.distance > this.m_heap[1].distance) {
                this.m_KthNearest = null;
                this.m_KthNearestSize = 0;
                this.initSize = 10;
            } else if (head.distance < this.m_heap[1].distance) {
                throw new Exception("The substituted element is greater than the head element. put() should have been called in place of putBySubstitute()");
            }
        }

        public int noOfKthNearest() {
            return this.m_KthNearestSize;
        }

        public void putKthNearest(double d) {
            if (this.m_KthNearest == null) {
                this.m_KthNearest = new MyHeapElement[this.initSize];
            }
            if (this.m_KthNearestSize >= this.m_KthNearest.length) {
                this.initSize += this.initSize;
                MyHeapElement[] temp = new MyHeapElement[this.initSize];
                System.arraycopy(this.m_KthNearest, 0, temp, 0, this.m_KthNearest.length);
                this.m_KthNearest = temp;
            }
            this.m_KthNearest[this.m_KthNearestSize++] = new MyHeapElement(d);
        }

        public MyHeapElement getKthNearest() {
            if (this.m_KthNearestSize == 0) {
                return null;
            }
            --this.m_KthNearestSize;
            return this.m_KthNearest[this.m_KthNearestSize];
        }

        protected void upheap() {
            int i = this.m_heap[0].index;
            while (i > 1 && this.m_heap[i].distance > this.m_heap[i / 2].distance) {
                MyHeapElement temp = this.m_heap[i];
                this.m_heap[i] = this.m_heap[i / 2];
                this.m_heap[i /= 2] = temp;
            }
        }

        protected void downheap() {
            int i = 1;
            while (2 * i <= this.m_heap[0].index && this.m_heap[i].distance < this.m_heap[2 * i].distance || 2 * i + 1 <= this.m_heap[0].index && this.m_heap[i].distance < this.m_heap[2 * i + 1].distance) {
                MyHeapElement temp;
                if (2 * i + 1 <= this.m_heap[0].index) {
                    if (this.m_heap[2 * i].distance > this.m_heap[2 * i + 1].distance) {
                        temp = this.m_heap[i];
                        this.m_heap[i] = this.m_heap[2 * i];
                        i = 2 * i;
                        this.m_heap[i] = temp;
                        continue;
                    }
                    temp = this.m_heap[i];
                    this.m_heap[i] = this.m_heap[2 * i + 1];
                    i = 2 * i + 1;
                    this.m_heap[i] = temp;
                    continue;
                }
                temp = this.m_heap[i];
                this.m_heap[i] = this.m_heap[2 * i];
                i = 2 * i;
                this.m_heap[i] = temp;
            }
        }

        public int totalSize() {
            return this.size() + this.noOfKthNearest();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5953 $");
        }
    }

    private class DistanceNode
    implements RevisionHandler {
        Stack<Double> dist;
        Integer idx;

        private DistanceNode() {
        }

        public Instance q() {
            return CoverTree.this.m_Instances.instance(this.idx);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5953 $");
        }
    }

    public class CoverTreeNode
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 1808760031169036512L;
        private int nodeid;
        private Integer idx;
        private double max_dist;
        private double parent_dist;
        private Stack<CoverTreeNode> children;
        private int num_children;
        private int scale;

        public CoverTreeNode() {
        }

        public CoverTreeNode(Integer i, double md, double pd, Stack<CoverTreeNode> childs, int numchilds, int s) {
            this.idx = i;
            this.max_dist = md;
            this.parent_dist = pd;
            this.children = childs;
            this.num_children = numchilds;
            this.scale = s;
        }

        public Instance p() {
            return CoverTree.this.m_Instances.instance(this.idx);
        }

        public boolean isALeaf() {
            return this.num_children == 0;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5953 $");
        }
    }
}

