/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.KernelEvaluation;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.CheckScheme;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializationHelper;
import weka.core.TestInstances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class CheckKernel
extends CheckScheme {
    protected Kernel m_Kernel = new RBFKernel();

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tFull name of the kernel analysed.\n\teg: weka.classifiers.functions.supportVector.RBFKernel\n\t(default weka.classifiers.functions.supportVector.RBFKernel)", "W", 1, "-W"));
        if (this.m_Kernel != null && this.m_Kernel instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.m_Kernel.getClass().getName() + ":"));
            Enumeration enu = this.m_Kernel.listOptions();
            while (enu.hasMoreElements()) {
                result.addElement(enu.nextElement());
            }
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() == 0) {
            tmpStr = RBFKernel.class.getName();
        }
        this.setKernel((Kernel)this.forName("weka.classifiers.functions.supportVector", Kernel.class, tmpStr, Utils.partitionOptions(options)));
    }

    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.getKernel() != null) {
            result.add("-W");
            result.add(this.getKernel().getClass().getName());
        }
        if ((options = this.m_Kernel != null && this.m_Kernel instanceof OptionHandler ? this.m_Kernel.getOptions() : new String[]{}).length > 0) {
            result.add("--");
            for (i = 0; i < options.length; ++i) {
                result.add(options[i]);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void doTests() {
        if (this.getKernel() == null) {
            this.println("\n=== No kernel set ===");
            return;
        }
        this.println("\n=== Check on kernel: " + this.getKernel().getClass().getName() + " ===\n");
        this.m_ClasspathProblems = false;
        this.println("--> Checking for interfaces");
        this.canTakeOptions();
        boolean weightedInstancesHandler = this.weightedInstancesHandler()[0];
        boolean multiInstanceHandler = this.multiInstanceHandler()[0];
        this.println("--> Kernel tests");
        this.declaresSerialVersionUID();
        this.testsPerClassType(1, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(0, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(3, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(2, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(4, weightedInstancesHandler, multiInstanceHandler);
    }

    public void setKernel(Kernel value) {
        this.m_Kernel = value;
    }

    public Kernel getKernel() {
        return this.m_Kernel;
    }

    protected void testsPerClassType(int classType, boolean weighted, boolean multiInstance) {
        boolean PNom = this.canPredict(true, false, false, false, false, multiInstance, classType)[0];
        boolean PNum = this.canPredict(false, true, false, false, false, multiInstance, classType)[0];
        boolean PStr = this.canPredict(false, false, true, false, false, multiInstance, classType)[0];
        boolean PDat = this.canPredict(false, false, false, true, false, multiInstance, classType)[0];
        boolean PRel = !multiInstance ? this.canPredict(false, false, false, false, true, multiInstance, classType)[0] : false;
        if (PNom || PNum || PStr || PDat || PRel) {
            boolean handleMissingClass;
            if (weighted) {
                this.instanceWeights(PNom, PNum, PStr, PDat, PRel, multiInstance, classType);
            }
            if (classType == 1) {
                this.canHandleNClasses(PNom, PNum, PStr, PDat, PRel, multiInstance, 4);
            }
            if (!multiInstance) {
                this.canHandleClassAsNthAttribute(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, 0);
                this.canHandleClassAsNthAttribute(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, 1);
            }
            this.canHandleZeroTraining(PNom, PNum, PStr, PDat, PRel, multiInstance, classType);
            boolean handleMissingPredictors = this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, true, false, 20)[0];
            if (handleMissingPredictors) {
                this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, true, false, 100);
            }
            if (handleMissingClass = this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, false, true, 20)[0]) {
                this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, false, true, 100);
            }
            this.correctBuildInitialisation(PNom, PNum, PStr, PDat, PRel, multiInstance, classType);
            this.datasetIntegrity(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, handleMissingPredictors, handleMissingClass);
        }
    }

    protected boolean[] canTakeOptions() {
        boolean[] result = new boolean[2];
        this.print("options...");
        if (this.m_Kernel instanceof OptionHandler) {
            this.println("yes");
            if (this.m_Debug) {
                this.println("\n=== Full report ===");
                Enumeration enu = this.m_Kernel.listOptions();
                while (enu.hasMoreElements()) {
                    Option option = (Option)enu.nextElement();
                    this.print(option.synopsis() + "\n" + option.description() + "\n");
                }
                this.println("\n");
            }
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] weightedInstancesHandler() {
        boolean[] result = new boolean[2];
        this.print("weighted instances kernel...");
        if (this.m_Kernel instanceof WeightedInstancesHandler) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] multiInstanceHandler() {
        boolean[] result = new boolean[2];
        this.print("multi-instance kernel...");
        if (this.m_Kernel instanceof MultiInstanceCapabilitiesHandler) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] declaresSerialVersionUID() {
        boolean[] result = new boolean[2];
        this.print("serialVersionUID...");
        boolean bl = result[0] = !SerializationHelper.needsUID(this.m_Kernel.getClass());
        if (result[0]) {
            this.println("yes");
        } else {
            this.println("no");
        }
        return result;
    }

    protected boolean[] canPredict(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        this.print("basic predict");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        FastVector<String> accepts = new FastVector<String>();
        accepts.addElement("unary");
        accepts.addElement("binary");
        accepts.addElement("nominal");
        accepts.addElement("numeric");
        accepts.addElement("string");
        accepts.addElement("date");
        accepts.addElement("relational");
        accepts.addElement("multi-instance");
        accepts.addElement("not in classpath");
        int numTrain = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] canHandleNClasses(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int numClasses) {
        this.print("more than two class problems");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, 1);
        this.print("...");
        FastVector<String> accepts = new FastVector<String>();
        accepts.addElement("number");
        accepts.addElement("class");
        int numTrain = this.getNumInstances();
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, 1, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] canHandleClassAsNthAttribute(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, int classIndex) {
        if (classIndex == -1) {
            this.print("class attribute as last attribute");
        } else {
            this.print("class attribute as " + (classIndex + 1) + ". attribute");
        }
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        FastVector accepts = new FastVector();
        int numTrain = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, classIndex, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] canHandleZeroTraining(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        this.print("handle zero training instances");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        FastVector<String> accepts = new FastVector<String>();
        accepts.addElement("train");
        accepts.addElement("value");
        int numTrain = 0;
        int numClasses = 2;
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] correctBuildInitialisation(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        boolean[] result;
        block13: {
            result = new boolean[2];
            this.print("correct initialisation during buildKernel");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
            this.print("...");
            int numTrain = this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 0;
            boolean predictorMissing = false;
            boolean classMissing = false;
            Instances train1 = null;
            Instances train2 = null;
            Kernel kernel = null;
            KernelEvaluation evaluation1A = null;
            KernelEvaluation evaluation1B = null;
            KernelEvaluation evaluation2 = null;
            int stage = 0;
            try {
                train1 = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                train2 = this.makeTestDataset(84, numTrain, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() + 1 : 0, datePredictor ? this.getNumDate() + 1 : 0, relationalPredictor ? this.getNumRelational() + 1 : 0, numClasses, classType, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train1, missingLevel, predictorMissing, classMissing);
                    this.addMissing(train2, missingLevel, predictorMissing, classMissing);
                }
                kernel = Kernel.makeCopy(this.getKernel());
                evaluation1A = new KernelEvaluation();
                evaluation1B = new KernelEvaluation();
                evaluation2 = new KernelEvaluation();
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                stage = 0;
                evaluation1A.evaluate(kernel, train1);
                stage = 1;
                evaluation2.evaluate(kernel, train2);
                stage = 2;
                evaluation1B.evaluate(kernel, train1);
                stage = 3;
                if (!evaluation1A.equals(evaluation1B)) {
                    if (this.m_Debug) {
                        this.println("\n=== Full report ===\n" + evaluation1A.toSummaryString("\nFirst buildKernel()") + "\n\n");
                        this.println(evaluation1B.toSummaryString("\nSecond buildKernel()") + "\n\n");
                    }
                    throw new Exception("Results differ between buildKernel calls");
                }
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block13;
                this.println("\n=== Full Report ===");
                this.print("Problem during building");
                switch (stage) {
                    case 0: {
                        this.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        this.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        this.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        this.print(", comparing results from builds of dataset 1");
                    }
                }
                this.println(": " + ex.getMessage() + "\n");
                this.println("here are the datasets:\n");
                this.println("=== Train1 Dataset ===\n" + train1.toString() + "\n");
                this.println("=== Train2 Dataset ===\n" + train2.toString() + "\n");
            }
        }
        return result;
    }

    protected boolean[] canHandleMissing(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, boolean predictorMissing, boolean classMissing, int missingLevel) {
        if (missingLevel == 100) {
            this.print("100% ");
        }
        this.print("missing");
        if (predictorMissing) {
            this.print(" predictor");
            if (classMissing) {
                this.print(" and");
            }
        }
        if (classMissing) {
            this.print(" class");
        }
        this.print(" values");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        FastVector<String> accepts = new FastVector<String>();
        accepts.addElement("missing");
        accepts.addElement("value");
        accepts.addElement("train");
        int numTrain = this.getNumInstances();
        int numClasses = 2;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] instanceWeights(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        boolean[] result;
        block11: {
            this.print("kernel uses instance weights");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
            this.print("...");
            int numTrain = 2 * this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 0;
            boolean predictorMissing = false;
            boolean classMissing = false;
            result = new boolean[2];
            Instances train = null;
            Kernel[] kernels = null;
            KernelEvaluation evaluationB = null;
            KernelEvaluation evaluationI = null;
            boolean evalFail = false;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing, classMissing);
                }
                kernels = Kernel.makeCopies(this.getKernel(), 2);
                evaluationB = new KernelEvaluation();
                evaluationI = new KernelEvaluation();
                evaluationB.evaluate(kernels[0], train);
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                for (int i = 0; i < train.numInstances(); ++i) {
                    train.instance(i).setWeight(0.0);
                }
                Random random = new Random(1L);
                for (int i = 0; i < train.numInstances() / 2; ++i) {
                    int inst = Math.abs(random.nextInt()) % train.numInstances();
                    int weight = Math.abs(random.nextInt()) % 10 + 1;
                    train.instance(inst).setWeight(weight);
                }
                evaluationI.evaluate(kernels[1], train);
                if (evaluationB.equals(evaluationI)) {
                    evalFail = true;
                    throw new Exception("evalFail");
                }
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block11;
                this.println("\n=== Full Report ===");
                if (evalFail) {
                    this.println("Results don't differ between non-weighted and weighted instance models.");
                    this.println("Here are the results:\n");
                    this.println(evaluationB.toSummaryString("\nboth methods\n"));
                } else {
                    this.print("Problem during building");
                    this.println(": " + ex.getMessage() + "\n");
                }
                this.println("Here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < train.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + train.instance(i).weight());
                }
            }
        }
        return result;
    }

    protected boolean[] datasetIntegrity(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, boolean predictorMissing, boolean classMissing) {
        boolean[] result;
        block5: {
            this.print("kernel doesn't alter original datasets");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
            this.print("...");
            int numTrain = this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 20;
            result = new boolean[2];
            Instances train = null;
            Kernel kernel = null;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing, classMissing);
                }
                kernel = Kernel.makeCopies(this.getKernel(), 1)[0];
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                Instances trainCopy = new Instances(train);
                kernel.buildKernel(trainCopy);
                this.compareDatasets(train, trainCopy);
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block5;
                this.println("\n=== Full Report ===");
                this.print("Problem during building");
                this.println(": " + ex.getMessage() + "\n");
                this.println("Here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
            }
        }
        return result;
    }

    protected boolean[] runBasicTest(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, int missingLevel, boolean predictorMissing, boolean classMissing, int numTrain, int numClasses, FastVector accepts) {
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, -1, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] runBasicTest(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, int classIndex, int missingLevel, boolean predictorMissing, boolean classMissing, int numTrain, int numClasses, FastVector accepts) {
        boolean[] result;
        block10: {
            result = new boolean[2];
            Instances train = null;
            Kernel kernel = null;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, classIndex, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing, classMissing);
                }
                kernel = Kernel.makeCopies(this.getKernel(), 1)[0];
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                kernel.buildKernel(train);
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                int i;
                boolean acceptable = false;
                String msg = ex.getMessage() == null ? "" : ex.getMessage().toLowerCase();
                if (msg.indexOf("not in classpath") > -1) {
                    this.m_ClasspathProblems = true;
                }
                for (i = 0; i < accepts.size(); ++i) {
                    if (msg.indexOf((String)accepts.elementAt(i)) < 0) continue;
                    acceptable = true;
                }
                this.println("no" + (acceptable ? " (OK error message)" : ""));
                result[1] = acceptable;
                if (!this.m_Debug) break block10;
                this.println("\n=== Full Report ===");
                this.print("Problem during building");
                this.println(": " + ex.getMessage() + "\n");
                if (acceptable) break block10;
                if (accepts.size() > 0) {
                    this.print("Error message doesn't mention ");
                    for (i = 0; i < accepts.size(); ++i) {
                        if (i != 0) {
                            this.print(" or ");
                        }
                        this.print('\"' + (String)accepts.elementAt(i) + '\"');
                    }
                }
                this.println("here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
            }
        }
        return result;
    }

    protected Instances makeTestDataset(int seed, int numInstances, int numNominal, int numNumeric, int numString, int numDate, int numRelational, int numClasses, int classType, boolean multiInstance) throws Exception {
        return this.makeTestDataset(seed, numInstances, numNominal, numNumeric, numString, numDate, numRelational, numClasses, classType, -1, multiInstance);
    }

    protected Instances makeTestDataset(int seed, int numInstances, int numNominal, int numNumeric, int numString, int numDate, int numRelational, int numClasses, int classType, int classIndex, boolean multiInstance) throws Exception {
        TestInstances dataset = new TestInstances();
        dataset.setSeed(seed);
        dataset.setNumInstances(numInstances);
        dataset.setNumNominal(numNominal);
        dataset.setNumNumeric(numNumeric);
        dataset.setNumString(numString);
        dataset.setNumDate(numDate);
        dataset.setNumRelational(numRelational);
        dataset.setNumClasses(numClasses);
        dataset.setClassType(classType);
        dataset.setClassIndex(classIndex);
        dataset.setNumClasses(numClasses);
        dataset.setMultiInstance(multiInstance);
        dataset.setWords(this.getWords());
        dataset.setWordSeparators(this.getWordSeparators());
        return this.process(dataset.generate());
    }

    protected void printAttributeSummary(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        String str = "";
        if (numericPredictor) {
            str = str + " numeric";
        }
        if (nominalPredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " nominal";
        }
        if (stringPredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " string";
        }
        if (datePredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " date";
        }
        if (relationalPredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " relational";
        }
        str = str + " predictors)";
        switch (classType) {
            case 0: {
                str = " (numeric class," + str;
                break;
            }
            case 1: {
                str = " (nominal class," + str;
                break;
            }
            case 2: {
                str = " (string class," + str;
                break;
            }
            case 3: {
                str = " (date class," + str;
                break;
            }
            case 4: {
                str = " (relational class," + str;
            }
        }
        this.print(str);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }

    public static void main(String[] args) {
        CheckKernel.runCheck(new CheckKernel(), args);
    }
}

