/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.classification;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.datagenerators.ClassificationGenerator;

public class RandomRBF
extends ClassificationGenerator {
    static final long serialVersionUID = 6069033710635728720L;
    protected int m_NumAttributes;
    protected int m_NumClasses;
    protected int m_NumCentroids;
    protected double[][] m_centroids;
    protected int[] m_centroidClasses;
    protected double[] m_centroidWeights;
    protected double[] m_centroidStdDevs;

    public RandomRBF() {
        this.setNumAttributes(this.defaultNumAttributes());
        this.setNumClasses(this.defaultNumClasses());
        this.setNumCentroids(this.defaultNumCentroids());
    }

    public String globalInfo() {
        return "RandomRBF data is generated by first creating a random set of centers for each class. Each center is randomly assigned a weight, a central point per attribute, and a standard deviation. To generate new instances, a center is chosen at random taking the weights of each center into consideration. Attribute values are randomly generated and offset from the center, where the overall vector has been scaled so that its length equals a value sampled randomly from the Gaussian distribution of the center. The particular center chosen determines the class of the instance.\n RandomRBF data contains only numeric attributes as it is non-trivial to include nominal values.";
    }

    public Enumeration listOptions() {
        Vector result = this.enumToVector(super.listOptions());
        result.addElement(new Option("\tThe number of attributes (default " + this.defaultNumAttributes() + ").", "a", 1, "-a <num>"));
        result.addElement(new Option("\tThe number of classes (default " + this.defaultNumClasses() + ")", "c", 1, "-c <num>"));
        result.add(new Option("\tThe number of centroids to use. (default " + this.defaultNumCentroids() + ")", "C", 1, "-C <num>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('a', options);
        if (tmpStr.length() != 0) {
            this.setNumAttributes(Integer.parseInt(tmpStr));
        } else {
            this.setNumAttributes(this.defaultNumAttributes());
        }
        tmpStr = Utils.getOption('c', options);
        if (tmpStr.length() != 0) {
            this.setNumClasses(Integer.parseInt(tmpStr));
        } else {
            this.setNumClasses(this.defaultNumClasses());
        }
        tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setNumCentroids(Integer.parseInt(tmpStr));
        } else {
            this.setNumCentroids(this.defaultNumCentroids());
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-a");
        result.add("" + this.getNumAttributes());
        result.add("-c");
        result.add("" + this.getNumClasses());
        result.add("-C");
        result.add("" + this.getNumCentroids());
        return result.toArray(new String[result.size()]);
    }

    protected int defaultNumAttributes() {
        return 10;
    }

    public void setNumAttributes(int numAttributes) {
        this.m_NumAttributes = numAttributes;
    }

    public int getNumAttributes() {
        return this.m_NumAttributes;
    }

    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain.";
    }

    protected int defaultNumClasses() {
        return 2;
    }

    public void setNumClasses(int numClasses) {
        this.m_NumClasses = numClasses;
    }

    public int getNumClasses() {
        return this.m_NumClasses;
    }

    public String numClassesTipText() {
        return "The number of classes to generate.";
    }

    protected int defaultNumCentroids() {
        return 50;
    }

    public int getNumCentroids() {
        return this.m_NumCentroids;
    }

    public void setNumCentroids(int value) {
        if (value > 0) {
            this.m_NumCentroids = value;
        } else {
            System.out.println("At least 1 centroid is necessary (provided: " + value + ")!");
        }
    }

    public String numCentroidsTipText() {
        return "The number of centroids to use.";
    }

    public boolean getSingleModeFlag() throws Exception {
        return true;
    }

    protected int chooseRandomIndexBasedOnProportions(double[] proportionArray, Random random) {
        double probSum = Utils.sum(proportionArray);
        double val = random.nextDouble() * probSum;
        int index = 0;
        for (double sum = 0.0; sum <= val && index < proportionArray.length; sum += proportionArray[index++]) {
        }
        return index - 1;
    }

    public Instances defineDataFormat() throws Exception {
        int i;
        this.m_Random = new Random(this.getSeed());
        Random rand = this.getRandom();
        this.setNumExamplesAct(this.getNumExamples());
        this.m_centroids = new double[this.getNumCentroids()][this.getNumAttributes()];
        this.m_centroidClasses = new int[this.getNumCentroids()];
        this.m_centroidWeights = new double[this.getNumCentroids()];
        this.m_centroidStdDevs = new double[this.getNumCentroids()];
        for (i = 0; i < this.getNumCentroids(); ++i) {
            for (int j = 0; j < this.getNumAttributes(); ++j) {
                this.m_centroids[i][j] = rand.nextDouble();
            }
            this.m_centroidClasses[i] = rand.nextInt(this.getNumClasses());
            this.m_centroidWeights[i] = rand.nextDouble();
            this.m_centroidStdDevs[i] = rand.nextDouble();
        }
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (i = 0; i < this.getNumAttributes(); ++i) {
            atts.addElement(new Attribute("a" + i));
        }
        FastVector<String> clsValues = new FastVector<String>();
        for (i = 0; i < this.getNumClasses(); ++i) {
            clsValues.addElement("c" + i);
        }
        atts.addElement(new Attribute("class", clsValues));
        this.m_DatasetFormat = new Instances(this.getRelationNameToUse(), atts, 0);
        return this.m_DatasetFormat;
    }

    public Instance generateExample() throws Exception {
        int i;
        Instance result = null;
        Random rand = this.getRandom();
        if (this.m_DatasetFormat == null) {
            throw new Exception("Dataset format not defined.");
        }
        int centroid = this.chooseRandomIndexBasedOnProportions(this.m_centroidWeights, rand);
        double label = this.m_centroidClasses[centroid];
        double[] atts = new double[this.getNumAttributes() + 1];
        for (i = 0; i < this.getNumAttributes(); ++i) {
            atts[i] = rand.nextDouble() * 2.0 - 1.0;
        }
        atts[atts.length - 1] = label;
        double magnitude = 0.0;
        for (i = 0; i < this.getNumAttributes(); ++i) {
            magnitude += atts[i] * atts[i];
        }
        magnitude = Math.sqrt(magnitude);
        double desiredMag = rand.nextGaussian() * this.m_centroidStdDevs[centroid];
        double scale = desiredMag / magnitude;
        for (i = 0; i < this.getNumAttributes(); ++i) {
            int n = i;
            atts[n] = atts[n] * scale;
            int n2 = i;
            atts[n2] = atts[n2] + this.m_centroids[centroid][i];
            result = new DenseInstance(1.0, atts);
        }
        result.setDataset(this.m_DatasetFormat);
        return result;
    }

    public Instances generateExamples() throws Exception {
        Instances result = new Instances(this.m_DatasetFormat, 0);
        this.m_Random = new Random(this.getSeed());
        for (int i = 0; i < this.getNumExamplesAct(); ++i) {
            result.add(this.generateExample());
        }
        return result;
    }

    public String generateStart() {
        StringBuffer result = new StringBuffer();
        result.append("%\n");
        result.append("% centroids:\n");
        for (int i = 0; i < this.getNumCentroids(); ++i) {
            result.append("% " + i + ".: " + Utils.arrayToString(this.m_centroids[i]) + "\n");
        }
        result.append("%\n");
        result.append("% centroidClasses: " + Utils.arrayToString(this.m_centroidClasses) + "\n");
        result.append("%\n");
        result.append("% centroidWeights: " + Utils.arrayToString(this.m_centroidWeights) + "\n");
        result.append("%\n");
        result.append("% centroidStdDevs: " + Utils.arrayToString(this.m_centroidStdDevs) + "\n");
        result.append("%\n");
        return result.toString();
    }

    public String generateFinished() throws Exception {
        return "";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        RandomRBF.runDataGenerator(new RandomRBF(), args);
    }
}

