/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.logging.Logger;
import weka.gui.Logger;
import weka.gui.TaskLogger;
import weka.gui.WekaTaskMonitor;

public class LogPanel
extends JPanel
implements Logger,
TaskLogger {
    private static final long serialVersionUID = -4072464549112439484L;
    protected JLabel m_StatusLab = new JLabel("OK");
    protected JTextArea m_LogText = new JTextArea(4, 20);
    protected JButton m_logButton = new JButton("Log");
    protected boolean m_First = true;
    protected WekaTaskMonitor m_TaskMonitor = null;

    public LogPanel() {
        this(null, false, false, true);
    }

    public LogPanel(WekaTaskMonitor tm) {
        this(tm, true, false, true);
    }

    public LogPanel(WekaTaskMonitor tm, boolean logHidden) {
        this(tm, logHidden, false, true);
    }

    public LogPanel(WekaTaskMonitor tm, boolean logHidden, boolean statusHidden, boolean titledBorder) {
        this.m_TaskMonitor = tm;
        this.m_LogText.setEditable(false);
        this.m_LogText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_StatusLab.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Status"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JScrollPane js = new JScrollPane(this.m_LogText);
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        if (logHidden) {
            final JFrame jf = new JFrame("Log");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.setVisible(false);
                }
            });
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)js, "Center");
            jf.pack();
            jf.setSize(450, 350);
            this.m_logButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    jf.setVisible(true);
                }
            });
            this.setLayout(new BorderLayout());
            JPanel logButPanel = new JPanel();
            logButPanel.setLayout(new BorderLayout());
            logButPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            logButPanel.add((Component)this.m_logButton, "Center");
            JPanel p1 = new JPanel();
            p1.setLayout(new BorderLayout());
            p1.add((Component)this.m_StatusLab, "Center");
            p1.add((Component)logButPanel, "East");
            if (tm == null) {
                this.add((Component)p1, "South");
            } else {
                JPanel p2 = new JPanel();
                p2.setLayout(new BorderLayout());
                p2.add((Component)p1, "Center");
                p2.add((Component)this.m_TaskMonitor, "East");
                this.add((Component)p2, "South");
            }
        } else {
            JPanel p1 = new JPanel();
            if (titledBorder) {
                p1.setBorder(BorderFactory.createTitledBorder("Log"));
            }
            p1.setLayout(new BorderLayout());
            p1.add((Component)js, "Center");
            this.setLayout(new BorderLayout());
            this.add((Component)p1, "Center");
            if (tm == null) {
                if (!statusHidden) {
                    this.add((Component)this.m_StatusLab, "South");
                }
            } else if (!statusHidden) {
                JPanel p2 = new JPanel();
                p2.setLayout(new BorderLayout());
                p2.add((Component)this.m_StatusLab, "Center");
                p2.add((Component)this.m_TaskMonitor, "East");
                this.add((Component)p2, "South");
            }
        }
        this.addPopup();
    }

    public void setLoggingFontSize(int size) {
        if (size > 0) {
            this.m_LogText.setFont(new Font(null, 0, size));
        } else {
            Font temp = new JTextArea().getFont();
            this.m_LogText.setFont(temp);
        }
    }

    private String printLong(long l) {
        String str = Long.toString(l);
        String result = "";
        int count = 0;
        for (int i = str.length() - 1; i >= 0; --i) {
            result = str.charAt(i) + result;
            if (++count != 3 || i <= 0) continue;
            result = "," + result;
            count = 0;
        }
        return result;
    }

    private void addPopup() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    JPopupMenu gcMenu = new JPopupMenu();
                    JMenuItem availMem = new JMenuItem("Memory information");
                    availMem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ee) {
                            System.gc();
                            Runtime currR = Runtime.getRuntime();
                            long freeM = currR.freeMemory();
                            long totalM = currR.totalMemory();
                            long maxM = currR.maxMemory();
                            LogPanel.this.logMessage("Memory (free/total/max.) in bytes: " + LogPanel.this.printLong(freeM) + " / " + LogPanel.this.printLong(totalM) + " / " + LogPanel.this.printLong(maxM));
                            LogPanel.this.statusMessage("Memory (free/total/max.) in bytes: " + LogPanel.this.printLong(freeM) + " / " + LogPanel.this.printLong(totalM) + " / " + LogPanel.this.printLong(maxM));
                        }
                    });
                    gcMenu.add(availMem);
                    JMenuItem runGC = new JMenuItem("Run garbage collector");
                    runGC.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ee) {
                            LogPanel.this.statusMessage("Running garbage collector");
                            System.gc();
                            LogPanel.this.statusMessage("OK");
                        }
                    });
                    gcMenu.add(runGC);
                    gcMenu.show(LogPanel.this, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void taskStarted() {
        if (this.m_TaskMonitor != null) {
            this.m_TaskMonitor.taskStarted();
        }
    }

    @Override
    public void taskFinished() {
        if (this.m_TaskMonitor != null) {
            this.m_TaskMonitor.taskFinished();
        }
    }

    protected static String getTimestamp() {
        return new SimpleDateFormat("HH:mm:ss:").format(new Date());
    }

    @Override
    public synchronized void logMessage(String message) {
        if (this.m_First) {
            this.m_First = false;
        } else {
            this.m_LogText.append("\n");
        }
        this.m_LogText.append(LogPanel.getTimestamp() + ' ' + message);
        weka.core.logging.Logger.log(Logger.Level.INFO, message);
    }

    @Override
    public synchronized void statusMessage(String message) {
        this.m_StatusLab.setText(message);
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Log Panel");
            jf.getContentPane().setLayout(new BorderLayout());
            LogPanel lp = new LogPanel();
            jf.getContentPane().add((Component)lp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            lp.logMessage("Welcome to the generic log panel!");
            lp.statusMessage("Hi there");
            lp.logMessage("Funky chickens");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

