/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import weka.classifiers.UpdateableClassifier;
import weka.classifiers.bayes.NaiveBayesMultinomial;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class NaiveBayesMultinomialUpdateable
extends NaiveBayesMultinomial
implements UpdateableClassifier {
    private static final long serialVersionUID = -7204398796974263186L;
    protected double[] m_wordsPerClass;

    @Override
    public String globalInfo() {
        return super.globalInfo() + "\n\nIncremental version of the algorithm.";
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_headerInfo = new Instances(instances, 0);
        this.m_numClasses = instances.numClasses();
        this.m_numAttributes = instances.numAttributes();
        this.m_probOfWordGivenClass = new double[this.m_numClasses][];
        this.m_wordsPerClass = new double[this.m_numClasses];
        this.m_probOfClass = new double[this.m_numClasses];
        double laplace = 1.0;
        for (int c = 0; c < this.m_numClasses; ++c) {
            this.m_probOfWordGivenClass[c] = new double[this.m_numAttributes];
            this.m_probOfClass[c] = laplace;
            this.m_wordsPerClass[c] = laplace * (double)this.m_numAttributes;
            for (int att = 0; att < this.m_numAttributes; ++att) {
                this.m_probOfWordGivenClass[c][att] = laplace;
            }
        }
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.updateClassifier(instances.instance(i));
        }
    }

    @Override
    public void updateClassifier(Instance instance) throws Exception {
        int classIndex;
        int n = classIndex = (int)instance.value(instance.classIndex());
        this.m_probOfClass[n] = this.m_probOfClass[n] + instance.weight();
        for (int a = 0; a < instance.numValues(); ++a) {
            if (instance.index(a) == instance.classIndex() || instance.isMissingSparse(a)) continue;
            double numOccurences = instance.valueSparse(a) * instance.weight();
            int n2 = classIndex;
            this.m_wordsPerClass[n2] = this.m_wordsPerClass[n2] + numOccurences;
            if (this.m_wordsPerClass[classIndex] < 0.0) {
                throw new Exception("Can't have a negative number of words for class " + (classIndex + 1));
            }
            double[] dArray = this.m_probOfWordGivenClass[classIndex];
            int n3 = instance.index(a);
            dArray[n3] = dArray[n3] + numOccurences;
            if (!(this.m_probOfWordGivenClass[classIndex][instance.index(a)] < 0.0)) continue;
            throw new Exception("Can't have a negative conditional sum for attribute " + instance.index(a));
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        int i;
        double[] probOfClassGivenDoc = new double[this.m_numClasses];
        double[] logDocGivenClass = new double[this.m_numClasses];
        for (int c = 0; c < this.m_numClasses; ++c) {
            int n = c;
            logDocGivenClass[n] = logDocGivenClass[n] + Math.log(this.m_probOfClass[c]);
            int allWords = 0;
            for (i = 0; i < instance.numValues(); ++i) {
                if (instance.index(i) == instance.classIndex()) continue;
                double frequencies = instance.valueSparse(i);
                allWords = (int)((double)allWords + frequencies);
                int n2 = c;
                logDocGivenClass[n2] = logDocGivenClass[n2] + frequencies * Math.log(this.m_probOfWordGivenClass[c][instance.index(i)]);
            }
            int n3 = c;
            logDocGivenClass[n3] = logDocGivenClass[n3] - (double)allWords * Math.log(this.m_wordsPerClass[c]);
        }
        double max = logDocGivenClass[Utils.maxIndex(logDocGivenClass)];
        for (i = 0; i < this.m_numClasses; ++i) {
            probOfClassGivenDoc[i] = Math.exp(logDocGivenClass[i] - max);
        }
        Utils.normalize(probOfClassGivenDoc);
        return probOfClassGivenDoc;
    }

    @Override
    public String toString() {
        int c;
        StringBuffer result = new StringBuffer();
        result.append("Dictionary size: " + this.m_numAttributes).append("\n\n");
        result.append("The independent frequency of a class\n");
        result.append("--------------------------------------\n");
        for (c = 0; c < this.m_numClasses; ++c) {
            result.append(this.m_headerInfo.classAttribute().value(c)).append("\t").append(Double.toString(this.m_probOfClass[c])).append("\n");
        }
        result.append("\nThe frequency of a word given the class\n");
        result.append("-----------------------------------------\n");
        for (c = 0; c < this.m_numClasses; ++c) {
            result.append(Utils.padLeft(this.m_headerInfo.classAttribute().value(c), 11)).append("\t");
        }
        result.append("\n");
        for (int w = 0; w < this.m_numAttributes; ++w) {
            if (w == this.m_headerInfo.classIndex()) continue;
            for (int c2 = 0; c2 < this.m_numClasses; ++c2) {
                result.append(Utils.padLeft(Double.toString(this.m_probOfWordGivenClass[c2][w]), 11)).append("\t");
            }
            result.append(this.m_headerInfo.attribute(w).name());
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11301 $");
    }

    public static void main(String[] args) {
        NaiveBayesMultinomialUpdateable.runClassifier(new NaiveBayesMultinomialUpdateable(), args);
    }
}

