/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.neighboursearch.balltrees.BallNode;

public abstract class BallSplitter
implements Serializable,
OptionHandler,
RevisionHandler {
    private static final long serialVersionUID = -2233739562654159948L;
    protected Instances m_Instances;
    protected EuclideanDistance m_DistanceFunction;
    protected int[] m_Instlist;

    public BallSplitter() {
    }

    public BallSplitter(int[] instList, Instances insts, EuclideanDistance e) {
        this.m_Instlist = instList;
        this.m_Instances = insts;
        this.m_DistanceFunction = e;
    }

    protected void correctlyInitialized() throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied.");
        }
        if (this.m_Instlist == null) {
            throw new Exception("No instance list supplied.");
        }
        if (this.m_DistanceFunction == null) {
            throw new Exception("No Euclidean distance function supplied.");
        }
        if (this.m_Instances.numInstances() != this.m_Instlist.length) {
            throw new Exception("The supplied instance list doesn't seem to match the supplied instances");
        }
    }

    @Override
    public Enumeration<Option> listOptions() {
        return new Vector().elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
    }

    @Override
    public String[] getOptions() {
        return new String[0];
    }

    public abstract void splitNode(BallNode var1, int var2) throws Exception;

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
    }

    public void setInstanceList(int[] instList) {
        this.m_Instlist = instList;
    }

    public void setEuclideanDistanceFunction(EuclideanDistance func) {
        this.m_DistanceFunction = func;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }
}

