/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Settings;
import weka.core.logging.Logger;
import weka.gui.ExtensionFileFilter;
import weka.gui.Logger;
import weka.gui.visualize.AttributePanel;
import weka.gui.visualize.AttributePanelEvent;
import weka.gui.visualize.AttributePanelListener;
import weka.gui.visualize.ClassPanel;
import weka.gui.visualize.LegendPanel;
import weka.gui.visualize.Plot2D;
import weka.gui.visualize.Plot2DCompanion;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.PrintablePanel;
import weka.gui.visualize.VisualizePanelEvent;
import weka.gui.visualize.VisualizePanelListener;
import weka.gui.visualize.VisualizeUtils;

public class VisualizePanel
extends PrintablePanel {
    private static final long serialVersionUID = 240108358588153943L;
    protected Color[] m_DefaultColors = new Color[]{Color.blue, Color.red, Color.green, Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};
    protected JComboBox m_XCombo = new JComboBox();
    protected JComboBox m_YCombo = new JComboBox();
    protected JComboBox m_ColourCombo = new JComboBox();
    protected JComboBox m_ShapeCombo = new JComboBox();
    protected JButton m_submit = new JButton("Submit");
    protected JButton m_cancel = new JButton("Clear");
    protected JButton m_openBut = new JButton("Open");
    protected JButton m_saveBut = new JButton("Save");
    private final Dimension COMBO_SIZE;
    protected JFileChooser m_FileChooser;
    protected FileFilter m_ArffFilter;
    protected JLabel m_JitterLab;
    protected JSlider m_Jitter;
    protected PlotPanel m_plot;
    protected AttributePanel m_attrib;
    protected LegendPanel m_legendPanel;
    protected JPanel m_plotSurround;
    protected JPanel m_classSurround;
    protected ActionListener listener;
    protected VisualizePanelListener m_splitListener;
    protected String m_plotName;
    protected ClassPanel m_classPanel;
    protected ArrayList<Color> m_colorList;
    protected String m_preferredXDimension;
    protected String m_preferredYDimension;
    protected String m_preferredColourDimension;
    protected boolean m_showAttBars;
    protected boolean m_showClassPanel;
    protected Logger m_Log;

    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    public void setShowAttBars(boolean sab) {
        if (!sab && this.m_showAttBars) {
            this.m_plotSurround.remove(this.m_attrib);
        } else if (sab && !this.m_showAttBars) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.gridx = 4;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weighty = 5.0;
            this.m_plotSurround.add((Component)this.m_attrib, constraints);
        }
        this.m_showAttBars = sab;
        this.repaint();
    }

    public boolean getShowAttBars() {
        return this.m_showAttBars;
    }

    public void setShowClassPanel(boolean scp) {
        if (!scp && this.m_showClassPanel) {
            this.remove(this.m_classSurround);
        } else if (scp && !this.m_showClassPanel) {
            this.add((Component)this.m_classSurround, "South");
        }
        this.m_showClassPanel = scp;
        this.repaint();
    }

    public boolean getShowClassPanel() {
        return this.m_showClassPanel;
    }

    public VisualizePanel(VisualizePanelListener ls) {
        this();
        this.m_splitListener = ls;
    }

    private void setProperties(String relationName) {
        if (VisualizeUtils.VISUALIZE_PROPERTIES != null) {
            String thisClass = this.getClass().getName();
            if (relationName == null) {
                String showAttBars = thisClass + ".displayAttributeBars";
                String val = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(showAttBars);
                if (val != null && this.m_showAttBars) {
                    this.m_showAttBars = val.compareTo("true") == 0 || val.compareTo("on") == 0;
                }
            } else {
                String xcolKey = thisClass + "." + relationName + ".XDimension";
                String ycolKey = thisClass + "." + relationName + ".YDimension";
                String ccolKey = thisClass + "." + relationName + ".ColourDimension";
                this.m_preferredXDimension = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(xcolKey);
                this.m_preferredYDimension = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(ycolKey);
                this.m_preferredColourDimension = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(ccolKey);
            }
        }
    }

    public void applySettings(Settings settings, String ownerID) {
        this.m_plot.applySettings(settings, ownerID);
        this.m_attrib.applySettings(settings, ownerID);
        this.repaint();
    }

    public VisualizePanel() {
        this.COMBO_SIZE = new Dimension(250, this.m_saveBut.getPreferredSize().height);
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_ArffFilter = new ExtensionFileFilter(".arff", "Arff data files");
        this.m_JitterLab = new JLabel("Jitter", 4);
        this.m_Jitter = new JSlider(0, 50, 0);
        this.m_plot = new PlotPanel();
        this.m_attrib = new AttributePanel(this.m_plot.m_plot2D.getBackground());
        this.m_legendPanel = new LegendPanel();
        this.m_plotSurround = new JPanel();
        this.m_classSurround = new JPanel();
        this.listener = null;
        this.m_splitListener = null;
        this.m_plotName = "";
        this.m_classPanel = new ClassPanel(this.m_plot.m_plot2D.getBackground());
        this.m_preferredXDimension = null;
        this.m_preferredYDimension = null;
        this.m_preferredColourDimension = null;
        this.m_showAttBars = true;
        this.m_showClassPanel = true;
        this.setProperties(null);
        this.m_FileChooser.setFileFilter(this.m_ArffFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_XCombo.setToolTipText("Select the attribute for the x axis");
        this.m_YCombo.setToolTipText("Select the attribute for the y axis");
        this.m_ColourCombo.setToolTipText("Select the attribute to colour on");
        this.m_ShapeCombo.setToolTipText("Select the shape to use for data selection");
        this.m_XCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_YCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ColourCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ShapeCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_XCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_YCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ColourCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ShapeCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_XCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_YCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_ColourCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_ShapeCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_XCombo.setEnabled(false);
        this.m_YCombo.setEnabled(false);
        this.m_ColourCombo.setEnabled(false);
        this.m_ShapeCombo.setEnabled(false);
        this.m_classPanel.addRepaintNotify(this);
        this.m_legendPanel.addRepaintNotify(this);
        for (int i = 0; i < this.m_DefaultColors.length; ++i) {
            Color c = this.m_DefaultColors[i];
            if (!c.equals(this.m_plot.m_plot2D.getBackground())) continue;
            int red = c.getRed();
            int blue = c.getBlue();
            int green = c.getGreen();
            this.m_DefaultColors[i] = new Color(red, green += green < 128 ? (255 - green) / 2 : -(green / 2), blue += blue < 128 ? (blue - (red += red < 128 ? (255 - red) / 2 : -(red / 2))) / 2 : -(blue / 2));
        }
        this.m_classPanel.setDefaultColourList(this.m_DefaultColors);
        this.m_attrib.setDefaultColourList(this.m_DefaultColors);
        this.m_colorList = new ArrayList(10);
        for (int noa = this.m_colorList.size(); noa < 10; ++noa) {
            Color pc = this.m_DefaultColors[noa % 10];
            int ija = noa / 10;
            ija *= 2;
            for (int j = 0; j < ija; ++j) {
                pc = pc.darker();
            }
            this.m_colorList.add(pc);
        }
        this.m_plot.setColours(this.m_colorList);
        this.m_classPanel.setColours(this.m_colorList);
        this.m_attrib.setColours(this.m_colorList);
        this.m_attrib.addAttributePanelListener(new AttributePanelListener(){

            @Override
            public void attributeSelectionChange(AttributePanelEvent e) {
                if (e.m_xChange) {
                    VisualizePanel.this.m_XCombo.setSelectedIndex(e.m_indexVal);
                } else {
                    VisualizePanel.this.m_YCombo.setSelectedIndex(e.m_indexVal);
                }
            }
        });
        this.m_XCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = VisualizePanel.this.m_XCombo.getSelectedIndex();
                if (selected < 0) {
                    selected = 0;
                }
                VisualizePanel.this.m_plot.setXindex(selected);
                if (VisualizePanel.this.listener != null) {
                    VisualizePanel.this.listener.actionPerformed(e);
                }
            }
        });
        this.m_YCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = VisualizePanel.this.m_YCombo.getSelectedIndex();
                if (selected < 0) {
                    selected = 0;
                }
                VisualizePanel.this.m_plot.setYindex(selected);
                if (VisualizePanel.this.listener != null) {
                    VisualizePanel.this.listener.actionPerformed(e);
                }
            }
        });
        this.m_ColourCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = VisualizePanel.this.m_ColourCombo.getSelectedIndex();
                if (selected < 0) {
                    selected = 0;
                }
                VisualizePanel.this.m_plot.setCindex(selected);
                if (VisualizePanel.this.listener != null) {
                    VisualizePanel.this.listener.actionPerformed(e);
                }
            }
        });
        this.m_ShapeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = VisualizePanel.this.m_ShapeCombo.getSelectedIndex();
                if (selected < 0) {
                    selected = 0;
                }
                VisualizePanel.this.m_plot.setSindex(selected);
                if (VisualizePanel.this.listener != null) {
                    VisualizePanel.this.listener.actionPerformed(e);
                }
            }
        });
        this.m_Jitter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VisualizePanel.this.m_plot.setJitter(VisualizePanel.this.m_Jitter.getValue());
            }
        });
        this.m_openBut.setToolTipText("Loads previously saved instances from a file");
        this.m_openBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizePanel.this.openVisibleInstances();
            }
        });
        this.m_saveBut.setEnabled(false);
        this.m_saveBut.setToolTipText("Save the visible instances to a file");
        this.m_saveBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizePanel.this.saveVisibleInstances();
            }
        });
        JPanel combos = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.m_XCombo.setLightWeightPopupEnabled(false);
        this.m_YCombo.setLightWeightPopupEnabled(false);
        this.m_ColourCombo.setLightWeightPopupEnabled(false);
        this.m_ShapeCombo.setLightWeightPopupEnabled(false);
        combos.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        combos.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        combos.add((Component)this.m_XCombo, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        combos.add((Component)this.m_YCombo, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 5.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        combos.add((Component)this.m_ColourCombo, constraints);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.weightx = 5.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        combos.add((Component)this.m_ShapeCombo, constraints);
        JPanel mbts = new JPanel();
        mbts.setLayout(new GridLayout(1, 4));
        mbts.add(this.m_submit);
        mbts.add(this.m_cancel);
        mbts.add(this.m_openBut);
        mbts.add(this.m_saveBut);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 5.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        combos.add((Component)mbts, constraints);
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(10, 0, 0, 5);
        combos.add((Component)this.m_JitterLab, constraints);
        constraints.gridx = 3;
        constraints.gridy = 2;
        constraints.weightx = 5.0;
        constraints.insets = new Insets(10, 0, 0, 0);
        combos.add((Component)this.m_Jitter, constraints);
        this.m_classSurround = new JPanel();
        this.m_classSurround.setBorder(BorderFactory.createTitledBorder("Class colour"));
        this.m_classSurround.setLayout(new BorderLayout());
        this.m_classPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 10, 10));
        this.m_classSurround.add((Component)this.m_classPanel, "Center");
        GridBagLayout gb2 = new GridBagLayout();
        this.m_plotSurround.setBorder(BorderFactory.createTitledBorder("Plot"));
        this.m_plotSurround.setLayout(gb2);
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 10);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 3.0;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.weighty = 5.0;
        this.m_plotSurround.add((Component)this.m_plot, constraints);
        if (this.m_showAttBars) {
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.gridx = 4;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weighty = 5.0;
            this.m_plotSurround.add((Component)this.m_attrib, constraints);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)combos, "North");
        this.add((Component)this.m_plotSurround, "Center");
        this.add((Component)this.m_classSurround, "South");
        String[] SNames = new String[]{"Select Instance", "Rectangle", "Polygon", "Polyline"};
        this.m_ShapeCombo.setModel(new DefaultComboBoxModel<String>(SNames));
        this.m_ShapeCombo.setEnabled(true);
    }

    protected void openVisibleInstances(Instances insts) throws Exception {
        PlotData2D tempd = new PlotData2D(insts);
        tempd.setPlotName(insts.relationName());
        tempd.addInstanceNumberAttribute();
        this.m_plot.m_plot2D.removeAllPlots();
        this.addPlot(tempd);
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JFrame)) continue;
            ((JFrame)parent).setTitle("Weka Classifier Visualize: " + insts.relationName() + " (display only)");
            break;
        }
    }

    protected void openVisibleInstances() {
        try {
            int returnVal = this.m_FileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File sFile = this.m_FileChooser.getSelectedFile();
                if (!sFile.getName().toLowerCase().endsWith(".arff")) {
                    sFile = new File(sFile.getParent(), sFile.getName() + ".arff");
                }
                File selected = sFile;
                Instances insts = new Instances(new BufferedReader(new FileReader(selected)));
                this.openVisibleInstances(insts);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_plot.m_plot2D.removeAllPlots();
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error loading file...", 0);
        }
    }

    private void saveVisibleInstances() {
        ArrayList<PlotData2D> plots = this.m_plot.m_plot2D.getPlots();
        if (plots != null) {
            PlotData2D master = plots.get(0);
            Instances saveInsts = new Instances(master.getPlotInstances());
            for (int i = 1; i < plots.size(); ++i) {
                PlotData2D temp = plots.get(i);
                Instances addInsts = temp.getPlotInstances();
                for (int j = 0; j < addInsts.numInstances(); ++j) {
                    saveInsts.add(addInsts.instance(j));
                }
            }
            try {
                int returnVal = this.m_FileChooser.showSaveDialog(this);
                if (returnVal == 0) {
                    File sFile = this.m_FileChooser.getSelectedFile();
                    if (!sFile.getName().toLowerCase().endsWith(".arff")) {
                        sFile = new File(sFile.getParent(), sFile.getName() + ".arff");
                    }
                    File selected = sFile;
                    BufferedWriter w = new BufferedWriter(new FileWriter(selected));
                    w.write(saveInsts.toString());
                    ((Writer)w).close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setColourIndex(int index, boolean enableCombo) {
        if (index >= 0) {
            this.m_ColourCombo.setSelectedIndex(index);
        } else {
            this.m_ColourCombo.setSelectedIndex(0);
        }
        this.m_ColourCombo.setEnabled(enableCombo);
    }

    public void setColourIndex(int index) {
        this.setColourIndex(index, false);
    }

    public void setXIndex(int index) throws Exception {
        if (index < 0 || index >= this.m_XCombo.getItemCount()) {
            throw new Exception("x index is out of range!");
        }
        this.m_XCombo.setSelectedIndex(index);
    }

    public int getXIndex() {
        return this.m_XCombo.getSelectedIndex();
    }

    public void setYIndex(int index) throws Exception {
        if (index < 0 || index >= this.m_YCombo.getItemCount()) {
            throw new Exception("y index is out of range!");
        }
        this.m_YCombo.setSelectedIndex(index);
    }

    public int getYIndex() {
        return this.m_YCombo.getSelectedIndex();
    }

    public int getCIndex() {
        return this.m_ColourCombo.getSelectedIndex();
    }

    public int getSIndex() {
        return this.m_ShapeCombo.getSelectedIndex();
    }

    public void setSIndex(int index) throws Exception {
        if (index < 0 || index >= this.m_ShapeCombo.getItemCount()) {
            throw new Exception("s index is out of range!");
        }
        this.m_ShapeCombo.setSelectedIndex(index);
    }

    public void addActionListener(ActionListener act) {
        this.listener = act;
    }

    @Override
    public void setName(String plotName) {
        this.m_plotName = plotName;
    }

    @Override
    public String getName() {
        return this.m_plotName;
    }

    public Instances getInstances() {
        return this.m_plot.m_plotInstances;
    }

    protected void newColorAttribute(int a, Instances i) {
        if (i.attribute(a).isNominal()) {
            for (int noa = this.m_colorList.size(); noa < i.attribute(a).numValues(); ++noa) {
                Color pc = this.m_DefaultColors[noa % 10];
                int ija = noa / 10;
                ija *= 2;
                for (int j = 0; j < ija; ++j) {
                    pc = pc.brighter();
                }
                this.m_colorList.add(pc);
            }
            this.m_plot.setColours(this.m_colorList);
            this.m_attrib.setColours(this.m_colorList);
            this.m_classPanel.setColours(this.m_colorList);
        }
    }

    public void setShapes(ArrayList<ArrayList<Double>> l) {
        this.m_plot.setShapes(l);
    }

    public void setInstances(Instances inst) {
        if (inst.numAttributes() > 0 && inst.numInstances() > 0) {
            this.newColorAttribute(inst.numAttributes() - 1, inst);
        }
        PlotData2D temp = new PlotData2D(inst);
        temp.setPlotName(inst.relationName());
        try {
            this.setMasterPlot(temp);
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
        }
    }

    public void setUpComboBoxes(Instances inst) {
        this.setProperties(inst.relationName());
        int prefX = -1;
        int prefY = -1;
        if (inst.numAttributes() > 1) {
            prefY = 1;
        }
        int prefC = -1;
        String[] XNames = new String[inst.numAttributes()];
        String[] YNames = new String[inst.numAttributes()];
        String[] CNames = new String[inst.numAttributes()];
        for (int i = 0; i < XNames.length; ++i) {
            String type = " (" + Attribute.typeToStringShort(inst.attribute(i)) + ")";
            XNames[i] = "X: " + inst.attribute(i).name() + type;
            YNames[i] = "Y: " + inst.attribute(i).name() + type;
            CNames[i] = "Colour: " + inst.attribute(i).name() + type;
            if (this.m_preferredXDimension != null && this.m_preferredXDimension.compareTo(inst.attribute(i).name()) == 0) {
                prefX = i;
            }
            if (this.m_preferredYDimension != null && this.m_preferredYDimension.compareTo(inst.attribute(i).name()) == 0) {
                prefY = i;
            }
            if (this.m_preferredColourDimension == null || this.m_preferredColourDimension.compareTo(inst.attribute(i).name()) != 0) continue;
            prefC = i;
        }
        this.m_XCombo.setModel(new DefaultComboBoxModel<String>(XNames));
        this.m_YCombo.setModel(new DefaultComboBoxModel<String>(YNames));
        this.m_ColourCombo.setModel(new DefaultComboBoxModel<String>(CNames));
        this.m_XCombo.setEnabled(true);
        this.m_YCombo.setEnabled(true);
        if (this.m_splitListener == null) {
            this.m_ColourCombo.setEnabled(true);
            this.m_ColourCombo.setSelectedIndex(inst.numAttributes() - 1);
        }
        this.m_plotSurround.setBorder(BorderFactory.createTitledBorder("Plot: " + inst.relationName()));
        try {
            if (prefX != -1) {
                this.setXIndex(prefX);
            }
            if (prefY != -1) {
                this.setYIndex(prefY);
            }
            if (prefC != -1) {
                this.m_ColourCombo.setSelectedIndex(prefC);
            }
        }
        catch (Exception ex) {
            System.err.println("Problem setting preferred Visualization dimensions");
        }
    }

    public void removeAllPlots() {
        this.m_plot.removeAllPlots();
    }

    public void setMasterPlot(PlotData2D newPlot) throws Exception {
        this.m_plot.setMasterPlot(newPlot);
        this.setUpComboBoxes(newPlot.m_plotInstances);
        this.m_saveBut.setEnabled(true);
        this.repaint();
    }

    public void addPlot(PlotData2D newPlot) throws Exception {
        this.m_plot.addPlot(newPlot);
        if (this.m_plot.m_plot2D.getMasterPlot() != null) {
            this.setUpComboBoxes(newPlot.m_plotInstances);
        }
        this.m_saveBut.setEnabled(true);
        this.repaint();
    }

    public PlotPanel getPlotPanel() {
        return this.m_plot;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.err.println("Usage : weka.gui.visualize.VisualizePanel <dataset> [<dataset> <dataset>...]");
                System.exit(1);
            }
            weka.core.logging.Logger.log(Logger.Level.INFO, "Logging started");
            final JFrame jf = new JFrame("Weka Explorer: Visualize");
            jf.setSize(500, 400);
            jf.getContentPane().setLayout(new BorderLayout());
            VisualizePanel sp = new VisualizePanel();
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setVisible(true);
            if (args.length >= 1) {
                for (int j = 0; j < args.length; ++j) {
                    System.err.println("Loading instances from " + args[j]);
                    BufferedReader r = new BufferedReader(new FileReader(args[j]));
                    Instances i = new Instances(r);
                    i.setClassIndex(i.numAttributes() - 1);
                    PlotData2D pd1 = new PlotData2D(i);
                    if (j == 0) {
                        pd1.setPlotName("Master plot");
                        sp.setMasterPlot(pd1);
                        continue;
                    }
                    pd1.setPlotName("Plot " + (j + 1));
                    pd1.m_useCustomColour = true;
                    pd1.m_customColour = j % 2 == 0 ? Color.red : Color.blue;
                    sp.addPlot(pd1);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    protected class PlotPanel
    extends PrintablePanel
    implements Plot2DCompanion {
        private static final long serialVersionUID = -4823674171136494204L;
        protected Plot2D m_plot2D = new Plot2D();
        protected Instances m_plotInstances = null;
        protected PlotData2D m_originalPlot = null;
        protected int m_xIndex = 0;
        protected int m_yIndex = 0;
        protected int m_cIndex = 0;
        protected int m_sIndex = 0;
        private boolean m_createShape;
        private ArrayList<ArrayList<Double>> m_shapes;
        private ArrayList<Double> m_shapePoints;
        private final Dimension m_newMousePos;

        public PlotPanel() {
            this.setBackground(this.m_plot2D.getBackground());
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_plot2D, "Center");
            this.m_plot2D.setPlotCompanion(this);
            this.m_createShape = false;
            this.m_shapes = null;
            this.m_shapePoints = null;
            this.m_newMousePos = new Dimension();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if ((e.getModifiers() & 0x10) == 16 && PlotPanel.this.m_sIndex != 0 && PlotPanel.this.m_sIndex == 1) {
                        PlotPanel.this.m_createShape = true;
                        PlotPanel.this.m_shapePoints = new ArrayList(5);
                        PlotPanel.this.m_shapePoints.add(new Double(PlotPanel.this.m_sIndex));
                        PlotPanel.this.m_shapePoints.add(new Double(e.getX()));
                        PlotPanel.this.m_shapePoints.add(new Double(e.getY()));
                        PlotPanel.this.m_shapePoints.add(new Double(e.getX()));
                        PlotPanel.this.m_shapePoints.add(new Double(e.getY()));
                        Graphics g = PlotPanel.this.m_plot2D.getGraphics();
                        g.setColor(Color.black);
                        g.setXORMode(Color.white);
                        g.drawRect(((Double)PlotPanel.this.m_shapePoints.get(1)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(2)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(3)).intValue() - ((Double)PlotPanel.this.m_shapePoints.get(1)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(4)).intValue() - ((Double)PlotPanel.this.m_shapePoints.get(2)).intValue());
                        g.dispose();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!(PlotPanel.this.m_sIndex != 2 && PlotPanel.this.m_sIndex != 3 || !PlotPanel.this.m_createShape && (e.getModifiers() & 0x10) != 16)) {
                        if (PlotPanel.this.m_createShape) {
                            Graphics g = PlotPanel.this.m_plot2D.getGraphics();
                            g.setColor(Color.black);
                            g.setXORMode(Color.white);
                            if ((e.getModifiers() & 0x10) == 16 && !e.isAltDown()) {
                                PlotPanel.this.m_shapePoints.add(new Double(PlotPanel.this.m_plot2D.convertToAttribX(e.getX())));
                                PlotPanel.this.m_shapePoints.add(new Double(PlotPanel.this.m_plot2D.convertToAttribY(e.getY())));
                                ((PlotPanel)PlotPanel.this).m_newMousePos.width = e.getX();
                                ((PlotPanel)PlotPanel.this).m_newMousePos.height = e.getY();
                                g.drawLine((int)Math.ceil(PlotPanel.this.m_plot2D.convertToPanelX((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 2))), (int)Math.ceil(PlotPanel.this.m_plot2D.convertToPanelY((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 1))), ((PlotPanel)PlotPanel.this).m_newMousePos.width, ((PlotPanel)PlotPanel.this).m_newMousePos.height);
                            } else if (PlotPanel.this.m_sIndex == 3) {
                                PlotPanel.this.m_createShape = false;
                                if (PlotPanel.this.m_shapePoints.size() >= 5) {
                                    double cx = Math.ceil(PlotPanel.this.m_plot2D.convertToPanelX((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 4)));
                                    double cx2 = Math.ceil(PlotPanel.this.m_plot2D.convertToPanelX((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 2))) - cx;
                                    cx2 *= 50000.0;
                                    double cy = Math.ceil(PlotPanel.this.m_plot2D.convertToPanelY((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 3)));
                                    double cy2 = Math.ceil(PlotPanel.this.m_plot2D.convertToPanelY((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 1))) - cy;
                                    cy2 *= 50000.0;
                                    double cxa = Math.ceil(PlotPanel.this.m_plot2D.convertToPanelX((Double)PlotPanel.this.m_shapePoints.get(3)));
                                    double cxa2 = Math.ceil(PlotPanel.this.m_plot2D.convertToPanelX((Double)PlotPanel.this.m_shapePoints.get(1))) - cxa;
                                    double cya = Math.ceil(PlotPanel.this.m_plot2D.convertToPanelY((Double)PlotPanel.this.m_shapePoints.get(4)));
                                    double cya2 = Math.ceil(PlotPanel.this.m_plot2D.convertToPanelY((Double)PlotPanel.this.m_shapePoints.get(2))) - cya;
                                    cya2 *= 50000.0;
                                    PlotPanel.this.m_shapePoints.set(1, new Double(PlotPanel.this.m_plot2D.convertToAttribX((cxa2 *= 50000.0) + cxa)));
                                    PlotPanel.this.m_shapePoints.set(PlotPanel.this.m_shapePoints.size() - 1, new Double(PlotPanel.this.m_plot2D.convertToAttribY(cy2 + cy)));
                                    PlotPanel.this.m_shapePoints.set(PlotPanel.this.m_shapePoints.size() - 2, new Double(PlotPanel.this.m_plot2D.convertToAttribX(cx2 + cx)));
                                    PlotPanel.this.m_shapePoints.set(2, new Double(PlotPanel.this.m_plot2D.convertToAttribY(cya2 + cya)));
                                    cy = Double.POSITIVE_INFINITY;
                                    cy2 = Double.NEGATIVE_INFINITY;
                                    if ((Double)PlotPanel.this.m_shapePoints.get(1) > (Double)PlotPanel.this.m_shapePoints.get(3) && ((Double)PlotPanel.this.m_shapePoints.get(2)).doubleValue() == ((Double)PlotPanel.this.m_shapePoints.get(4)).doubleValue()) {
                                        cy = (Double)PlotPanel.this.m_shapePoints.get(2);
                                    }
                                    if ((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 2) > (Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 4) && ((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 3)).doubleValue() == ((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 1)).doubleValue()) {
                                        cy2 = (Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 1);
                                    }
                                    PlotPanel.this.m_shapePoints.add(new Double(cy));
                                    PlotPanel.this.m_shapePoints.add(new Double(cy2));
                                    if (!PlotPanel.this.inPolyline(PlotPanel.this.m_shapePoints, PlotPanel.this.m_plot2D.convertToAttribX(e.getX()), PlotPanel.this.m_plot2D.convertToAttribY(e.getY()))) {
                                        Double tmp = (Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 2);
                                        PlotPanel.this.m_shapePoints.set(PlotPanel.this.m_shapePoints.size() - 2, PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 1));
                                        PlotPanel.this.m_shapePoints.set(PlotPanel.this.m_shapePoints.size() - 1, tmp);
                                    }
                                    if (PlotPanel.this.m_shapes == null) {
                                        PlotPanel.this.m_shapes = new ArrayList(4);
                                    }
                                    PlotPanel.this.m_shapes.add(PlotPanel.this.m_shapePoints);
                                    VisualizePanel.this.m_submit.setText("Submit");
                                    VisualizePanel.this.m_submit.setActionCommand("Submit");
                                    VisualizePanel.this.m_submit.setEnabled(true);
                                }
                                PlotPanel.this.m_shapePoints = null;
                                PlotPanel.this.repaint();
                            } else {
                                PlotPanel.this.m_createShape = false;
                                if (PlotPanel.this.m_shapePoints.size() >= 7) {
                                    PlotPanel.this.m_shapePoints.add(PlotPanel.this.m_shapePoints.get(1));
                                    PlotPanel.this.m_shapePoints.add(PlotPanel.this.m_shapePoints.get(2));
                                    if (PlotPanel.this.m_shapes == null) {
                                        PlotPanel.this.m_shapes = new ArrayList(4);
                                    }
                                    PlotPanel.this.m_shapes.add(PlotPanel.this.m_shapePoints);
                                    VisualizePanel.this.m_submit.setText("Submit");
                                    VisualizePanel.this.m_submit.setActionCommand("Submit");
                                    VisualizePanel.this.m_submit.setEnabled(true);
                                }
                                PlotPanel.this.m_shapePoints = null;
                                PlotPanel.this.repaint();
                            }
                            g.dispose();
                        } else if ((e.getModifiers() & 0x10) == 16) {
                            PlotPanel.this.m_createShape = true;
                            PlotPanel.this.m_shapePoints = new ArrayList(17);
                            PlotPanel.this.m_shapePoints.add(new Double(PlotPanel.this.m_sIndex));
                            PlotPanel.this.m_shapePoints.add(new Double(PlotPanel.this.m_plot2D.convertToAttribX(e.getX())));
                            PlotPanel.this.m_shapePoints.add(new Double(PlotPanel.this.m_plot2D.convertToAttribY(e.getY())));
                            ((PlotPanel)PlotPanel.this).m_newMousePos.width = e.getX();
                            ((PlotPanel)PlotPanel.this).m_newMousePos.height = e.getY();
                            Graphics g = PlotPanel.this.m_plot2D.getGraphics();
                            g.setColor(Color.black);
                            g.setXORMode(Color.white);
                            g.drawLine((int)Math.ceil(PlotPanel.this.m_plot2D.convertToPanelX((Double)PlotPanel.this.m_shapePoints.get(1))), (int)Math.ceil(PlotPanel.this.m_plot2D.convertToPanelY((Double)PlotPanel.this.m_shapePoints.get(2))), ((PlotPanel)PlotPanel.this).m_newMousePos.width, ((PlotPanel)PlotPanel.this).m_newMousePos.height);
                            g.dispose();
                        }
                    } else if ((e.getModifiers() & 0x10) == 16) {
                        PlotPanel.this.m_plot2D.searchPoints(e.getX(), e.getY(), false);
                    } else {
                        PlotPanel.this.m_plot2D.searchPoints(e.getX(), e.getY(), true);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (PlotPanel.this.m_createShape && ((Double)PlotPanel.this.m_shapePoints.get(0)).intValue() == 1) {
                        PlotPanel.this.m_createShape = false;
                        Graphics g = PlotPanel.this.m_plot2D.getGraphics();
                        g.setColor(Color.black);
                        g.setXORMode(Color.white);
                        g.drawRect(((Double)PlotPanel.this.m_shapePoints.get(1)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(2)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(3)).intValue() - ((Double)PlotPanel.this.m_shapePoints.get(1)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(4)).intValue() - ((Double)PlotPanel.this.m_shapePoints.get(2)).intValue());
                        g.dispose();
                        if (PlotPanel.this.checkPoints((Double)PlotPanel.this.m_shapePoints.get(1), (Double)PlotPanel.this.m_shapePoints.get(2)) && PlotPanel.this.checkPoints((Double)PlotPanel.this.m_shapePoints.get(3), (Double)PlotPanel.this.m_shapePoints.get(4)) && (Double)PlotPanel.this.m_shapePoints.get(1) < (Double)PlotPanel.this.m_shapePoints.get(3) && (Double)PlotPanel.this.m_shapePoints.get(2) < (Double)PlotPanel.this.m_shapePoints.get(4)) {
                            if (PlotPanel.this.m_shapes == null) {
                                PlotPanel.this.m_shapes = new ArrayList(2);
                            }
                            PlotPanel.this.m_shapePoints.set(1, new Double(PlotPanel.this.m_plot2D.convertToAttribX((Double)PlotPanel.this.m_shapePoints.get(1))));
                            PlotPanel.this.m_shapePoints.set(2, new Double(PlotPanel.this.m_plot2D.convertToAttribY((Double)PlotPanel.this.m_shapePoints.get(2))));
                            PlotPanel.this.m_shapePoints.set(3, new Double(PlotPanel.this.m_plot2D.convertToAttribX((Double)PlotPanel.this.m_shapePoints.get(3))));
                            PlotPanel.this.m_shapePoints.set(4, new Double(PlotPanel.this.m_plot2D.convertToAttribY((Double)PlotPanel.this.m_shapePoints.get(4))));
                            PlotPanel.this.m_shapes.add(PlotPanel.this.m_shapePoints);
                            VisualizePanel.this.m_submit.setText("Submit");
                            VisualizePanel.this.m_submit.setActionCommand("Submit");
                            VisualizePanel.this.m_submit.setEnabled(true);
                            PlotPanel.this.repaint();
                        }
                        PlotPanel.this.m_shapePoints = null;
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (PlotPanel.this.m_createShape && ((Double)PlotPanel.this.m_shapePoints.get(0)).intValue() == 1) {
                        Graphics g = PlotPanel.this.m_plot2D.getGraphics();
                        g.setColor(Color.black);
                        g.setXORMode(Color.white);
                        g.drawRect(((Double)PlotPanel.this.m_shapePoints.get(1)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(2)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(3)).intValue() - ((Double)PlotPanel.this.m_shapePoints.get(1)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(4)).intValue() - ((Double)PlotPanel.this.m_shapePoints.get(2)).intValue());
                        PlotPanel.this.m_shapePoints.set(3, new Double(e.getX()));
                        PlotPanel.this.m_shapePoints.set(4, new Double(e.getY()));
                        g.drawRect(((Double)PlotPanel.this.m_shapePoints.get(1)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(2)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(3)).intValue() - ((Double)PlotPanel.this.m_shapePoints.get(1)).intValue(), ((Double)PlotPanel.this.m_shapePoints.get(4)).intValue() - ((Double)PlotPanel.this.m_shapePoints.get(2)).intValue());
                        g.dispose();
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (PlotPanel.this.m_createShape && (((Double)PlotPanel.this.m_shapePoints.get(0)).intValue() == 2 || ((Double)PlotPanel.this.m_shapePoints.get(0)).intValue() == 3)) {
                        Graphics g = PlotPanel.this.m_plot2D.getGraphics();
                        g.setColor(Color.black);
                        g.setXORMode(Color.white);
                        g.drawLine((int)Math.ceil(PlotPanel.this.m_plot2D.convertToPanelX((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 2))), (int)Math.ceil(PlotPanel.this.m_plot2D.convertToPanelY((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 1))), ((PlotPanel)PlotPanel.this).m_newMousePos.width, ((PlotPanel)PlotPanel.this).m_newMousePos.height);
                        ((PlotPanel)PlotPanel.this).m_newMousePos.width = e.getX();
                        ((PlotPanel)PlotPanel.this).m_newMousePos.height = e.getY();
                        g.drawLine((int)Math.ceil(PlotPanel.this.m_plot2D.convertToPanelX((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 2))), (int)Math.ceil(PlotPanel.this.m_plot2D.convertToPanelY((Double)PlotPanel.this.m_shapePoints.get(PlotPanel.this.m_shapePoints.size() - 1))), ((PlotPanel)PlotPanel.this).m_newMousePos.width, ((PlotPanel)PlotPanel.this).m_newMousePos.height);
                        g.dispose();
                    }
                }
            });
            VisualizePanel.this.m_submit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("Submit")) {
                        if (VisualizePanel.this.m_splitListener != null && PlotPanel.this.m_shapes != null) {
                            Instances sub_set1 = new Instances(PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances, 500);
                            Instances sub_set2 = new Instances(PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances, 500);
                            if (PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances != null) {
                                for (int noa = 0; noa < PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances.numInstances(); ++noa) {
                                    if (PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances.instance(noa).isMissing(PlotPanel.this.m_xIndex) || PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances.instance(noa).isMissing(PlotPanel.this.m_yIndex)) continue;
                                    if (PlotPanel.this.inSplit(PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances.instance(noa))) {
                                        sub_set1.add(PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances.instance(noa));
                                        continue;
                                    }
                                    sub_set2.add(PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances.instance(noa));
                                }
                                ArrayList tmp = PlotPanel.this.m_shapes;
                                PlotPanel.this.cancelShapes();
                                VisualizePanel.this.m_splitListener.userDataEvent(new VisualizePanelEvent(tmp, sub_set1, sub_set2, PlotPanel.this.m_xIndex, PlotPanel.this.m_yIndex));
                            }
                        } else if (PlotPanel.this.m_shapes != null && PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances != null) {
                            Instances sub_set1 = new Instances(PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances, 500);
                            int count = 0;
                            for (int noa = 0; noa < PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances.numInstances(); ++noa) {
                                if (!PlotPanel.this.inSplit(PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances.instance(noa))) continue;
                                sub_set1.add(PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances.instance(noa));
                                ++count;
                            }
                            int[] nSizes = null;
                            int[] nTypes = null;
                            int x = PlotPanel.this.m_xIndex;
                            int y = PlotPanel.this.m_yIndex;
                            if (PlotPanel.this.m_originalPlot == null) {
                                PlotPanel.this.m_originalPlot = PlotPanel.this.m_plot2D.getMasterPlot();
                            }
                            if (count > 0) {
                                nTypes = new int[count];
                                nSizes = new int[count];
                                count = 0;
                                for (int noa = 0; noa < PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances.numInstances(); ++noa) {
                                    if (!PlotPanel.this.inSplit(PlotPanel.this.m_plot2D.getMasterPlot().m_plotInstances.instance(noa))) continue;
                                    nTypes[count] = PlotPanel.this.m_plot2D.getMasterPlot().m_shapeType[noa];
                                    nSizes[count] = PlotPanel.this.m_plot2D.getMasterPlot().m_shapeSize[noa];
                                    ++count;
                                }
                            }
                            PlotPanel.this.cancelShapes();
                            PlotData2D newPlot = new PlotData2D(sub_set1);
                            try {
                                newPlot.setShapeSize(nSizes);
                                newPlot.setShapeType(nTypes);
                                PlotPanel.this.m_plot2D.removeAllPlots();
                                VisualizePanel.this.addPlot(newPlot);
                            }
                            catch (Exception ex) {
                                System.err.println(ex);
                                ex.printStackTrace();
                            }
                            try {
                                VisualizePanel.this.setXIndex(x);
                                VisualizePanel.this.setYIndex(y);
                            }
                            catch (Exception er) {
                                System.out.println("Error : " + er);
                            }
                        }
                    } else if (e.getActionCommand().equals("Reset")) {
                        int x = PlotPanel.this.m_xIndex;
                        int y = PlotPanel.this.m_yIndex;
                        PlotPanel.this.m_plot2D.removeAllPlots();
                        try {
                            VisualizePanel.this.addPlot(PlotPanel.this.m_originalPlot);
                        }
                        catch (Exception ex) {
                            System.err.println(ex);
                            ex.printStackTrace();
                        }
                        try {
                            VisualizePanel.this.setXIndex(x);
                            VisualizePanel.this.setYIndex(y);
                        }
                        catch (Exception er) {
                            System.out.println("Error : " + er);
                        }
                    }
                }
            });
            VisualizePanel.this.m_cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotPanel.this.cancelShapes();
                    PlotPanel.this.repaint();
                }
            });
        }

        protected void applySettings(Settings settings, String ownerID) {
            this.m_plot2D.applySettings(settings, ownerID);
            this.setBackground(this.m_plot2D.getBackground());
            this.repaint();
        }

        public void removeAllPlots() {
            this.m_plot2D.removeAllPlots();
            VisualizePanel.this.m_legendPanel.setPlotList(this.m_plot2D.getPlots());
        }

        public ArrayList<ArrayList<Double>> getShapes() {
            return this.m_shapes;
        }

        public void cancelShapes() {
            if (VisualizePanel.this.m_splitListener == null) {
                VisualizePanel.this.m_submit.setText("Reset");
                VisualizePanel.this.m_submit.setActionCommand("Reset");
                if (this.m_originalPlot == null || this.m_originalPlot.m_plotInstances == this.m_plotInstances) {
                    VisualizePanel.this.m_submit.setEnabled(false);
                } else {
                    VisualizePanel.this.m_submit.setEnabled(true);
                }
            } else {
                VisualizePanel.this.m_submit.setEnabled(false);
            }
            this.m_createShape = false;
            this.m_shapePoints = null;
            this.m_shapes = null;
            this.repaint();
        }

        public void setShapes(ArrayList<ArrayList<Double>> v) {
            if (v != null) {
                this.m_shapes = new ArrayList(v.size());
                for (int noa = 0; noa < v.size(); ++noa) {
                    ArrayList<Double> temp = new ArrayList<Double>(v.get(noa).size());
                    this.m_shapes.add(temp);
                    for (int nob = 0; nob < v.get(noa).size(); ++nob) {
                        temp.add(v.get(noa).get(nob));
                    }
                }
            } else {
                this.m_shapes = null;
            }
            this.repaint();
        }

        private boolean checkPoints(double x1, double y1) {
            return !(x1 < 0.0 || x1 > (double)this.getSize().width || y1 < 0.0) && !(y1 > (double)this.getSize().height);
        }

        public boolean inSplit(Instance i) {
            if (this.m_shapes != null) {
                for (int noa = 0; noa < this.m_shapes.size(); ++noa) {
                    ArrayList<Double> stmp = this.m_shapes.get(noa);
                    if (stmp.get(0).intValue() == 1) {
                        double x1 = stmp.get(1);
                        double y1 = stmp.get(2);
                        double x2 = stmp.get(3);
                        double y2 = stmp.get(4);
                        if (!(i.value(this.m_xIndex) >= x1) || !(i.value(this.m_xIndex) <= x2) || !(i.value(this.m_yIndex) <= y1) || !(i.value(this.m_yIndex) >= y2)) continue;
                        return true;
                    }
                    if (!(stmp.get(0).intValue() == 2 ? this.inPoly(stmp, i.value(this.m_xIndex), i.value(this.m_yIndex)) : stmp.get(0).intValue() == 3 && this.inPolyline(stmp, i.value(this.m_xIndex), i.value(this.m_yIndex)))) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean inPolyline(ArrayList<Double> ob, double x, double y) {
            double y2;
            double y1;
            int countx = 0;
            for (int noa = 1; noa < ob.size() - 4; noa += 2) {
                double change;
                y1 = ob.get(noa + 1);
                y2 = ob.get(noa + 3);
                double x1 = ob.get(noa);
                double x2 = ob.get(noa + 2);
                double vecy = y2 - y1;
                double vecx = x2 - x1;
                if (noa == 1 && noa == ob.size() - 6) {
                    if (vecy == 0.0 || !(vecx * (change = (y - y1) / vecy) + x1 >= x)) continue;
                    ++countx;
                    continue;
                }
                if (noa == 1) {
                    if (!(y < y2 && vecy > 0.0) && (!(y > y2) || !(vecy < 0.0)) || !(vecx * (change = (y - y1) / vecy) + x1 >= x)) continue;
                    ++countx;
                    continue;
                }
                if (noa == ob.size() - 6) {
                    if (!(y <= y1 && vecy < 0.0) && (!(y >= y1) || !(vecy > 0.0)) || !(vecx * (change = (y - y1) / vecy) + x1 >= x)) continue;
                    ++countx;
                    continue;
                }
                if (!(y1 <= y && y < y2) && (!(y2 < y) || !(y <= y1)) || vecy == 0.0 || !(vecx * (change = (y - y1) / vecy) + x1 >= x)) continue;
                ++countx;
            }
            y1 = ob.get(ob.size() - 2);
            if (y1 > (y2 = ob.get(ob.size() - 1).doubleValue())) {
                if (y1 >= y && y > y2) {
                    ++countx;
                }
            } else if (y1 >= y || y > y2) {
                ++countx;
            }
            return countx % 2 == 1;
        }

        private boolean inPoly(ArrayList<Double> ob, double x, double y) {
            int count = 0;
            for (int noa = 1; noa < ob.size() - 2; noa += 2) {
                double change;
                double vecy;
                double y1 = ob.get(noa + 1);
                double y2 = ob.get(noa + 3);
                if (!((y1 <= y && y < y2 || y2 < y && y <= y1) && (vecy = y2 - y1) != 0.0)) continue;
                double x1 = ob.get(noa);
                double x2 = ob.get(noa + 2);
                double vecx = x2 - x1;
                if (!(vecx * (change = (y - y1) / vecy) + x1 >= x)) continue;
                ++count;
            }
            return count % 2 == 1;
        }

        public void setJitter(int j) {
            this.m_plot2D.setJitter(j);
        }

        public void setXindex(int x) {
            if (x != this.m_xIndex) {
                this.cancelShapes();
            }
            this.m_xIndex = x;
            this.m_plot2D.setXindex(x);
            if (VisualizePanel.this.m_showAttBars) {
                VisualizePanel.this.m_attrib.setX(x);
            }
        }

        public void setYindex(int y) {
            if (y != this.m_yIndex) {
                this.cancelShapes();
            }
            this.m_yIndex = y;
            this.m_plot2D.setYindex(y);
            if (VisualizePanel.this.m_showAttBars) {
                VisualizePanel.this.m_attrib.setY(y);
            }
        }

        public void setCindex(int c) {
            this.m_cIndex = c;
            this.m_plot2D.setCindex(c);
            if (VisualizePanel.this.m_showAttBars) {
                VisualizePanel.this.m_attrib.setCindex(c, this.m_plot2D.getMaxC(), this.m_plot2D.getMinC());
            }
            VisualizePanel.this.m_classPanel.setCindex(c);
            this.repaint();
        }

        public void setSindex(int s) {
            if (s != this.m_sIndex) {
                this.m_shapePoints = null;
                this.m_createShape = false;
            }
            this.m_sIndex = s;
            this.repaint();
        }

        public void setMasterPlot(PlotData2D newPlot) throws Exception {
            this.m_plot2D.removeAllPlots();
            this.addPlot(newPlot);
        }

        public void addPlot(PlotData2D newPlot) throws Exception {
            if (this.m_plot2D.getPlots().size() == 0) {
                block12: {
                    this.m_plot2D.addPlot(newPlot);
                    if (VisualizePanel.this.m_plotSurround.getComponentCount() > 1 && VisualizePanel.this.m_plotSurround.getComponent(1) == VisualizePanel.this.m_attrib && VisualizePanel.this.m_showAttBars) {
                        try {
                            VisualizePanel.this.m_attrib.setInstances(newPlot.m_plotInstances);
                            VisualizePanel.this.m_attrib.setCindex(0);
                            VisualizePanel.this.m_attrib.setX(0);
                            VisualizePanel.this.m_attrib.setY(0);
                        }
                        catch (Exception ex) {
                            VisualizePanel.this.m_plotSurround.remove(VisualizePanel.this.m_attrib);
                            System.err.println("Warning : data contains more attributes than can be displayed as attribute bars.");
                            if (VisualizePanel.this.m_Log != null) {
                                VisualizePanel.this.m_Log.logMessage("Warning : data contains more attributes than can be displayed as attribute bars.");
                            }
                            break block12;
                        }
                    }
                    if (VisualizePanel.this.m_showAttBars) {
                        try {
                            VisualizePanel.this.m_attrib.setInstances(newPlot.m_plotInstances);
                            VisualizePanel.this.m_attrib.setCindex(0);
                            VisualizePanel.this.m_attrib.setX(0);
                            VisualizePanel.this.m_attrib.setY(0);
                            GridBagConstraints constraints = new GridBagConstraints();
                            constraints.fill = 1;
                            constraints.insets = new Insets(0, 0, 0, 0);
                            constraints.gridx = 4;
                            constraints.gridy = 0;
                            constraints.weightx = 1.0;
                            constraints.gridwidth = 1;
                            constraints.gridheight = 1;
                            constraints.weighty = 5.0;
                            VisualizePanel.this.m_plotSurround.add((Component)VisualizePanel.this.m_attrib, constraints);
                        }
                        catch (Exception ex) {
                            System.err.println("Warning : data contains more attributes than can be displayed as attribute bars.");
                            if (VisualizePanel.this.m_Log == null) break block12;
                            VisualizePanel.this.m_Log.logMessage("Warning : data contains more attributes than can be displayed as attribute bars.");
                        }
                    }
                }
                VisualizePanel.this.m_classPanel.setInstances(newPlot.m_plotInstances);
                this.plotReset(newPlot.m_plotInstances, newPlot.getCindex());
                if (newPlot.m_useCustomColour && VisualizePanel.this.m_showClassPanel) {
                    VisualizePanel.this.remove(VisualizePanel.this.m_classSurround);
                    this.switchToLegend();
                    VisualizePanel.this.m_legendPanel.setPlotList(this.m_plot2D.getPlots());
                    VisualizePanel.this.m_ColourCombo.setEnabled(false);
                }
            } else {
                if (!newPlot.m_useCustomColour && VisualizePanel.this.m_showClassPanel) {
                    VisualizePanel.this.add((Component)VisualizePanel.this.m_classSurround, "South");
                    VisualizePanel.this.m_ColourCombo.setEnabled(true);
                }
                if (this.m_plot2D.getPlots().size() == 1) {
                    this.switchToLegend();
                }
                this.m_plot2D.addPlot(newPlot);
                VisualizePanel.this.m_legendPanel.setPlotList(this.m_plot2D.getPlots());
            }
        }

        protected void switchToLegend() {
            if (VisualizePanel.this.m_plotSurround.getComponentCount() > 1 && VisualizePanel.this.m_plotSurround.getComponent(1) == VisualizePanel.this.m_attrib) {
                VisualizePanel.this.m_plotSurround.remove(VisualizePanel.this.m_attrib);
            }
            if (VisualizePanel.this.m_plotSurround.getComponentCount() > 1 && VisualizePanel.this.m_plotSurround.getComponent(1) == VisualizePanel.this.m_legendPanel) {
                return;
            }
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 1;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.gridx = 4;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weighty = 5.0;
            VisualizePanel.this.m_plotSurround.add((Component)VisualizePanel.this.m_legendPanel, constraints);
            this.setSindex(0);
            VisualizePanel.this.m_ShapeCombo.setEnabled(false);
        }

        protected void switchToBars() {
            block5: {
                if (VisualizePanel.this.m_plotSurround.getComponentCount() > 1 && VisualizePanel.this.m_plotSurround.getComponent(1) == VisualizePanel.this.m_legendPanel) {
                    VisualizePanel.this.m_plotSurround.remove(VisualizePanel.this.m_legendPanel);
                }
                if (VisualizePanel.this.m_plotSurround.getComponentCount() > 1 && VisualizePanel.this.m_plotSurround.getComponent(1) == VisualizePanel.this.m_attrib) {
                    return;
                }
                if (VisualizePanel.this.m_showAttBars) {
                    try {
                        VisualizePanel.this.m_attrib.setInstances(this.m_plot2D.getMasterPlot().m_plotInstances);
                        VisualizePanel.this.m_attrib.setCindex(0);
                        VisualizePanel.this.m_attrib.setX(0);
                        VisualizePanel.this.m_attrib.setY(0);
                        GridBagConstraints constraints = new GridBagConstraints();
                        constraints.fill = 1;
                        constraints.insets = new Insets(0, 0, 0, 0);
                        constraints.gridx = 4;
                        constraints.gridy = 0;
                        constraints.weightx = 1.0;
                        constraints.gridwidth = 1;
                        constraints.gridheight = 1;
                        constraints.weighty = 5.0;
                        VisualizePanel.this.m_plotSurround.add((Component)VisualizePanel.this.m_attrib, constraints);
                    }
                    catch (Exception ex) {
                        System.err.println("Warning : data contains more attributes than can be displayed as attribute bars.");
                        if (VisualizePanel.this.m_Log == null) break block5;
                        VisualizePanel.this.m_Log.logMessage("Warning : data contains more attributes than can be displayed as attribute bars.");
                    }
                }
            }
        }

        private void plotReset(Instances inst, int cIndex) {
            if (VisualizePanel.this.m_splitListener == null) {
                VisualizePanel.this.m_submit.setText("Reset");
                VisualizePanel.this.m_submit.setActionCommand("Reset");
                if (this.m_originalPlot == null || this.m_originalPlot.m_plotInstances == inst) {
                    VisualizePanel.this.m_submit.setEnabled(false);
                } else {
                    VisualizePanel.this.m_submit.setEnabled(true);
                }
            } else {
                VisualizePanel.this.m_submit.setEnabled(false);
            }
            this.m_plotInstances = inst;
            if (VisualizePanel.this.m_splitListener != null) {
                this.m_plotInstances.randomize(new Random());
            }
            this.m_xIndex = 0;
            this.m_yIndex = 0;
            this.m_cIndex = cIndex;
            this.cancelShapes();
        }

        public void setColours(ArrayList<Color> cols) {
            this.m_plot2D.setColours(cols);
            VisualizePanel.this.m_colorList = cols;
        }

        private void drawShapes(Graphics gx) {
            if (this.m_shapes != null) {
                for (int noa = 0; noa < this.m_shapes.size(); ++noa) {
                    int[] ar2;
                    int[] ar1;
                    ArrayList<Double> stmp = this.m_shapes.get(noa);
                    if (stmp.get(0).intValue() == 1) {
                        int x1 = (int)this.m_plot2D.convertToPanelX(stmp.get(1));
                        int y1 = (int)this.m_plot2D.convertToPanelY(stmp.get(2));
                        int x2 = (int)this.m_plot2D.convertToPanelX(stmp.get(3));
                        int y2 = (int)this.m_plot2D.convertToPanelY(stmp.get(4));
                        gx.setColor(Color.gray);
                        gx.fillRect(x1, y1, x2 - x1, y2 - y1);
                        gx.setColor(Color.black);
                        gx.drawRect(x1, y1, x2 - x1, y2 - y1);
                        continue;
                    }
                    if (stmp.get(0).intValue() == 2) {
                        ar1 = this.getXCoords(stmp);
                        ar2 = this.getYCoords(stmp);
                        gx.setColor(Color.gray);
                        gx.fillPolygon(ar1, ar2, (stmp.size() - 1) / 2);
                        gx.setColor(Color.black);
                        gx.drawPolyline(ar1, ar2, (stmp.size() - 1) / 2);
                        continue;
                    }
                    if (stmp.get(0).intValue() != 3) continue;
                    ArrayList<Double> tmp = this.makePolygon(stmp);
                    ar1 = this.getXCoords(tmp);
                    ar2 = this.getYCoords(tmp);
                    gx.setColor(Color.gray);
                    gx.fillPolygon(ar1, ar2, (tmp.size() - 1) / 2);
                    gx.setColor(Color.black);
                    gx.drawPolyline(ar1, ar2, (tmp.size() - 1) / 2);
                }
            }
            if (this.m_shapePoints != null && (this.m_shapePoints.get(0).intValue() == 2 || this.m_shapePoints.get(0).intValue() == 3)) {
                gx.setColor(Color.black);
                gx.setXORMode(Color.white);
                int[] ar1 = this.getXCoords(this.m_shapePoints);
                int[] ar2 = this.getYCoords(this.m_shapePoints);
                gx.drawPolyline(ar1, ar2, (this.m_shapePoints.size() - 1) / 2);
                this.m_newMousePos.width = (int)Math.ceil(this.m_plot2D.convertToPanelX(this.m_shapePoints.get(this.m_shapePoints.size() - 2)));
                this.m_newMousePos.height = (int)Math.ceil(this.m_plot2D.convertToPanelY(this.m_shapePoints.get(this.m_shapePoints.size() - 1)));
                gx.drawLine((int)Math.ceil(this.m_plot2D.convertToPanelX(this.m_shapePoints.get(this.m_shapePoints.size() - 2))), (int)Math.ceil(this.m_plot2D.convertToPanelY(this.m_shapePoints.get(this.m_shapePoints.size() - 1))), this.m_newMousePos.width, this.m_newMousePos.height);
                gx.setPaintMode();
            }
        }

        private double[] lineIntersect(double x1, double y1, double x2, double y2, double x, double y, double offset) {
            double xn = -100.0;
            double yn = -100.0;
            if (x == 0.0) {
                if (x1 <= offset && offset < x2 || x1 >= offset && offset > x2) {
                    double xval = x1 - x2;
                    double change = (offset - x2) / xval;
                    yn = (y1 - y2) * change + y2;
                    xn = 0.0 <= yn && yn <= y ? offset : -100.0;
                }
            } else if (y == 0.0 && (y1 <= offset && offset < y2 || y1 >= offset && offset > y2)) {
                double yval = y1 - y2;
                double change = (offset - y2) / yval;
                xn = (x1 - x2) * change + x2;
                if (0.0 <= xn && xn <= x) {
                    yn = offset;
                } else {
                    xn = -100.0;
                }
            }
            double[] ret = new double[]{xn, yn};
            return ret;
        }

        private ArrayList<Double> makePolygon(ArrayList<Double> v) {
            ArrayList<Double> building;
            block28: {
                int yp;
                int xp;
                int edge2;
                int edge1;
                block27: {
                    double[] new_coords;
                    building = new ArrayList<Double>(v.size() + 10);
                    edge1 = 0;
                    edge2 = 0;
                    for (int noa = 0; noa < v.size() - 2; ++noa) {
                        building.add(new Double(v.get(noa)));
                    }
                    double x1 = this.m_plot2D.convertToPanelX(v.get(1));
                    double y1 = this.m_plot2D.convertToPanelY(v.get(2));
                    double x2 = this.m_plot2D.convertToPanelX(v.get(3));
                    double y2 = this.m_plot2D.convertToPanelY(v.get(4));
                    if (x1 < 0.0) {
                        new_coords = this.lineIntersect(x1, y1, x2, y2, 0.0, this.getHeight(), 0.0);
                        edge1 = 0;
                        if (new_coords[0] < 0.0) {
                            if (y1 < 0.0) {
                                new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, 0.0);
                                edge1 = 1;
                            } else {
                                new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, this.getHeight());
                                edge1 = 3;
                            }
                        }
                    } else if (x1 > (double)this.getWidth()) {
                        new_coords = this.lineIntersect(x1, y1, x2, y2, 0.0, this.getHeight(), this.getWidth());
                        edge1 = 2;
                        if (new_coords[0] < 0.0) {
                            if (y1 < 0.0) {
                                new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, 0.0);
                                edge1 = 1;
                            } else {
                                new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, this.getHeight());
                                edge1 = 3;
                            }
                        }
                    } else if (y1 < 0.0) {
                        new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, 0.0);
                        edge1 = 1;
                    } else {
                        new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, this.getHeight());
                        edge1 = 3;
                    }
                    building.set(1, new Double(this.m_plot2D.convertToAttribX(new_coords[0])));
                    building.set(2, new Double(this.m_plot2D.convertToAttribY(new_coords[1])));
                    x1 = this.m_plot2D.convertToPanelX(v.get(v.size() - 4));
                    y1 = this.m_plot2D.convertToPanelY(v.get(v.size() - 3));
                    x2 = this.m_plot2D.convertToPanelX(v.get(v.size() - 6));
                    y2 = this.m_plot2D.convertToPanelY(v.get(v.size() - 5));
                    if (x1 < 0.0) {
                        new_coords = this.lineIntersect(x1, y1, x2, y2, 0.0, this.getHeight(), 0.0);
                        edge2 = 0;
                        if (new_coords[0] < 0.0) {
                            if (y1 < 0.0) {
                                new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, 0.0);
                                edge2 = 1;
                            } else {
                                new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, this.getHeight());
                                edge2 = 3;
                            }
                        }
                    } else if (x1 > (double)this.getWidth()) {
                        new_coords = this.lineIntersect(x1, y1, x2, y2, 0.0, this.getHeight(), this.getWidth());
                        edge2 = 2;
                        if (new_coords[0] < 0.0) {
                            if (y1 < 0.0) {
                                new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, 0.0);
                                edge2 = 1;
                            } else {
                                new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, this.getHeight());
                                edge2 = 3;
                            }
                        }
                    } else if (y1 < 0.0) {
                        new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, 0.0);
                        edge2 = 1;
                    } else {
                        new_coords = this.lineIntersect(x1, y1, x2, y2, this.getWidth(), 0.0, this.getHeight());
                        edge2 = 3;
                    }
                    building.set(building.size() - 2, new Double(this.m_plot2D.convertToAttribX(new_coords[0])));
                    building.set(building.size() - 1, new Double(this.m_plot2D.convertToAttribY(new_coords[1])));
                    xp = this.getWidth() * (edge2 & 1 ^ (edge2 & 2) / 2);
                    yp = this.getHeight() * ((edge2 & 2) / 2);
                    if (!this.inPolyline(v, this.m_plot2D.convertToAttribX(xp), this.m_plot2D.convertToAttribY(yp))) break block27;
                    building.add(new Double(this.m_plot2D.convertToAttribX(xp)));
                    building.add(new Double(this.m_plot2D.convertToAttribY(yp)));
                    int noa = (edge2 + 1) % 4;
                    while (noa != edge1) {
                        xp = this.getWidth() * (noa & 1 ^ (noa & 2) / 2);
                        yp = this.getHeight() * ((noa & 2) / 2);
                        building.add(new Double(this.m_plot2D.convertToAttribX(xp)));
                        building.add(new Double(this.m_plot2D.convertToAttribY(yp)));
                        noa = (noa + 1) % 4;
                    }
                    break block28;
                }
                xp = this.getWidth() * ((edge2 & 2) / 2);
                yp = this.getHeight() * (1 & ~(edge2 & 1 ^ (edge2 & 2) / 2));
                if (!this.inPolyline(v, this.m_plot2D.convertToAttribX(xp), this.m_plot2D.convertToAttribY(yp))) break block28;
                building.add(new Double(this.m_plot2D.convertToAttribX(xp)));
                building.add(new Double(this.m_plot2D.convertToAttribY(yp)));
                int noa = (edge2 + 3) % 4;
                while (noa != edge1) {
                    xp = this.getWidth() * ((noa & 2) / 2);
                    yp = this.getHeight() * (1 & ~(noa & 1 ^ (noa & 2) / 2));
                    building.add(new Double(this.m_plot2D.convertToAttribX(xp)));
                    building.add(new Double(this.m_plot2D.convertToAttribY(yp)));
                    noa = (noa + 3) % 4;
                }
            }
            return building;
        }

        private int[] getXCoords(ArrayList<Double> v) {
            int cach = (v.size() - 1) / 2;
            int[] ar = new int[cach];
            for (int noa = 0; noa < cach; ++noa) {
                ar[noa] = (int)this.m_plot2D.convertToPanelX(v.get(noa * 2 + 1));
            }
            return ar;
        }

        private int[] getYCoords(ArrayList<Double> v) {
            int cach = (v.size() - 1) / 2;
            int[] ar = new int[cach];
            for (int noa = 0; noa < cach; ++noa) {
                ar[noa] = (int)this.m_plot2D.convertToPanelY(v.get(noa * 2 + 2));
            }
            return ar;
        }

        @Override
        public void prePlot(Graphics gx) {
            super.paintComponent(gx);
            if (this.m_plotInstances != null) {
                this.drawShapes(gx);
            }
        }
    }
}

