% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmzMLFunctions.R
\name{tmzmlMaker}
\alias{tmzmlMaker}
\title{Maker of tmzML documents}
\usage{
tmzmlMaker(input_filename, output_filename = NULL, verbosity = 0, binwidth = 3)
}
\arguments{
\item{input_filename}{Character vector of length 1 with the name of the file
to be converted. Can only handle
mzML and mzXML currently - other formats should be converted to one of
these first, using (for example) Proteowizard's msconvert tool.}

\item{output_filename}{The name of the file that will be written out. Should
end in ".tmzML" and will throw a warning otherwise. Often, it makes sense
to have two folders in a working directory, one containing the original
mzML files and a second, parallel folder for the tmzMLs.}

\item{verbosity}{Numeric value between 0 and 2, corresponding to level of
verbosity shared by the function as it proceeds. 0 means no output, 1 will
produce mile markers after file opening, MS1 and MS2 conversion, and 2 will
provide progress bars between each mile marker.}

\item{binwidth}{Numeric value controlling the width of the bins in m/z space to create. Because MS data
is created in such a way that m/z values are continuous, they must be binned
together to create a discrete representation that can be searched efficiently.
Lower values (0.1-1) will have faster retrieval times, while higher values (5-10)
will have faster conversion times.}
}
\value{
An msdata_connection object. This object behaves exactly like a normal
RaMS list with values for MS1, MS2, etc. but secretly just contains pointers
to the files requested because the data is extracted on the fly. The S3
msdata_connection object is necessary to create new behaviors for `$` and `[` that
allow indexing like normal.
}
\description{
This function converts mzML and mzXML documents into "transposed" mzML
(tmzML) documents. Traditional mass-spec data is organized by scan number,
corresponding to retention time, but this isn't always the most sensible
format. Often, it makes more sense to organize a mass-spec file by m/z ratio
instead. This allows parsers to scan and decode a much smaller portion of
the file when searching for a specific mass, as opposed to the traditional
format which requires that every scan be opened, searched, and subset. The
tmzML document implements this strategy and allows the creation of MS object
representations that use essentially zero memory because the data is read
off the disk instead of being stored in RAM. RaMS has been designed to
interface with these new file types identically to traditional files,
allowing all your favorite tidyverse tricks to work just as well and much
more quickly.
}
\examples{
\dontrun{
sample_dir <- system.file("extdata", package = "RaMS")
sample_files <- list.files(sample_dir, full.names=TRUE, pattern="LB.*mzML")
tmzml_filenames <- gsub(x=sample_files, "\\\\.mzML.gz", ".tmzML")

# Convert a single file
tmzmlMaker(sample_files[1], tmzml_filenames[1])
file_data <- grabMSdata(tmzml_filenames[1], grab_what="everything", verbosity=2)
file_data$MS1[mz\%between\%pmppm(118.0865)]

# Multiple files
mapply(tmzmlMaker, sample_files, tmzml_filenames)
file_data <- grabMSdata(tmzml_filenames, grab_what="everything", verbosity=2)
betaine_data <- file_data$MS1[mz\%between\%pmppm(118.0865)]

# Plot output
plot(betaine_data$rt, betaine_data$int, type="l")
library(ggplot2)
ggplot(betaine_data) + geom_line(aes(x=rt, y=int, color=filename))

# Clean up afterward
file.remove(tmzml_filenames)
}
}
