% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{plotexpmap}
\alias{plotexpmap}
\title{Highlighting gene expression in the t-SNE map}
\usage{
plotexpmap(object, g, n = NULL, logsc = FALSE, imputed = FALSE,
  fr = FALSE, cells = NULL, cex = 1, map = TRUE, leg = TRUE)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{g}{Individual gene name or vector with a group of gene names corresponding to a subset of valid row names of the \code{ndata} slot
of the \code{SCseq} object.}

\item{n}{String of characters representing the title of the plot. Default is \code{NULL} and the first element of \code{g} is chosen.}

\item{logsc}{logical. If \code{TRUE}, then gene expression values are log2-transformed after adding a pseudo-count of 0.1. Default is \code{FALSE}
and untransformed values are shown.}

\item{imputed}{logical. If \code{TRUE} and imputing was done by calling \code{compdist} with \code{knn > 0}, then imputed expression values are shown. If \code{FALSE}, then raw counts are shown. Default is \code{FALSE}.}

\item{fr}{logical. If \code{TRUE} then plot t-SNE map, else plot Fruchterman-Rheingold layout.}

\item{cells}{Vector of valid cell names corresponding to column names of slot \code{ndata} of the \code{SCseq} object. Gene expression is ony shown for
this subset.}

\item{cex}{size of data points. Default value is 1.}

\item{map}{logical. If \code{TRUE} then data points are shown. Default value is \code{TRUE}.}

\item{leg}{logical. If \code{TRUE} then the legend is shown. Default value is \code{TRUE}.}
}
\value{
None
}
\description{
This functions highlights gene expression in a two-dimensional t-SNE map or a Fruchterman-Rheingold graph layout
of the singe-cell transcriptome data.
}
