% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{fitNBtb}
\alias{fitNBtb}
\title{Function for fitting a negative binomial noise model of technical and biological variability}
\usage{
fitNBtb(z, gamma = 2, x0 = 0, lower = 0, upper = 100, grad = TRUE)
}
\arguments{
\item{z}{Transcript count matrix with cells as columns and genes as rows.}

\item{gamma}{Positive real number. Scale paramter of the cauchy prior. Default is 2.}

\item{x0}{Real number greater or equal to zero. Location parameter of the cauchy prior.}

\item{lower}{Real number greater or equal to zero. Lower bound for the maximum a posterior inference of the biological noise. Default is 0.}

\item{upper}{Real number greater or equal to zero. Upper bound for the maximum a posterior inference of the biological noise. Default is 100.}

\item{grad}{Logical. If \code{TRUE} then maximum a posterior value is inferred by determining the root of the gradient function. Otherwise, the maximum of the posterior probability is determined numerically. Default is \code{TRUE}.}
}
\value{
Data.frame with four columns:
\item{mu}{Mean expression.}
\item{epsilon}{Biological noise.}
\item{rt}{Dispersion parameter capturing global cell-to-cell variability of transcript counts.}
\item{alphaG}{Dispersion parameter capturing global cell-to-cell variability of transcript counts and biological noise.}
}
\description{
This function fits a negative binomial model to transcript counts of a group of cells thereby deconvoluting variability into sampling noise, global cell-to-cell variability of transcript counts, and residual variability, which corresponds to biological noise.
}
