% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\title{Plot of experimental and simulated profile inventories}
\arguments{
\item{data1}{Character. Read input data in CSV format.}

\item{data2}{Filtered values of data1 for the current 'id'.}

\item{dir1}{directory. Temporary working directory where the '_num.txt' and '_exp.txt' files were created.}

\item{dir2}{directory. Current working directory.}

\item{AxisMaxValue}{daximum value to determine the x axis limit. Only used if the user wants to escalate all the simulated profiles .}

\item{cell_value}{Unit cell size in meters.}
}
\value{
A "results" folder in "dir2" containing "n" plots saved as PNG files, where "n" corresponds to the number of "id" entries defined in "data2". Additionally, a summary TXT file is saved in the results folder.
}
\description{
The "plot" function generates two plots for each profile defined in the input data: one representing the experimental inventory and the other representing the simulated inventory. This function is automatically executed when you run RadEro_run. It creates a "results" folder in the current directory if it does not already exist.
}
