% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_config.R
\name{resample_config}
\alias{resample_config}
\title{Resample Configuration Data}
\usage{
resample_config(data2, config1, dir1)
}
\arguments{
\item{data2}{Input data by ID. The input data to be resampled or transformed.}

\item{config1}{Input configuration. Configuration details that dictate how the data should be processed, including resampling methods, filters, and other transformation rules.}

\item{dir1}{Temporal directory. Path to the folder where output config file should be saved.}
}
\value{
A modified version of "config1" named "_config.js" that will be read by the C model.
}
\description{
"resample_config" adjusts and modifies a input configuration file based on the input data. The function resamples, filters and restructures data according to the parameters passed in the configuration file. It also interacts with a directory specified by the user for output.
}
\details{
This function takes three arguments: a dataset ("data2"), a configuration object ("config1"), and a directory path ("dir1"). The function applies resampling methods to the data as specified by "config1". The resampled data is typically saved to the provided directory.
}
