% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repro_stages.R
\name{repro_stages}
\alias{repro_stages}
\title{Identify which stages in a matrix population model are reproductive}
\usage{
repro_stages(matR, na_handling = "return.true")
}
\arguments{
\item{matR}{The reproductive component of a matrix population model (i.e. a
square projection matrix reflecting transitions due to reproduction; either
sexual (e.g. \code{matF}), clonal (e.g. \code{matC}), or both).}

\item{na_handling}{One of \code{"return.na"}, \code{"return.true"}, or
\code{"return.false"}. Determines how values of \code{NA} within
\code{matR} should be handled. See Value for more details.}
}
\value{
A logical vector of length \code{ncol(matR)}, with values of
  \code{FALSE} corresponding to non-reproductive stages and values of
  \code{TRUE} corresponding to reproductive stages.\cr\cr For a given matrix
  stage (i.e. column of \code{matR}), if there are any positive values of
  reproduction, the function will return \code{TRUE}. However, for a given
  stage, if there are no positive values of reproduction and one or more values
  of \code{NA}, the function will return \code{NA} if \code{na_handling ==
  "return.na"}, \code{TRUE} if \code{na_handling == "return.true"}, or
  \code{FALSE} if \code{na_handling == "return.false"}.
}
\description{
Takes a reproductive matrix and returns a vector of logical values (TRUE/FALSE)
indicating which stages are reproductive (i.e. exhibit any positive values for
reproduction). This function is a preparatory step to collapsing the matrix
model into a standardized set of stage classes using the function \code{\link{mpm_standardize}}.
}
\examples{
matR1 <- rbind(c( 0, 0.2,   0, 0.5),
               c( 0, 0.3,   0, 0.6),
               c( 0,   0,   0,   0),
               c( 0,   0,   0,   0))

matR2 <- rbind(c(NA,  NA,  NA, 1.1),
               c( 0,   0, 0.3, 0.7),
               c( 0,   0,   0,   0),
               c( 0,   0,   0,   0))

repro_stages(matR1)

# compare different methods for handling NA
repro_stages(matR2, na_handling = "return.na")
repro_stages(matR2, na_handling = "return.true")
repro_stages(matR2, na_handling = "return.false")
}
\seealso{
Other transformation: 
\code{\link{mpm_collapse}()},
\code{\link{mpm_rearrange}()},
\code{\link{mpm_split}()},
\code{\link{mpm_standardize}()},
\code{\link{name_stages}()},
\code{\link{standard_stages}()}
}
\author{
Rob Salguero-Gomez <rob.salguero@zoo.ox.ac.uk>

Patrick Barks <patrick.barks@gmail.com>
}
\concept{transformation}
