% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankPlot.R
\name{RankPlot}
\alias{RankPlot}
\title{Figure containing a plot of ranking data.}
\usage{
RankPlot(
  est,
  se,
  names,
  refName = NULL,
  confLevel = 0.9,
  plotType = c("individual", "difference", "comparison", "columns"),
  tiers = 1,
  GH = FALSE,
  Bonferroni = ifelse(plotType == "individual", "none", "demi"),
  tikzText = FALSE,
  cex = 1,
  tickWidth = NULL,
  rangeFactor = 1.2,
  textPad = 0,
  legendX = "topleft",
  legendY = NULL,
  legendText = NULL,
  lwdReg = 1,
  lwdBold = 3,
  thetaLine = 1,
  xlim = NULL,
  multcomp.type = c("bonferroni", "independence")
)
}
\arguments{
\item{est, se}{Vectors containing the point estimate and its standard error
for each area.}

\item{names}{Vector containing the name of each area.
Abbreviations may be preferable to full names
(e.g. "CO" instead of "Colorado")
since these names will be displayed directly on the plot.}

\item{refName}{String containing the name of the reference area;
must be one of the values in \code{names}.
Required for \code{plotType = c("difference", "comparison")}.
Optional for \code{plotType = "individual"} (where it only determines
the row above/below which the \code{names} are plotted to the right/left
of the intervals; if unspecified, defaults to median rank);
or for \code{plotType = "columns"} (where it selects one column
to be highlighted by vertical lines, if specified).}

\item{confLevel}{Number between 0 and 1: confidence level for individual
(uncorrected) hypothesis tests and/or confidence intervals. E.g. with
\code{plotType = "individual"}, \code{confLevel = 0.9} will plot
individual 90\% confidence intervals. If using \code{GH = TRUE}
and/or \code{Bonferroni != "none"}, the Goldstein-Healy and/or Bonferroni/Independence
corrections will be applied to the \code{confLevel} baseline.}

\item{plotType}{Which type of ranking plot to use. See vignettes for
examples and details.
\itemize{
\item \code{"individual"} is used for usual individual
confidence intervals, with or without Goldstein-Healy adjustment and/or
(demi or full) Bonferroni/Independence corrections.
\item \code{"difference"} shows confidence intervals for the differences
between the reference area \code{refName} and all other areas.
\item \code{"comparison"} also compares the reference area \code{refName}
to all others, but using the "comparison intervals"
of Almond et al. (2000).
\item \code{"columns"} plots a grid of shaded columns, where each column
uses shading to report demi-Bonferroni/Independence-corrected significance tests
for comparing the reference area (labeled at the bottom of the column)
with all other areas.
}}

\item{tiers}{Numeric, either 1 for usual confidence intervals,
or 2 for two-tiered intervals. 2 can only be used with
\code{plotType = "individual"}, when either \code{GH = TRUE}
or \code{Bonferroni != "none"} or both.
In that case, the "inner tiers" run between each interval's cross-bars,
and the "outer tiers" run past the cross-bars
all the way to the ends of each interval.
One of the tiers will show uncorrected
\code{confLevel*100}\% confidence intervals,
and the other tier will show the Goldstein-Healy and/or Bonferroni/Independence
adjusted intervals. A legend will show which tier is which;
usually Goldstein-Healy alone gives shorter intervals (inner tier),
but Bonferroni/Independence corrections make them into longer intervals (outer tier).}

\item{GH}{Logical, for whether or not to plot adjusted
confidence intervals at an "average" \code{confLevel*100}\%
confidence level as in Goldstein and Healy (1995).
Can only be used with \code{plotType = "individual"}.}

\item{Bonferroni}{Whether and how to correct for multiple comparisons by a
Bonferroni or Independence correction to the confidence level of the tests or intervals.
\code{"none"} performs no correction; \code{"demi"} corrects for
comparing one reference area to all \code{n-1} other areas; and
\code{"full"} corrects for comparing all possible \code{choose(n-1, 2)}
pairs of areas.
If \code{GH = TRUE}, the Goldstein-Healy adjustment
is performed first, and any Bonferroni/Independence correction is applied afterwards.
Settings \code{"none"} and \code{"full"} can only be used
with \code{plotType = "individual"};
all other plot types use the setting \code{"demi"}.
(For now, use the \code{multcomp.type} argument to specify whether the correction
should rely on Bonferroni (default) or on an assumption of Independence.
In the future, this package will be refactored
so that the multiple-comparisons arguments are better named!)}

\item{tikzText}{Logical, for whether or not to format text for tikz plotting.}

\item{cex}{\strong{C}haracter \strong{ex}pansion factor for
the points use to plot each area's point estimate, and for the
text used to plot each area's name next to its interval.}

\item{tickWidth}{Numeric height of the cross-bars on interval endpoints
(or inner tiers, if \code{tiers = 2}). The function tries to leave
a reasonable amount of space between intervals plotted in different rows,
but sometimes it may help to adjust \code{tickWidth} manually.}

\item{rangeFactor}{Numeric multiple by which to expand the range of the data
when setting the x-axis limits. The function tries to leave sufficient room
for plotting margins of error and names next to each area,
but sometimes it may help to adjust \code{rangeFactor} manually.}

\item{textPad}{Numeric amount by which to shift the text of \code{names}
past the interval endpoints when plotting. Positive values shift outwards
(towards the edges of the plot); negative values shift inwards.}

\item{legendX, legendY}{The x and y co-ordinates used to position the legend;
see \code{\link{legend}} for details on specifying \code{x} by keyword.}

\item{legendText}{String, or string vector, with legend text. By default,
each plot type adds informative legend text, but the user may override.
To remove legends entirely, set \code{legendText=NA}.}

\item{lwdReg}{Positive number for the line width of regular lines.
Used for all intervals when \code{plotType = "individual"},
or for intervals not significantly different from the reference area
when \code{plotType = c("difference", "comparison")}.}

\item{lwdBold}{Positive number for the line width of bold lines.
Used for intervals significantly different from the reference area
when \code{plotType = c("difference", "comparison")}.}

\item{thetaLine}{Number for how many lines below bottom axis to display
"theta" or other default x-axis labels (which depend on \code{plotType}).}

\item{xlim}{Vector of 2 numbers for x-axis limits. If \code{NULL},
will be automatically set using range of data
expanded by \code{rangeFactor}.}

\item{multcomp.type}{Whether multiple comparison corrects should use a
Bonferroni correction (\code{"bonferroni"})
or an independence-based correction (\code{"independence"}).
See Section 4 of the paper "A Joint Confidence Region..." (2020, JRSS-C)
for the difference in these two corrections.
(In the future, this package will be refactored
so that the multiple-comparisons arguments are better named!)}
}
\description{
\code{RankPlot} creates a figure with a plot of ranking data,
  from among several options for showing uncertainty in the ranked estimates.
  This function is meant for use within \code{\link{RankPlotWithTable}},
  which draws a ranking table aligned with this plot of the data
  in one combined figure.
}
\details{
Users may wish to modify this code and write
  their own plot function, which can be swapped into \code{figureFunction}
  within \code{\link{RankPlotWithTable}}. Be aware that
  \code{RankPlotWithTable} uses \code{\link{layout}} to arrange
  the table and plot side-by-side, so \code{layout} cannot be used within
  a new \code{figureFunction}.

See Goldstein and Healy (1995) for details on the
  "average" confidence level procedure used when \code{GH = TRUE}.
  See Almond et al. (2000) for details
  on the "comparison intervals" procedure.
}
\examples{
# Plot of 90\% confidence intervals for differences
# between each state and Colorado, with demi-Bonferroni correction,
# for US states' mean travel times to work, from the 2011 ACS
data(TravelTime2011)
with(TravelTime2011,
     RankPlot(est = Estimate.2dec, se = SE.2dec,
              names = Abbreviation, refName = "CO",
              confLevel = 0.90, cex = 0.6,
              plotType = "difference"))
}
\references{
Almond, R.G., Lewis, C., Tukey, J.W., and Yan, D. (2000).
  "Displays for Comparing a Given State to Many Others,"
  \emph{The American Statistician}, vol. 54, no. 2, 89-93.

  Goldstein, H. and Healy, M.J.R. (1995). "The Graphical Presentation of a
  Collection of Means," \emph{JRSS A}, vol. 158, no. 1, 175-177.
}
\seealso{
\code{\link{RankPlotWithTable}} and \code{\link{RankTable}}.
}
