% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rchoice.R, R/Rchoice.methods.R
\name{Rchoice}
\alias{Rchoice}
\alias{coef.Rchoice}
\alias{df.residual.Rchoice}
\alias{fitted.Rchoice}
\alias{logLik.Rchoice}
\alias{model.matrix.Rchoice}
\alias{nObs.Rchoice}
\alias{ordinal}
\alias{print.Rchoice}
\alias{print.summary.Rchoice}
\alias{residuals.Rchoice}
\alias{summary.Rchoice}
\alias{terms.Rchoice}
\alias{update.Rchoice}
\title{Estimate discrete choice model with random parameters}
\usage{
Rchoice(formula, data, subset, weights, na.action, family, start = NULL,
  ranp = NULL, R = 40, haltons = NA, seed = 10, correlation = FALSE,
  panel = FALSE, index = NULL, mvar = NULL, print.init = FALSE,
  init.ran = 0.1, gradient = TRUE, ...)

\method{terms}{Rchoice}(x, ...)

\method{model.matrix}{Rchoice}(object, ...)

\method{coef}{Rchoice}(object, ...)

\method{nObs}{Rchoice}(x, ...)

\method{fitted}{Rchoice}(object, ...)

\method{residuals}{Rchoice}(object, ...)

\method{df.residual}{Rchoice}(object, ...)

\method{update}{Rchoice}(object, new, ...)

\method{logLik}{Rchoice}(object, ...)

\method{print}{Rchoice}(x, digits = max(3, getOption("digits") - 3),
  width = getOption("width"), ...)

\method{summary}{Rchoice}(object, ...)

\method{print}{summary.Rchoice}(x, digits = max(3, getOption("digits") - 3),
  width = getOption("width"), ...)
}
\arguments{
\item{formula}{a symbolic description of the model to be estimated. The \code{formula} consists in two parts. The first one is reserved for standard variables with fixed and random parameters. The second one is reserved for variables that enter in the mean of the random parameters. See for example \code{\link{rFormula}},}

\item{data}{the data. It may be a \code{pdata.frame} object or an ordinary \code{data.frame},}

\item{subset}{an optional vector specifying a subset of observations,}

\item{weights}{an optional vector of weigths,}

\item{na.action}{a function wich indicated what should happen when the data
contains \code{NA}'s,}

\item{family}{the distribution to be used. It might be \code{family = binomial("probit")} for a Probit Model, \code{family = binomial("logit")} for a Logit model, \code{family = ordinal("probit")} for an Ordered Probit Model, \code{family = ordinal("logit")} for a Ordered Logit Model for an Ordered Logit Model, and  \code{family = "poisson"} for a Poisson Model,}

\item{start}{a vector of starting values,}

\item{ranp}{a named vector whose names are the random parameters and values the distribution:
"\code{n}" for normal, "\code{ln}" for log-normal, "\code{cn}" for truncated normal, "\code{u}" for uniform, "\code{t}" for triangular, "\code{sb}" for Johnson Sb,}

\item{R}{the number of draws if \code{ranp} is not \code{NULL},}

\item{haltons}{only relevant if \code{ranp} is not \code{NULL}. If not \code{NULL}, halton sequence is used
instead of pseudo-random numbers. If \code{haltons=NA}, some default values are used for
the prime of the sequence and for the number of element dropped. Otherwise, \code{haltons} should
be a list with elements \code{prime} and \code{drop},}

\item{seed}{the seed for the pseudo-random draws. This is only relevant if \code{haltons = NULL},}

\item{correlation}{only relevant if \code{ranp} is not \code{NULL}. If \code{TRUE}, the correlation between random parameters is taken into account,}

\item{panel}{if \code{TRUE} a panel data model is estimated,}

\item{index}{a string indicating the `id' for individuals in the data. This argument is not required if data is a \code{pdata.frame} object,}

\item{mvar}{only valid if \code{ranp} is not \code{NULL}. This is a named list, where the names correspond to the variables with random parameters, and the values correspond to the variables that enter in the mean of each random parameters,}

\item{print.init}{if \code{TRUE}, the initial values for the optimization procedure are printed,}

\item{init.ran}{initial values for standard deviation of random parameters. Default is 0.1,}

\item{gradient}{if \code{FALSE}, numerical gradients are used for the optimization procedure of models with random parameters,}

\item{...}{further arguments passed to \code{\link[maxLik]{maxLik}},}

\item{x, object}{and object of class \code{Rchoice},}

\item{new}{an updated formula for the update method,}

\item{digits}{number of digits,}

\item{width}{width,}
}
\value{
An object of class ``\code{Rchoice}'', a list elements:
\item{coefficients}{the named vector of coefficients,}
\item{family}{type of model,}
\item{link}{distribution of the errors,}
\item{logLik}{a set of values of the maximum likelihood procedure,}   
\item{mf}{the model framed used,} 
\item{formula}{the formula (a Formula object),}
\item{time}{\code{proc.time()} minus the start time,}
\item{freq}{frequency of dependent variable,}
\item{draws}{type of draws used,}
\item{R.model}{\code{TRUE} if a random parameter model is fitted,}
\item{R}{number of draws used,}
\item{bi}{an array of dimension \eqn{N \times R \times K} with the individual parameters,}
\item{Qir}{matrix of dimension \eqn{N \times R} representing \eqn{P_{ir}/\sum_r P_{ir}},}
\item{ranp}{vector indicating the variables with random parameters and their distribution,}
\item{probabilities}{the fitted probabilities for each individuals,}
\item{residuals}{the residuals,}
\item{call}{the matched call.}
}
\description{
Estimation of discrete choice models such as Binary (logit and probit), 
Poisson and Ordered (logit and probit) model with random coefficients for cross-sectional and panel data using simulated maximum likelihood.
}
\details{
The models are estimated using the \code{maxLik} function from \code{\link[maxLik]{maxLik}} package.


 If \code{ranp} is not \code{NULL}, the random parameter  model is estimated.   
 A random parameter model or random coefficient models permits regression parameter to 
 vary across individuals according to some distribution. A fully parametric 
 random parameter model specifies the latent variable  \eqn{y^{*}} conditional on regressors
 \eqn{x} and given parameters \eqn{\beta_i} to have conditional density \eqn{f(y|x, \beta_i)} where
 \eqn{\beta_i} are iid with density \eqn{g(\beta_i|\theta_i)}. The density is assumed a priori by the user by the argument
 \code{ranp}. If the parameters are assumed to be normally distributed \eqn{\beta_i ~ N(\beta, \Sigma)}, then the random parameter are constructed as: \deqn{\beta_{ir}=\beta+L\omega_{ir}} where \eqn{LL'=\Sigma} and \eqn{\omega_{ir}} is the {r}-th draw from standard normal distribution for individual \eqn{i}. 
 
 
 Once the model is specified by the argument \code{family}, the model is estimated using 
 Simulated Maximum Likelihood (SML). The probabilities, given by \eqn{f(y|x, \beta_i)}, are simulated using \code{R} pseudo-draws if \code{halton=NULL} or \code{R} halton draws if \code{halton = NA}. The user can also specified the primes and the number of dropped elements for the halton draws. For example, if the model consists of two random parameters, the user can specify \code{haltons = list("prime" = c(2, 3), "drop" = c(11, 11))}. 
 
 
 A random parameter hierarchical model can be estimated by including heterogeneity in the mean of the 
 random parameters: \deqn{\beta_{ir}=\beta+\pi's_i+L\omega_{ir}} \pkg{Rchoice} manages the variables in the hierarchical model by the \code{formula} object: all the hierarchical variables (\eqn{s_i}) are included after the \code{|} symbol. The argument \code{mvar} indicate which variables enter in each random parameter. See examples below
}
\examples{
## Probit model
data("Workmroz")
probit <- Rchoice(lfp ~ k5 + k618 + age + wc + hc + lwg + inc,  
                 data = Workmroz, family = binomial('probit'))
summary(probit)

## Poisson model
data("Articles")
poisson <- Rchoice(art ~ fem + mar + kid5 + phd + ment, data = Articles, family = poisson)
summary(poisson)

## Ordered probit model
data("Health")
oprobit <- Rchoice(newhsat ~ age + educ + hhinc + married + hhkids, 
data = Health, family = ordinal('probit'), subset = year == 1988)
summary(oprobit)

## Poisson Model with Random Parameters
\dontrun{
poisson.ran <- Rchoice(art ~ fem + mar + kid5 + phd + ment, 
                       data = Articles,  family = poisson,
                       ranp = c(kid5 = "n", phd = "n", ment = "n"))
summary(poisson.ran)                      

## Poisson Model with Correlated Random Parameters
poissonc.ran <- Rchoice(art ~ fem + mar + kid5 + phd + ment, 
                       data = Articles, 
                       ranp = c(kid5 = "n", phd = "n", ment = "n"), 
                       family = poisson, 
                       correlation =  TRUE)
summary(poissonc.ran)

## Hierarchical Poisson Model
poissonH.ran <- Rchoice(art ~ fem + mar + kid5 + phd + ment | fem + phd,
                       data = Articles,
                       ranp = c(kid5 = "n", phd = "n", ment = "n"),
                       mvar = list(phd = c("fem"), ment = c("fem", "phd")),
                       family = poisson,
                       R = 10)
summary(poissonH.ran)

## Probit Model with Random Effects and Random Parameters
data('Unions', package = 'pglm')
Unions$lwage <- log(Unions$wage)
union.ran <- Rchoice(union ~ age + exper + rural + lwage,
                     data = Unions[1:2000, ],
                     family = binomial('probit'),
                     ranp = c(constant = "n", lwage = "t"),
                     R = 10,
                     panel = TRUE,
                     index = "id",
                     print.init = TRUE)
summary(union.ran)

## Ordered Probit Model with Random Effects and Random Parameters
oprobit.ran <- Rchoice(newhsat ~ age + educ + married + hhkids + linc,
                     data = Health[1:2000, ],
                     family = ordinal('probit'),
                     ranp = c(constant = "n", hhkids = "n", linc = "n"),
                     panel = TRUE,
                     index = "id",
                     R = 100,
                     print.init = TRUE)
summary(oprobit.ran)
} 


}
\author{
Mauricio Sarrias \email{msarrias86@gmail.com}
}
\references{
Greene, W. H. (2012). Econometric Analysis. 7 edition. Prentice Hall.

Train, K. (2009). Discrete Choice Methods with Simulation. Cambridge university press.
}
\seealso{
\code{\link[Rchoice]{plot.Rchoice}}, \code{\link[Rchoice]{effect.Rchoice}}
}

