% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetprob.R
\name{hetprob}
\alias{hetprob}
\alias{terms.hetprob}
\alias{model.matrix.hetprob}
\alias{estfun.hetprob}
\alias{bread.hetprob}
\alias{vcov.hetprob}
\alias{df.residual.hetprob}
\alias{coef.hetprob}
\alias{logLik.hetprob}
\alias{print.hetprob}
\alias{summary.hetprob}
\alias{print.summary.hetprob}
\alias{predict.hetprob}
\title{Estimate heteroskedastic binary (Probit or Logit) model.}
\usage{
hetprob(formula, data, link = c("probit", "logit"), Hes = TRUE, ...)

\method{terms}{hetprob}(x, ...)

\method{model.matrix}{hetprob}(object, ...)

\method{estfun}{hetprob}(x, ...)

\method{bread}{hetprob}(x, ...)

\method{vcov}{hetprob}(object, eigentol = 1e-12, ...)

\method{df.residual}{hetprob}(object, ...)

\method{coef}{hetprob}(object, ...)

\method{logLik}{hetprob}(object, ...)

\method{print}{hetprob}(x, ...)

\method{summary}{hetprob}(object, eigentol = 1e-12, ...)

\method{print}{summary.hetprob}(x, digits = max(3, getOption("digits") - 2), ...)

\method{predict}{hetprob}(object, newdata = NULL, type = c("xb", "pr", "sigma"), ...)
}
\arguments{
\item{formula}{a symbolic description of the model of the form \code{y ~ x | z} where \code{y} is the binary dependent variable and \code{x} and \code{z} are regressors variables for the mean of the model and lnsigma.}

\item{data}{the data of class \code{data.frame}.}

\item{link}{the assumption of the distribution of the error term. It could be either \code{link = "probit"} or \code{link = "logit"}.}

\item{Hes}{logical. Should the analytic Hessian to be used? \code{TRUE} as default.}

\item{...}{arguments passed to \code{maxLik}.}

\item{x, object}{an object of class \code{hetprob}.}

\item{eigentol}{the standard errors are only calculated if the ratio of the smallest and largest eigenvalue of the Hessian matrix is less than \code{eigentol}.  Otherwise the Hessian is treated as singular.}

\item{digits}{the number of digits.}

\item{newdata}{optionally, a data frame in which to look for variables with which to predict.}

\item{type}{the type of prediction required. The default, \code{type = xb}, is on the linear prediction without the variance. If \code{type = pr}, the predicted probabilities of a positive outcome is returned. Finally, if \code{type = sigma} the predictions of \eqn{\sigma} for each individual is returned.}
}
\value{
An object of class ``\code{hetprob}'', a list elements:
\item{logLik0}{logLik for the homokedastic model,}
\item{f1}{the formula,}
\item{mf}{the model framed used,}
\item{call}{the matched call.}
}
\description{
Estimation of binary dependent variables, either probit or logit, with heteroskedastic error terms for cross-sectional dataset.
}
\details{
The heterokedastic binary model for cross-sectional data has the following structure:

\deqn{
y_i^*  = x_i^\top\beta + \epsilon_i,
}
with
\deqn{
var(\epsilon_i|x_i, z_i)  = \sigma_i^2 = \left[\exp\left(z_i^\top\delta\right)\right]^2,   
}
where \eqn{y_i^*} is the latent (unobserved) dependent variable for individual \eqn{i = 1,...,N}; 
\eqn{x_i} is a \eqn{K\times 1} vector of independent variables determining the latent variable \eqn{y_i^*} (\code{x} variables in \code{formula}); 
and \eqn{\epsilon_i} is the error term distributed either normally or logistically with \eqn{E(\epsilon_i|z_i, x_i) = 0} 
and heterokedastic variance \eqn{var(\epsilon_i|x_i, z_i)  = \sigma_i^2, \forall i = 1,...,N}. 
The variance for each individual is modeled parametrically assuming that it depends on a \eqn{P\times 1} 
vector observed variables \eqn{z_i} (\code{z} in \code{formula}), whereas \eqn{\delta} is the vector of parameters associated with each variable. 
It is important to emphasize that \eqn{z_i} does not include a constant, otherwise the parameters are not identified.

The models are estimated using the \code{maxLik} function from \code{\link[maxLik]{maxLik}} package using both 
analytic gradient and hessian  (if \code{Hess = TRUE}). In particular, the log-likelihood function is:

\deqn{\log L(\theta) = \sum_i^n\log \left\lbrace \left[1- F\left(\frac{x_i^\top\beta}{\exp(z_i^\top\delta)}\right)\right]^{1-y_i}\left[F\left(\frac{x_i^\top\beta}{\exp(z_i^\top\delta)}\right)\right]^{y_i}\right\rbrace.}
}
\examples{
\donttest{
# Estimate a heteroskedastic probit and logit model
data("Health")

het.probit <- hetprob(working ~ factor(female) + factor(year) + educ + age + I(age^2) | 
                                factor(female) + age + I(age^2), 
                     data = Health, 
                     link = "probit")
summary(het.probit)

het.logit <- hetprob(working ~ factor(female) + factor(year) + educ + age + I(age^2) | 
                               factor(female) + age + I(age^2), 
                    data = Health, 
                    link = "logit")
summary(het.logit)
}
}
\references{
Greene, W. H. (2012). Econometric Analysis. 7 edition. Prentice Hall.
}
\author{
Mauricio Sarrias.
}
\keyword{models}
