% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleView.R
\name{analyzePlot}
\alias{analyzePlot}
\title{Plot for data exploration/analysis}
\usage{
analyzePlot(
  nb,
  data.sample,
  selectedVar,
  type = "boxplot",
  hscale = 1.2,
  K.max = 20,
  fontsize = 11
)
}
\arguments{
\item{nb}{notebook in which the analyze plot will be added.}

\item{data.sample}{list containing features, profiles and clustering results.}

\item{selectedVar}{character vector containing the selected variables names to analyze.}

\item{type}{character vector specifying the analysis type. Must be 'boxplot', 'gapSE', 'histo', 'pcaCorr' or 'pcaVar'.}

\item{hscale}{numeric value corresponding to the horizontal scale of graphic.}

\item{K.max}{maximal number of clusters (K.Max=20 by default).}

\item{fontsize}{size of font (fontsize=11 by default).}
}
\value{
None
}
\description{
Create some specific plots for data exploration/analysis.
}
\details{
analyzePlot creates specific plot for data exploration/analysis.
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 6, sd = 0.3), ncol = 2))
colnames(dat) <- c("x","y")
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")

x <- importSample(file.features=tf, dir.save=tempdir())

mainWindow <- tktoplevel()
tktitle(mainWindow) <- "Barplot clustering"  
mainWindow$env$nb <- tk2notebook(mainWindow, tabs = c())
tkpack(mainWindow$env$nb, fill="both", expand= TRUE)

analyzePlot(mainWindow$env$nb, x, selectedVar="x", type="boxplot")
 

}
\keyword{internal}
