% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeSpectral.R
\name{computeGaussianSimilarity}
\alias{computeGaussianSimilarity}
\title{Gaussian similarity}
\usage{
computeGaussianSimilarity(dat, sigma)
}
\arguments{
\item{dat}{numeric matrix of data (point by line).}

\item{sigma}{smooth parameter of Gaussian kernel.}
}
\value{
sim similarity matrix.
}
\description{
Compute a similarity matrix thanks a Gaussian kernel from a data matrix.
}
\details{
computeGaussianSimilarity returns a similarity matrix computed thanks a Gaussian kernel
}
\examples{
require(grDevices)

dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))

sim <- computeGaussianSimilarity(dat, 1)

pal <- colorRampPalette(c("blue", "red"))
image(sim, col = pal(10))
}
\references{
U. Von Luxburg, A tutorial on spectral clustering, Statist. Comput., 17 (4) (2007), pp. 395-416
}
\seealso{
\code{\link{computeGaussianSimilarityZP}}
}
\keyword{internal}
