% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_flatten.R
\name{cdb_flatten}
\alias{cdb_flatten}
\title{Convert a COM(P)ADRE database to a flat data frame with matrices and vectors
stored in string representation}
\usage{
cdb_flatten(cdb)
}
\arguments{
\item{cdb}{A CompadreDB object}
}
\value{
A data frame based on the data slot of \code{cdb}, but with the
  column \code{mat} replaced by six separate columns (for matrices
  \code{matA}, \code{matU}, \code{matF}, \code{matC}, and vectors
  \code{MatrixClassAuthor}, and \code{MatrixClassOrganized}), whose elements
  are matrices or vectors in string representation.
}
\description{
Converts a CompadreDB object to a flat data frame by extracting the data
slot, and splitting the \code{mat} column into separate columns for each
component (matrices \code{matA}, \code{matU}, \code{matF}, \code{matC}, and
vectors \code{MatrixClassAuthor}, and \code{MatrixClassOrganized}). The
component matrices and vectors within the six new columns are stored in
string format so that the database can be written to a flat file format such
as csv (see \link{string_representation}).
}
\examples{
CompadreFlat <- cdb_flatten(Compadre)

}
\seealso{
\link{cdb_unflatten} \link{string_representation}

Other data management: 
\code{\link{cdb_id_stages}()},
\code{\link{cdb_id_studies}()},
\code{\link{cdb_id}()},
\code{\link{cdb_mean_matF}()},
\code{\link{cdb_rbind}()},
\code{\link{cdb_unflatten}()},
\code{\link{cdb_unnest}()},
\code{\link{mpm_mean}()},
\code{\link{mpm_median}()},
\code{\link{mpm_sd}()},
\code{\link{string_representation}}
}
\author{
Owen R. Jones <jones@biology.sdu.dk>

Patrick M. Barks <patrick.barks@gmail.com>
}
\concept{data management}
