% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpm_sd.R
\name{mpm_sd}
\alias{mpm_sd}
\alias{mat_sd}
\title{Calculate a standard deviation over a list of matrices or CompadreMat objects}
\usage{
mat_sd(x, na.rm = FALSE)

mpm_sd(x, na.rm = FALSE)
}
\arguments{
\item{x}{A list of matrices or, for \code{mpm_sd} a list of `CompadreMat` objects,
all of the same dimension}

\item{na.rm}{Logical indicating whether missing values should be excluded
(see \emph{Details}). Defaults to \code{FALSE}.}
}
\value{
A matrix containing the standard deviation of each element across all
  matrices in the list
}
\description{
Calculates an element-wise standard deviation over a list of matrices or
CompadreMat objects of constant dimension.
}
\details{
The difference between function \code{mat_sd}) and (\code{mpm_sd} is that
\code{mat_sd} takes input as a list of matrices (e.g., a list of **A**
matrices) while \code{mat_sd} takes input as a list of `CompadreMat` objects and
thus calculates the mean matrices for both the **A** matrix and its
submatrices (**U**, **F**, **C**).


If \code{na.rm == TRUE}, missing values are ignored in the calculation of the
mean matrix. If \code{na.rm == TRUE} and a given element is \code{NA} in
\emph{every} matrix within \code{x}, the value returned for that element will
be \code{0}.
}
\examples{
# set seed for repeatability
set.seed(42)

# create a function that generates a matrix with random values
create_matrix <- function() {
  matrix(runif(9, 0, 1), nrow = 3)
}

# use replicate() to call the create_matrix() function 20 times
mat_list <- replicate(20, create_matrix(), simplify = FALSE)

# get the sd matrix
mat_sd(mat_list)

# If the matrices are in an RCompadre object, extract them using `matA` before
# passing to `mat_sd`
my_compadre <- cdb_build_cdb(mat_a = mat_list)
mat_sd(matA(my_compadre))
}
\seealso{
Other data management: 
\code{\link{cdb_flatten}()},
\code{\link{cdb_id_stages}()},
\code{\link{cdb_id_studies}()},
\code{\link{cdb_id}()},
\code{\link{cdb_mean_matF}()},
\code{\link{cdb_rbind}()},
\code{\link{cdb_unflatten}()},
\code{\link{cdb_unnest}()},
\code{\link{mpm_mean}()},
\code{\link{mpm_median}()},
\code{\link{string_representation}}
}
\author{
Darren Norris

Owen R. Jones <jones@biology.sdu.dk>
}
\concept{data management}
