// Copyright (c) 2006,2007,2009,2010,2011 Tel-Aviv University (Israel).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org).
//
// $URL: https://github.com/CGAL/cgal/blob/v5.6.1/Arrangement_on_surface_2/include/CGAL/Arrangement_2/Arr_default_planar_topology.h $
// $Id: Arr_default_planar_topology.h 2a3fbc0 2019-11-19T09:47:44+02:00 Efi Fogel
// SPDX-License-Identifier: GPL-3.0-or-later OR LicenseRef-Commercial
//
//
// Author(s): Ron Wein          <wein@post.tau.ac.il>
//            Eric Berberich    <ericb@post.tau.ac.il>

#ifndef CGAL_ARR_DEFAULT_PLANAR_TOPOLOGY_H
#define CGAL_ARR_DEFAULT_PLANAR_TOPOLOGY_H

#include <CGAL/license/Arrangement_on_surface_2.h>


/*! \file
 * Definition of a helper template that uses partial specialization to
 * select the default planar topology-traits class best fit for a
 * given geometry-traits class.
 */

#include <CGAL/tags.h>
#include <CGAL/Arr_tags.h>
#include <CGAL/Arr_bounded_planar_topology_traits_2.h>
#include <CGAL/Arr_unb_planar_topology_traits_2.h>

namespace CGAL {

namespace internal {

template <typename GeomTraits, typename Dcel, typename Tag>
struct Default_planar_topology_impl {};

template <typename GeomTraits, typename Dcel>
struct Default_planar_topology_impl<GeomTraits, Dcel,
                                    Arr_all_sides_oblivious_tag>
{
  // A topology-traits class that supports only bounded curves:
  typedef Arr_bounded_planar_topology_traits_2<GeomTraits, Dcel>    Traits;

};

template <typename GeomTraits, typename Dcel>
struct Default_planar_topology_impl<GeomTraits, Dcel,
                                    Arr_not_all_sides_oblivious_tag>
{
  // A topology-traits class that supports unbounded curves:
  typedef Arr_unb_planar_topology_traits_2<GeomTraits, Dcel>        Traits;
};

} // namespace internal

template <typename GeomTraits, typename Dcel>
struct Default_planar_topology :
  public internal::Default_planar_topology_impl<
    GeomTraits, Dcel,
    typename Arr_all_sides_oblivious_category<
      typename internal::Arr_complete_left_side_category<GeomTraits>::Category,
      typename internal::Arr_complete_bottom_side_category<GeomTraits>::Category,
      typename internal::Arr_complete_top_side_category<GeomTraits>::Category,
      typename internal::Arr_complete_right_side_category<GeomTraits>::Category>::result
>
{};

} //namespace CGAL

#endif

